/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u3A\u0001D\u0007\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003BB\u0018\u0001A\u0003%q\u0005C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003A\u0001\u0011\u0005\u0011\u0007C\u0003C\u0001\u0011\u0005\u0011\u0007C\u0003E\u0001\u0011\u0005\u0011\u0007C\u0003G\u0001\u0011\u0005\u0011\u0007C\u0003I\u0001\u0011\u0005\u0011\u0007C\u0003K\u0001\u0011\u00051\nC\u0003U\u0001\u0011\u0005QKA\u000eQe>TWm\u0019;j_:\u001cu\u000eZ3HK:,'/\u0019;peR+7\u000f\u001e\u0006\u0003\u001d=\tqaY8eK\u001e,gN\u0003\u0002\u0011#\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\n\u0014\u0003\u0015!\u0018M\u00197f\u0015\t!R#A\u0003gY&t7N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u000e\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013FA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018\u0001D2mCN\u001cHj\\1eKJ\u0004\u0013a\u0006;fgR\u0004&o\u001c6fGRLwN\u001c\"j]\u0006\u0014\u0018PU8x)\u0005\u0011\u0004C\u0001\u000f4\u0013\t!TD\u0001\u0003V]&$\bF\u0001\u00037!\t9d(D\u00019\u0015\tI$(A\u0002ba&T!a\u000f\u001f\u0002\u000f),\b/\u001b;fe*\u0011QhF\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u007fa\u0012A\u0001V3ti\u0006AB/Z:u!J|'.Z2uS>tw)\u001a8fe&\u001c'k\\<)\u0005\u00151\u0014a\u0006;fgR\u0004&o\u001c6fGRLwN\\'b]f4\u0015.\u001a7eQ\t1a'A\u0011uKN$\bK]8kK\u000e$\u0018n\u001c8NC:Lh)[3mI\u001e+g.\u001a:jGJ{w\u000f\u000b\u0002\bm\u0005iC/Z:u!J|'.Z2uS>t')\u001b8bef\u0014vn^,ji\"4\u0016M]5bE2,G*\u001a8hi\"$\u0015\r^1)\u0005!1\u0014\u0001\u000b;fgR\u0004&o\u001c6fGRLwN\\,ji\"Le\u000eZ3qK:$WM\u001c;OC6,7i\\;oi\u0016\u0014\bFA\u00057\u0003\tQ\u0017\u000e\u0006\u0002M\u001fB\u0011\u0001&T\u0005\u0003\u001d&\u0012q!\u00138uK\u001e,'\u000fC\u0003Q\u0015\u0001\u0007\u0011+A\u0001j!\ta\"+\u0003\u0002T;\t\u0019\u0011J\u001c;\u0002\u0005)dGC\u0001,Z!\tAs+\u0003\u0002YS\t!Aj\u001c8h\u0011\u0015Q6\u00021\u0001\\\u0003\u0005a\u0007C\u0001\u000f]\u0013\tAV\u0004")
public class ProjectionCodeGeneratorTest {
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private ClassLoader classLoader() {
        return this.classLoader;
    }

    @Test
    public void testProjectionBinaryRow() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).newInstance(this.classLoader());
        BinaryRowData row = (BinaryRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{this.ji(5), this.jl(8L)}));
        Assertions.assertEquals((int)5, (int)row.getInt(1));
        Assertions.assertEquals((long)8L, (long)row.getLong(0));
    }

    @Test
    public void testProjectionGenericRow() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}, GenericRowData.class).newInstance(this.classLoader());
        GenericRowData row = (GenericRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{this.ji(5), this.jl(8L)}));
        Assertions.assertEquals((int)5, (int)row.getInt(1));
        Assertions.assertEquals((long)8L, (long)row.getLong(0));
    }

    @Test
    public void testProjectionManyField() {
        RowType rowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$1 -> ProjectionCodeGeneratorTest.$anonfun$testProjectionManyField$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IntType.class))));
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", rowType, rowType, (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).toArray(ClassTag$.MODULE$.Int())).newInstance(this.classLoader());
        Random rnd = new Random();
        GenericRowData input = GenericRowData.of((Object[])((Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$2 -> this.ji(rnd.nextInt()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class))));
        BinaryRowData row = (BinaryRowData)projection.apply((RowData)input);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)input.getInt(i), (int)row.getInt(i)));
    }

    @Test
    public void testProjectionManyFieldGenericRow() {
        RowType rowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$3 -> ProjectionCodeGeneratorTest.$anonfun$testProjectionManyFieldGenericRow$1(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IntType.class))));
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", rowType, rowType, (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).toArray(ClassTag$.MODULE$.Int()), GenericRowData.class).newInstance(this.classLoader());
        Random rnd = new Random();
        GenericRowData input = GenericRowData.of((Object[])((Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$4 -> this.ji(rnd.nextInt()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class))));
        GenericRowData row = (GenericRowData)projection.apply((RowData)input);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)input.getInt(i), (int)row.getInt(i)));
    }

    @Test
    public void testProjectionBinaryRowWithVariableLengthData() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new DecimalType(38, 0), new DecimalType(38, 0), new TimestampType(9)}), RowType.of((LogicalType[])new LogicalType[]{new DecimalType(38, 0), new TimestampType(9), new DecimalType(38, 0)}), new int[]{1, 2, 0}).newInstance(this.classLoader());
        DecimalData decimal = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(123L), (int)38, (int)0);
        TimestampData timestamp = TimestampData.fromEpochMillis((long)123L);
        BinaryRowData expected = new BinaryRowData(3);
        BinaryRowWriter writer = new BinaryRowWriter(expected);
        writer.writeDecimal(0, decimal, 38);
        writer.writeTimestamp(1, timestamp, 9);
        writer.writeDecimal(2, decimal, 38);
        writer.complete();
        BinaryRowData actual = (BinaryRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{decimal, decimal, timestamp}));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testProjectionWithIndependentNameCounter() {
        String projectionCode1 = ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).getCode();
        String projectionCode2 = ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).getCode();
        Assertions.assertEquals((Object)projectionCode1, (Object)projectionCode2);
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    public static final /* synthetic */ IntType $anonfun$testProjectionManyField$1(int x$1) {
        return new IntType();
    }

    public static final /* synthetic */ IntType $anonfun$testProjectionManyFieldGenericRow$1(int x$3) {
        return new IntType();
    }
}

