/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.codegen.LongHashJoinGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.Int2AdaptiveHashJoinOperatorTest;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;

class LongAdaptiveHashJoinGeneratorTest
extends Int2AdaptiveHashJoinOperatorTest {
    LongAdaptiveHashJoinGeneratorTest() {
    }

    public Object newOperator(long memorySize, FlinkJoinType flinkJoinType, HashJoinType hashJoinType, boolean buildLeft, boolean reverseJoinFunction) {
        return LongAdaptiveHashJoinGeneratorTest.getLongHashJoinOperator(flinkJoinType, hashJoinType, buildLeft, reverseJoinFunction);
    }

    protected void testBuildLeftAntiJoinFallbackToSMJ() {
    }

    protected void testBuildLeftSemiJoinFallbackToSMJ() {
    }

    protected void testBuildFirstHashLeftOutJoinFallbackToSMJ() {
    }

    protected void testBuildSecondHashRightOutJoinFallbackToSMJ() {
    }

    protected void testBuildFirstHashFullOutJoinFallbackToSMJ() {
    }

    static Object getLongHashJoinOperator(FlinkJoinType flinkJoinType, HashJoinType hashJoinType, boolean buildLeft, boolean reverseJoinFunction) {
        RowType keyType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
        boolean[] filterNulls = new boolean[]{true};
        Assertions.assertThat((boolean)LongHashJoinGenerator.support((HashJoinType)hashJoinType, (RowType)keyType, (boolean[])filterNulls)).isTrue();
        RowType buildType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType()});
        RowType probeType = RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType()});
        int[] buildKeyMapping = new int[]{0};
        int[] probeKeyMapping = new int[]{0};
        GeneratedJoinCondition condFunc = new GeneratedJoinCondition(Int2HashJoinOperatorTestBase.MyJoinCondition.class.getCanonicalName(), "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTestBase.MyJoinCondition(new Object[0]);
            }
        };
        SortMergeJoinFunction sortMergeJoinFunction = buildLeft ? SorMergeJoinOperatorUtil.getSortMergeJoinFunction((ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)ExecNodeConfig.ofNodeConfig((ReadableConfig)new Configuration(), (boolean)false), (FlinkJoinType)flinkJoinType, (RowType)buildType, (RowType)probeType, (int[])buildKeyMapping, (int[])probeKeyMapping, (RowType)keyType, (boolean)buildLeft, (boolean[])filterNulls, (GeneratedJoinCondition)condFunc, (double)0.0) : SorMergeJoinOperatorUtil.getSortMergeJoinFunction((ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)ExecNodeConfig.ofNodeConfig((ReadableConfig)new Configuration(), (boolean)false), (FlinkJoinType)flinkJoinType, (RowType)probeType, (RowType)buildType, (int[])probeKeyMapping, (int[])buildKeyMapping, (RowType)keyType, (boolean)buildLeft, (boolean[])filterNulls, (GeneratedJoinCondition)condFunc, (double)0.0);
        return LongHashJoinGenerator.gen((ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (HashJoinType)hashJoinType, (RowType)keyType, (RowType)buildType, (RowType)probeType, (int[])buildKeyMapping, (int[])probeKeyMapping, (int)20, (long)10000L, (boolean)reverseJoinFunction, (GeneratedJoinCondition)condFunc, (boolean)buildLeft, (boolean)((Boolean)ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED.defaultValue()), (int)((int)((MemorySize)ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE.defaultValue()).getBytes()), (SortMergeJoinFunction)sortMergeJoinFunction);
    }
}

