/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class UnknownCatalogTest {
    public static final String BUILTIN_CATALOG = "cat";
    private static final String BUILTIN_DATABASE = "db";
    public static final EnvironmentSettings ENVIRONMENT_SETTINGS = EnvironmentSettings.newInstance().inStreamingMode().withBuiltInCatalogName("cat").withBuiltInDatabaseName("db").build();
    public static final ResolvedSchema EXPECTED_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"i", (DataType)DataTypes.INT()), Column.physical((String)"s", (DataType)DataTypes.STRING())});
    public static final ResolvedSchema CURRENT_TIMESTAMP_EXPECTED_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"CURRENT_TIMESTAMP", (DataType)((DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull()))});

    UnknownCatalogTest() {
    }

    @Test
    void testUnsetCatalogWithSelectCurrentTimestamp() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        Table table = tEnv.sqlQuery("SELECT CURRENT_TIMESTAMP");
        Assertions.assertThat((Object)table.getResolvedSchema()).isEqualTo((Object)CURRENT_TIMESTAMP_EXPECTED_SCHEMA);
    }

    @Test
    void testSetCatalogUnsetDatabaseWithSelectCurrentTimestamp() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(BUILTIN_CATALOG);
        tEnv.useDatabase(null);
        Table table = tEnv.sqlQuery("SELECT CURRENT_TIMESTAMP");
        Assertions.assertThat((Object)table.getResolvedSchema()).isEqualTo((Object)CURRENT_TIMESTAMP_EXPECTED_SCHEMA);
    }

    @Test
    void testSetCatalogWithSelectCurrentTimestamp() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(BUILTIN_CATALOG);
        Table table = tEnv.sqlQuery("SELECT CURRENT_TIMESTAMP");
        Assertions.assertThat((Object)table.getResolvedSchema()).isEqualTo((Object)CURRENT_TIMESTAMP_EXPECTED_SCHEMA);
    }

    @Test
    void testUnsetCatalogWithShowFunctions() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        TableResult table = tEnv.executeSql("SHOW FUNCTIONS");
        List functions = CollectionUtil.iteratorToList((Iterator)table.collect());
        Assertions.assertThat((List)functions).hasSizeGreaterThan(0);
    }

    @ParameterizedTest(name="{index}: {0}")
    @ValueSource(strings={"SHOW TABLES", "SHOW TABLES IN db", "SHOW VIEWS", "SHOW VIEWS IN db", "SHOW PROCEDURES", "SHOW PROCEDURES IN db", "SHOW COLUMNS IN db", "SHOW DATABASES"})
    void showForUnsetCatalog(String sql) {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.executeSql(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("A current catalog has not been set");
    }

    @ParameterizedTest(name="{index}: {0}")
    @ValueSource(strings={"SHOW TABLES", "SHOW VIEWS", "SHOW PROCEDURES", "SHOW COLUMNS IN db"})
    void showForUnsetDatabase(String sql) {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(BUILTIN_CATALOG);
        tEnv.useDatabase(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.executeSql(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("A current database has not been set");
    }

    @Test
    void testUnsetCatalogWithFullyQualified() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        Table table = tEnv.sqlQuery(String.format("SELECT * FROM %s", tablePath));
        Assertions.assertThat((Object)table.getResolvedSchema()).isEqualTo((Object)EXPECTED_SCHEMA);
    }

    @Test
    void testUnsetCatalogWithSingleIdentifier() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.sqlQuery("SELECT * FROM tb")).isInstanceOf(ValidationException.class)).hasMessageContaining(String.format("Object '%s' not found", "tb"));
    }

    @Test
    void testUsingUnknownDatabaseWithDatabaseQualified() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useDatabase(null);
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        Table table = tEnv.sqlQuery(String.format("SELECT * FROM %s.%s", BUILTIN_DATABASE, "tb"));
        Assertions.assertThat((Object)table.getResolvedSchema()).isEqualTo((Object)EXPECTED_SCHEMA);
    }

    @Test
    void testUsingUnknownDatabaseWithSingleIdentifier() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useDatabase(null);
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.sqlQuery("SELECT * FROM tb")).isInstanceOf(ValidationException.class)).hasMessageContaining(String.format("Object '%s' not found", "tb"));
    }

    @Test
    void testUnsetCatalogWithAlterTable() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useCatalog(null);
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.executeSql(String.format("ALTER TABLE %s ADD (f STRING)", "tb"))).isInstanceOf(ValidationException.class)).hasMessage("A current catalog has not been set. Please use a fully qualified identifier (such as 'my_catalog.my_database.my_table') or set a current catalog using 'USE CATALOG my_catalog'.");
    }

    @Test
    void testUnsetDatabaseWithAlterTable() {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        tEnv.useDatabase(null);
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", BUILTIN_CATALOG, BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.executeSql(String.format("ALTER TABLE %s ADD (f STRING)", "tb"))).isInstanceOf(ValidationException.class)).hasMessage("A current database has not been set. Please use a fully qualified identifier (such as 'my_database.my_table' or 'my_catalog.my_database.my_table') or set a current database using 'USE my_database'.");
    }

    @Test
    void testUnsetDatabaseComingFromCatalogWithAlterTable() throws Exception {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)ENVIRONMENT_SETTINGS);
        String catalogName = "custom";
        NullDefaultDatabaseCatalog catalog = new NullDefaultDatabaseCatalog("custom");
        catalog.createDatabase(BUILTIN_DATABASE, (CatalogDatabase)new CatalogDatabaseImpl(Collections.emptyMap(), null), false);
        tEnv.registerCatalog("custom", (Catalog)catalog);
        tEnv.useCatalog("custom");
        String tableName = "tb";
        String tablePath = String.format("%s.%s.%s", "custom", BUILTIN_DATABASE, "tb");
        UnknownCatalogTest.registerTable(tEnv, tablePath);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.executeSql(String.format("ALTER TABLE %s ADD (f STRING)", "tb"))).isInstanceOf(ValidationException.class)).hasMessage("A current database has not been set. Please use a fully qualified identifier (such as 'my_database.my_table' or 'my_catalog.my_database.my_table') or set a current database using 'USE my_database'.");
    }

    private static void registerTable(TableEnvironment tEnv, String tableName) {
        String input1DataId = TestValuesTableFactory.registerData(Arrays.asList(Row.of((Object[])new Object[]{1, "a"}), Row.of((Object[])new Object[]{2, "b"})));
        tEnv.createTable(tableName, TableDescriptor.forConnector((String)"values").option("data-id", input1DataId).schema(Schema.newBuilder().fromResolvedSchema(EXPECTED_SCHEMA).build()).build());
    }

    private static class NullDefaultDatabaseCatalog
    extends GenericInMemoryCatalog {
        public NullDefaultDatabaseCatalog(String name) {
            super(name);
        }

        public String getDefaultDatabase() {
            return null;
        }
    }
}

