/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Collection;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.catalog.DatabaseCalciteSchema;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DatabaseCalciteSchemaTest {
    private static final String TABLE_NAME = "tab";

    DatabaseCalciteSchemaTest() {
    }

    @Test
    void testPermanentTableWithPrimaryKey() {
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        DatabaseCalciteSchema calciteSchema = new DatabaseCalciteSchema(CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, catalogManager, true);
        catalogManager.createTable(this.createTable(), ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)TABLE_NAME), false);
        Table table = calciteSchema.getTable(TABLE_NAME);
        Assertions.assertThat((Object)table).isInstanceOf(CatalogSchemaTable.class);
        Assertions.assertThat((Collection)((Collection)((CatalogSchemaTable)table).getStatistic().getUniqueKeys().iterator().next())).containsExactlyInAnyOrder((Object[])new String[]{"a", "b"});
    }

    @Test
    void testTemporaryTableWithPrimaryKey() {
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        DatabaseCalciteSchema calciteSchema = new DatabaseCalciteSchema("other_catalog", "other_database", catalogManager, true);
        catalogManager.createTemporaryTable(this.createTable(), ObjectIdentifier.of((String)"other_catalog", (String)"other_database", (String)TABLE_NAME), false);
        Table table = calciteSchema.getTable(TABLE_NAME);
        Assertions.assertThat((Object)table).isInstanceOf(CatalogSchemaTable.class);
        Assertions.assertThat((Collection)((Collection)((CatalogSchemaTable)table).getStatistic().getUniqueKeys().iterator().next())).containsExactlyInAnyOrder((Object[])new String[]{"a", "b"});
    }

    private CatalogBaseTable createTable() {
        Schema schema = Schema.newBuilder().column("a", DataTypes.INT().notNull()).column("b", DataTypes.STRING().notNull()).column("c", (AbstractDataType)DataTypes.STRING()).primaryKey(new String[]{"a", "b"}).build();
        return CatalogTable.newBuilder().schema(schema).build();
    }
}

