/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.catalog.CatalogViewITCase$;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\r\u001b\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013!\u0005B\u0002%\u0001A\u0003%Q\tC\u0003J\u0001\u0011\u0005!\nC\u0003Y\u0001\u0011\r\u0011\fC\u0003m\u0001\u0011\u0005Q\u000eC\u0003w\u0001\u0011\u0005!\nC\u0003|\u0001\u0011\u0005!\nC\u0003~\u0001\u0011\u0005!\nC\u0003\u0000\u0001\u0011\u0005!\nC\u0004\u0002\u0004\u0001!I!!\u0002\t\r\u00055\u0001\u0001\"\u0001K\u0011\u0019\t\t\u0002\u0001C\u0001\u0015\"1\u0011Q\u0003\u0001\u0005\u0002)Ca!!\u0007\u0001\t\u0003Q\u0005BBA\u000f\u0001\u0011\u0005!\n\u0003\u0004\u0002\"\u0001!\tAS\u0004\b\u0003\u001fR\u0002\u0012AA)\r\u0019I\"\u0004#\u0001\u0002T!1QG\u0006C\u0001\u00037Bq!!\u0018\u0017\t\u0003\tyFA\tDCR\fGn\\4WS\u0016<\u0018\nV\"bg\u0016T!a\u0007\u000f\u0002\u000f\r\fG/\u00197pO*\u0011QDH\u0001\ba2\fgN\\3s\u0015\ty\u0002%A\u0003uC\ndWM\u0003\u0002\"E\u0005)a\r\\5oW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-b\u0012!B;uS2\u001c\u0018BA\u0017+\u0005=!\u0016M\u00197f\u0013R\u001b\u0015m]3CCN,\u0017aD5t'R\u0014X-Y7j]\u001elu\u000eZ3\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\"aN\u001d\u0011\u0005a\u0002Q\"\u0001\u000e\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u0011M,G\u000f^5oON,\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fy\t1!\u00199j\u0013\t\teHA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005AA/\u00192mK\u0016sg/F\u0001F!\tid)\u0003\u0002H}\t\u0001B+\u00192mK\u0016sg/\u001b:p]6,g\u000e^\u0001\ni\u0006\u0014G.Z#om\u0002\naAY3g_J,G#A&\u0011\u0005Ab\u0015BA'2\u0005\u0011)f.\u001b;)\u0005\u001dy\u0005C\u0001)W\u001b\u0005\t&BA S\u0015\t\u0019F+A\u0004kkBLG/\u001a:\u000b\u0005U#\u0013!\u00026v]&$\u0018BA,R\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\fe><xJ\u001d3fe&tw-F\u0001[!\rY6M\u001a\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u000122\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0011=\u0013H-\u001a:j]\u001eT!AY\u0019\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u0004\u0013!\u0002;za\u0016\u001c\u0018BA6i\u0005\r\u0011vn^\u0001\u0006i>\u0014vn\u001e\u000b\u0003M:DQa\\\u0005A\u0002A\fA!\u0019:hgB\u0019\u0001']:\n\u0005I\f$A\u0003\u001fsKB,\u0017\r^3e}A\u0011\u0001\u0007^\u0005\u0003kF\u00121!\u00118z\u0003y!Xm\u001d;De\u0016\fG/\u001a,jK^LeMT8u\u000bbL7\u000f^:Uo&\u001cW\r\u000b\u0002\u000bqB\u0011\u0001+_\u0005\u0003uF\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016\f\u0011\u0006^3ti\u000e\u0013X-\u0019;f-&,woV5uQ>,HOR5fY\u0012d\u0015n\u001d;B]\u0012<\u0016\u000e\u001e5Ti\u0006\u0014\bFA\u0006y\u0003]!Xm\u001d;De\u0016\fG/\u001a+f[B|'/\u0019:z-&,w\u000f\u000b\u0002\rq\u0006qC/Z:u)\u0016l\u0007o\u001c:bef4\u0016.Z<NCN\\\u0007+\u001a:nC:,g\u000e\u001e,jK^<\u0016\u000e\u001e5TC6,g*Y7fQ\ti\u00010\u0001\u000bck&dG\rV1cY\u0016$Um]2sSB$xN\u001d\u000b\u0003\u0003\u000f\u00012!PA\u0005\u0013\r\tYA\u0010\u0002\u0010)\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u00069C/Z:u'\"|wo\u0011:fCR,\u0017+^3ss>\u0003XM]1uS>t7)\u0019;bY><g+[3xQ\ty\u00010A\u000euKN$8\u000b[8x\u0007J,\u0017\r^3UK6\u0004xN]1ssZKWm\u001e\u0015\u0003!a\f\u0011\u0004^3tiNCwn^\"sK\u0006$XmQ1uC2|wMV5fo\"\u0012\u0011\u0003_\u0001&i\u0016\u001cHo\u00155po\u000e\u0013X-\u0019;f-&,woV5uQ2+g\r\u001e&pS:<%o\\;q\u0005fD#A\u0005=\u0002EQ,7\u000f^*i_^\u001c%/Z1uKZKWm^,ji\",FIR(vi\u0016\u0014(j\\5oQ\t\u0019\u00020A\u0010uKN$8\u000b[8x\u0007J,\u0017\r^3WS\u0016<x+\u001b;i\u0013:tWM\u001d&pS:D#\u0001\u0006=)\u000f\u0001\t9#a\r\u00026A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.E\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAA\u001cG\t\tI\u0004\u0005\u0003\u0002<\u0005-SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\t\u0019%!\u0012\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002V\u0003\u000fR1!!\u0013!\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0002N\u0005u\"A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017!E\"bi\u0006dwn\u001a,jK^LEkQ1tKB\u0011\u0001HF\n\u0004-\u0005U\u0003c\u0001\u0019\u0002X%\u0019\u0011\u0011L\u0019\u0003\r\u0005s\u0017PU3g)\t\t\t&\u0001\u0006qCJ\fW.\u001a;feN$\"!!\u0019\u0011\u000b\u0005\r\u0014QN\u0018\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nA!\u001e;jY*\u0011\u00111N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0005\u0015$AC\"pY2,7\r^5p]\":\u0001$a\u001d\u0002z\u0005m\u0004\u0003BA\u001e\u0003kJA!a\u001e\u0002>\tQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003{\n1a\u001f\u0019~\u0001")
public class CatalogViewITCase
extends TableITCaseBase {
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogViewITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    @BeforeEach
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public Row toRow(Seq<Object> args) {
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return row;
    }

    @TestTemplate
    public void testCreateViewIfNotExistsTwice() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewWith3ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String viewWith2ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e) AS SELECT a, b FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewWith3ColumnDDL);
        this.tableEnv().executeSql(viewWith2ColumnDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testCreateViewWithoutFieldListAndWithStar() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT * FROM T1\n      ")).stripMargin();
        String query = "SELECT * FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testCreateTemporaryView() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testTemporaryViewMaskPermanentViewWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String permanentView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        .colon.colon permanentViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String temporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW IF NOT EXISTS T3 AS SELECT a, b, c+1 FROM T1\n      ")).stripMargin();
        .colon.colon temporaryViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(permanentView);
        this.tableEnv().executeSql(temporaryView);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT * FROM T3";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)temporaryViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY VIEW IF EXISTS T3\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryView);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)permanentViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    private TableDescriptor buildTableDescriptor() {
        TableDescriptor tableDescriptor = TableFactoryHarness.newBuilder().boundedScanSource().schema(Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.STRING()).column("c", (AbstractDataType)DataTypes.INT()).build()).sink().build();
        return tableDescriptor;
    }

    @TestTemplate
    public void testShowCreateQueryOperationCatalogView() {
        Table table = this.tableEnv().from(this.buildTableDescriptor());
        this.tableEnv().createTemporaryView("QueryOperationCatalogView", table);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.tableEnv().executeSql("show create view QueryOperationCatalogView")).hasMessageContaining("SHOW CREATE VIEW is not supported for views registered by Table API.") instanceof TableException;
    }

    @TestTemplate
    public void testShowCreateTemporaryView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String tView1DDL = "CREATE TEMPORARY VIEW t_v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView1DDL);
        java.util.List tView1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v1").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)tView1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v1` (\n             |  `a`,\n             |  `b`,\n             |  `c`\n             |)\n             |AS SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`\n             |")).stripMargin()})}));
        String tView2DDL = "CREATE TEMPORARY VIEW t_v2(d, e, f) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView2DDL);
        java.util.List tView2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v2").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)tView2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v2` (\n             |  `d`,\n             |  `e`,\n             |  `f`\n             |)\n             |AS SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`\n             |")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateCatalogView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String view1DDL = "CREATE VIEW v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view1DDL);
        java.util.List view1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v1").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)view1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v1` (\n             |  `a`,\n             |  `b`,\n             |  `c`\n             |)\n             |AS SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`\n             |")).stripMargin()})}));
        String view2DDL = "CREATE VIEW v2(x, y, z) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view2DDL);
        java.util.List view2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v2").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)view2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v2` (\n             |  `x`,\n             |  `y`,\n             |  `z`\n             |)\n             |AS SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`\n             |")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithLeftJoinGroupBy() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithLeftJoinGroupByDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewLeftJoinGroupBy as\n         |select max(t1.a) max_value\n         |from t1 left join t2 on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithLeftJoinGroupByDDL);
        java.util.List showCreateLeftJoinGroupByViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewLeftJoinGroupBy").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateLeftJoinGroupByViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewLeftJoinGroupBy` (\n             |  `max_value`\n             |)\n             |AS SELECT MAX(`t1`.`a`) AS `max_value`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |LEFT JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`\n             |")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithUDFOuterJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        this.tableEnv().createTemporarySystemFunction("udfEqualsOne", (UserDefinedFunction)new ScalarFunction(null){

            public int eval() {
                return 1;
            }
        });
        String viewWithCrossJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewWithCrossJoin as\n         |select udfEqualsOne() a, t1.a a1, t2.b b2 from t1 cross join t2")).stripMargin();
        this.tableEnv().executeSql(viewWithCrossJoinDDL);
        java.util.List showCreateCrossJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewWithCrossJoin").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateCrossJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewWithCrossJoin` (\n             |  `a`,\n             |  `a1`,\n             |  `b2`\n             |)\n             |AS SELECT `udfEqualsOne`() AS `a`, `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |CROSS JOIN `default_catalog`.`default_database`.`t2`\n             |")).stripMargin()})}));
    }

    @TestTemplate
    public void testShowCreateViewWithInnerJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithInnerJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view innerJoinView as\n         |select t1.a a1, t2.b b2\n         |from t1 inner join t2\n         |on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithInnerJoinDDL);
        java.util.List showCreateInnerJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view innerJoinView").collect());
        org.junit.jupiter.api.Assertions.assertEquals((Object)showCreateInnerJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`innerJoinView` (\n             |  `a1`,\n             |  `b2`\n             |)\n             |AS SELECT `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |INNER JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`\n             |")).stripMargin()})}));
    }

    public CatalogViewITCase(boolean isStreamingMode) {
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
    }
}

