/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.api.constraints.UniqueConstraint;
import org.apache.flink.table.planner.catalog.CatalogTableITCase$;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.TableITCaseBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u001b7\u0001\rC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0006#\u0002!\tA\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019q\u0006\u0001)A\u00051\"9q\f\u0001b\u0001\n\u0013\u0001\u0007B\u00023\u0001A\u0003%\u0011\rC\u0003f\u0001\u0011\u0005a\rC\u0003u\u0001\u0011\rQ\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011Q\n\u0001\u0005\n\u0005=\u0003BBA+\u0001\u0011\u0005a\r\u0003\u0004\u0002`\u0001!\tA\u001a\u0005\u0007\u0003G\u0002A\u0011\u00014\t\r\u0005\u001d\u0004\u0001\"\u0001g\u0011\u0019\tY\u0007\u0001C\u0001M\"1\u0011q\u000e\u0001\u0005\u0002\u0019Da!a\u001d\u0001\t\u00031\u0007BBA<\u0001\u0011\u0005a\r\u0003\u0004\u0002|\u0001!\tA\u001a\u0005\u0007\u0003\u007f\u0002A\u0011\u00014\t\r\u0005\r\u0005\u0001\"\u0001g\u0011\u0019\t9\t\u0001C\u0001M\"1\u00111\u0012\u0001\u0005\u0002\u0019Da!a$\u0001\t\u00031\u0007BBAJ\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0018\u0002!\tA\u001a\u0005\u0007\u00037\u0003A\u0011\u00014\t\r\u0005}\u0005\u0001\"\u0001g\u0011\u0019\t\u0019\u000b\u0001C\u0001M\"1\u0011q\u0015\u0001\u0005\u0002\u0019Da!a+\u0001\t\u00031\u0007BBAX\u0001\u0011\u0005a\r\u0003\u0004\u00024\u0002!\tA\u001a\u0005\u0007\u0003o\u0003A\u0011\u00014\t\r\u0005m\u0006\u0001\"\u0001g\u0011\u0019\ty\f\u0001C\u0001M\"1\u00111\u0019\u0001\u0005\u0002\u0019Da!a2\u0001\t\u00031\u0007BBAf\u0001\u0011\u0005a\r\u0003\u0004\u0002P\u0002!\tA\u001a\u0005\u0007\u0003'\u0004A\u0011\u00014\t\r\u0005]\u0007\u0001\"\u0001g\u0011\u0019\tY\u000e\u0001C\u0001M\"1\u0011q\u001c\u0001\u0005\u0002\u0019Da!a9\u0001\t\u00031\u0007BBAt\u0001\u0011\u0005a\r\u0003\u0004\u0002l\u0002!\tAZ\u0004\b\u000531\u0004\u0012\u0001B\u000e\r\u0019)d\u0007#\u0001\u0003\u001e!1\u0011K\rC\u0001\u0005KAqAa\n3\t\u0003\u0011IC\u0001\nDCR\fGn\\4UC\ndW-\u0013+DCN,'BA\u001c9\u0003\u001d\u0019\u0017\r^1m_\u001eT!!\u000f\u001e\u0002\u000fAd\u0017M\u001c8fe*\u00111\bP\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003{y\nQA\u001a7j].T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO\u000e\u00011C\u0001\u0001E!\t)\u0005*D\u0001G\u0015\t9\u0005(A\u0003vi&d7/\u0003\u0002J\r\nyA+\u00192mK&#6)Y:f\u0005\u0006\u001cX-A\bjgN#(/Z1nS:<Wj\u001c3f!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDCA*V!\t!\u0006!D\u00017\u0011\u0015Q%\u00011\u0001L\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005mS\u0014aA1qS&\u0011QL\u0017\u0002\u0014\u000b:4\u0018N]8o[\u0016tGoU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n\u0001\u0002^1cY\u0016,eN^\u000b\u0002CB\u0011\u0011LY\u0005\u0003Gj\u0013\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\u0002\u0013Q\f'\r\\3F]Z\u0004\u0013A\u00022fM>\u0014X\rF\u0001h!\ta\u0005.\u0003\u0002j\u001b\n!QK\\5uQ\t91\u000e\u0005\u0002me6\tQN\u0003\u0002\\]*\u0011q\u000e]\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t\b)A\u0003kk:LG/\u0003\u0002t[\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0017I|wo\u0014:eKJLgnZ\u000b\u0002mB!qo`A\u0003\u001d\tAXP\u0004\u0002zy6\t!P\u0003\u0002|\u0005\u00061AH]8pizJ\u0011AT\u0005\u0003}6\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0005\r!\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005yl\u0005\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A(A\u0003usB,7/\u0003\u0003\u0002\u0010\u0005%!a\u0001*po\u0006)Ao\u001c*poR!\u0011QAA\u000b\u0011\u001d\t9\"\u0003a\u0001\u00033\tA!\u0019:hgB)A*a\u0007\u0002 %\u0019\u0011QD'\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002M\u0003CI1!a\tN\u0005\r\te._\u0001\u0010O\u0016$H+\u00192mK>\u0003H/[8ogR!\u0011\u0011FA%!!\tY#!\u000e\u0002:\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\tAA[1wC&!\u0011qGA\u0017\u0005\ri\u0015\r\u001d\t\u0005\u0003w\t\u0019E\u0004\u0003\u0002>\u0005}\u0002CA=N\u0013\r\t\t%T\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005S\nC\u0004\u0002L)\u0001\r!!\u000f\u0002\u0013Q\f'\r\\3OC6,\u0017a\u0002;fgR,FM\u001a\u000b\u0004O\u0006E\u0003bBA*\u0017\u0001\u0007\u0011\u0011H\u0001\u000bMVt7\r\u0015:fM&D\u0018!\u0007;fgR,FMZ,ji\"4U\u000f\u001c7JI\u0016tG/\u001b4jKJD3\u0001DA-!\ra\u00171L\u0005\u0004\u0003;j'\u0001\u0004+fgR$V-\u001c9mCR,\u0017a\u0005;fgR,FMZ,ji\"$\u0015\r^1cCN,\u0007fA\u0007\u0002Z\u0005qA/Z:u+\u00124w+\u001b;i\u001d>t\u0007f\u0001\b\u0002Z\u00059B/Z:u+\u00124w+\u001b;i/J|gnZ\"bi\u0006dwn\u001a\u0015\u0004\u001f\u0005e\u0013\u0001\u0007;fgR,FMZ,ji\"<&o\u001c8h\t\u0006$\u0018MY1tK\"\u001a\u0001#!\u0017\u0002\u001dQ,7\u000f^%og\u0016\u0014H/\u00138u_\"\u001a\u0011#!\u0017\u00021Q,7\u000f\u001e*fC\u0012<&/\u001b;f\u0007N4Xk]5oO\u0012#E\nK\u0002\u0013\u00033\nq\u0005^3tiJ+\u0017\rZ,sSR,7i\u001d<XSRDG)\u001f8b[&\u001cG+\u00192mK>\u0003H/[8og\"\u001a1#!\u0017\u0002KQ,7\u000f^%og\u0016\u0014HoU8ve\u000e,G+\u00192mK\u0016C\bO]3tg&|gNR5fY\u0012\u001c\bf\u0001\u000b\u0002Z\u0005)D/Z:u\u0013:\u001cXM\u001d;T_V\u00148-\u001a+bE2,W\t\u001f9sKN\u001c\u0018n\u001c8GS\u0016dGm\u001d\"fM>\u0014XMU3gKJ,gnY3tQ\r)\u0012\u0011L\u0001#i\u0016\u001cH/\u00138tKJ$8k\\;sG\u0016$\u0016M\u00197f/&$\bNR;oG\u001aKW\r\u001c3)\u0007Y\tI&A\u0017uKN$\u0018J\\:feR\u001cv.\u001e:dKR\u000b'\r\\3XSRDWk]3s\t\u00164\u0017N\\3e\rVt7MR5fY\u0012D3aFA-\u0003\r\"Xm\u001d;J]N,'\u000f^*j].$\u0016M\u00197f\u000bb\u0004(/Z:tS>tg)[3mIND3\u0001GA-\u0003\u0019\"Xm\u001d;J]N,'\u000f^*j].$\u0016M\u00197f/&$\b.\u00168nCR\u001c\u0007.\u001a3GS\u0016dGm\u001d\u0015\u00043\u0005e\u0013A\u0007;fgRLen]3si^KG\u000f\u001b&pS:,GmU8ve\u000e,\u0007f\u0001\u000e\u0002Z\u0005iB/Z:u\u0013:\u001cXM\u001d;XSRD\u0017iZ4sK\u001e\fG/Z*pkJ\u001cW\rK\u0002\u001c\u00033\n\u0001\u0007^3tiR+W\u000e]8sCJLH+\u00192mK6\u000b7o\u001b)fe6\fg.\u001a8u)\u0006\u0014G.Z,ji\"\u001c\u0016-\\3OC6,\u0007f\u0001\u000f\u0002Z\u0005IB/Z:u\tJ|\u0007\u000fV1cY\u0016<\u0016\u000e\u001e5Gk2d\u0007+\u0019;iQ\ri\u0012\u0011L\u0001\u001di\u0016\u001cH\u000f\u0012:paR\u000b'\r\\3XSRD\u0007+\u0019:uS\u0006d\u0007+\u0019;iQ\rq\u0012\u0011L\u0001\u001di\u0016\u001cH\u000f\u0012:paR\u000b'\r\\3XSRD\u0017J\u001c<bY&$\u0007+\u0019;iQ\ry\u0012\u0011L\u0001%i\u0016\u001cH\u000f\u0012:paR\u000b'\r\\3XSRD\u0017J\u001c<bY&$\u0007+\u0019;i\u0013\u001a,\u00050[:ug\"\u001a\u0001%!\u0017\u0002OQ,7\u000f\u001e#s_B$\u0016M\u00197f'\u0006lWMT1nK^KG\u000f\u001b+f[B|'/\u0019:z)\u0006\u0014G.\u001a\u0015\u0004C\u0005e\u0013!\b;fgR$%o\u001c9WS\u0016<8+Y7f\u001d\u0006lWmV5uQR\u000b'\r\\3)\u0007\t\nI&\u0001\u0015uKN$HI]8q-&,woU1nK:\u000bW.Z,ji\"$\u0016M\u00197f\u0013\u001atu\u000e^#ySN$8\u000fK\u0002$\u00033\na\u0002^3ti\u0006cG/\u001a:UC\ndW\rK\u0002%\u00033\n\u0011\u0005^3ti\u000e\u0013X-\u0019;f)\u0006\u0014G.Z!oINCwn^\"sK\u0006$X\rV1cY\u0016D3!JA-\u00031\"Xm\u001d;De\u0016\fG/\u001a+bE2,w+\u001b;i\u0007>lW.\u001a8u\u0003:$7\u000b[8x\u0007J,\u0017\r^3UC\ndW\rK\u0002'\u00033\n!\b^3ti\u000e\u0013X-\u0019;f)\u0006\u0014G.Z!oINCwn^\"sK\u0006$X\rV1cY\u0016<\u0016\u000e\u001e5ESN$(/\u001b2vi&|g.\u00117h_JLG\u000f[7)\u0007\u001d\nI&\u0001\u0011uKN$8I]3bi\u00164\u0016.Z<B]\u0012\u001c\u0006n\\<De\u0016\fG/\u001a+bE2,\u0007f\u0001\u0015\u0002Z\u0005\u0019B/Z:u\u00032$XM\u001d,jK^\u0014VM\\1nK\"\u001a\u0011&!\u0017\u0002\u001fQ,7\u000f^!mi\u0016\u0014h+[3x\u0003ND3AKA-\u0003\r\"Xm\u001d;Vg\u0016\u001c\u0015\r^1m_\u001e\fe\u000eZ*i_^\u001cUO\u001d:f]R\u001c\u0015\r^1m_\u001eD3aKA-\u0003\u0015\"Xm\u001d;Vg\u0016$\u0015\r^1cCN,\u0017I\u001c3TQ><8)\u001e:sK:$H)\u0019;bE\u0006\u001cX\rK\u0002-\u00033\n!\u0003^3ti\u000e\u0013X-\u0019;f\t\u0006$\u0018MY1tK\"\u001aQ&!\u0017\u0002!Q,7\u000f\u001e#s_B$\u0015\r^1cCN,\u0007f\u0001\u0018\u0002Z\u0005\tB/Z:u\u00032$XM\u001d#bi\u0006\u0014\u0017m]3)\u0007=\nI&\u0001\tuKN$Hj\\1e\rVt7\r^5p]\"\u001a\u0001'!\u0017)\u000f\u0001\t\t0!@\u0002\u0000B!\u00111_A}\u001b\t\t)PC\u0002\u0002x6\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005m\u0018Q\u001f\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GF\u0001B\u0001G\t\u0011\u0019\u0001\u0005\u0003\u0003\u0006\tUQB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\u0011iAa\u0004\u0002\u0015\u0015DH/\u001a8tS>t7OC\u0002r\u0005#Q1Aa\u0005=\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0003\u0018\t\u001d!A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017AE\"bi\u0006dwn\u001a+bE2,\u0017\nV\"bg\u0016\u0004\"\u0001\u0016\u001a\u0014\u0007I\u0012y\u0002E\u0002M\u0005CI1Aa\tN\u0005\u0019\te.\u001f*fMR\u0011!1D\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHC\u0001B\u0016!\u0015\tYC!\fL\u0013\u0011\u0011y#!\f\u0003\u0015\r{G\u000e\\3di&|g\u000eK\u00045\u0005g\u0011IDa\u000f\u0011\t\t\u0015!QG\u0005\u0005\u0005o\u00119A\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012!QH\u0001\u0004wBj\b")
public class CatalogTableITCase
extends TableITCaseBase {
    private final boolean isStreamingMode;
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogTableITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    @BeforeEach
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
        CatalogFunctionImpl func = new CatalogFunctionImpl(JavaUserDefinedScalarFunctions.JavaFunc0.class.getName());
        ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).createFunction(new ObjectPath(this.tableEnv().getCurrentDatabase(), "myfunc"), (CatalogFunction)func, true);
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public Row toRow(Seq<Object> args) {
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return row;
    }

    public Map<String, String> getTableOptions(String tableName) {
        return ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(new ObjectPath(this.tableEnv().getCurrentDatabase(), tableName)).getOptions();
    }

    private void testUdf(String funcPrefix) {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(159).append("\n         |create table sinkT(\n         |  a bigint\n         |) with (\n         |  'connector' = 'COLLECTION',\n         |  'is-bounded' = '").append(this.isStreamingMode).append("'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(new java.lang.StringBuilder(50).append("insert into sinkT select ").append(funcPrefix).append("myfunc(cast(1 as bigint))").toString()).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L)})), (List)Nil$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testUdfWithFullIdentifier() {
        this.testUdf("default_catalog.default_database.");
    }

    @TestTemplate
    public void testUdfWithDatabase() {
        this.testUdf("default_database.");
    }

    @TestTemplate
    public void testUdfWithNon() {
        this.testUdf("");
    }

    @TestTemplate
    public void testUdfWithWrongCatalog() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testUdf("wrong_catalog.default_database."));
    }

    @TestTemplate
    public void testUdfWithWrongDatabase() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testUdf("default_catalog.wrong_database."));
    }

    @TestTemplate
    public void testInsertInto() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, (t1.a + 1) as c , d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testReadWriteCsvUsingDDL() {
        Seq csvRecords = (Seq)new .colon.colon((Object)"2.02,Euro,2019-12-12 00:00:01.001001", (List)new .colon.colon((Object)"1.11,US Dollar,2019-12-12 00:00:02.002001", (List)new .colon.colon((Object)"50,Yen,2019-12-12 00:00:04.004001", (List)new .colon.colon((Object)"3.1,Euro,2019-12-12 00:00:05.005001", (List)new .colon.colon((Object)"5.33,US Dollar,2019-12-12 00:00:06.006001", (List)Nil$.MODULE$)))));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(439).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ',',\n         |  'format.line-delimiter' = '#'\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(361).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0,2019-12-12 00:00:04.004001,3,50.00\n2019-12-12 00:00:10.0,2019-12-12 00:00:06.006001,2,5.33\n";
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @TestTemplate
    public void testReadWriteCsvWithDynamicTableOptions() {
        Seq csvRecords = (Seq)new .colon.colon((Object)"2.02,Euro,2019-12-12 00:00:01.001001", (List)new .colon.colon((Object)"1.11,US Dollar,2019-12-12 00:00:02.002001", (List)new .colon.colon((Object)"50,Yen,2019-12-12 00:00:04.004001", (List)new .colon.colon((Object)"3.1,Euro,2019-12-12 00:00:05.005001", (List)new .colon.colon((Object)"5.33,US Dollar,2019-12-12 00:00:06.006001", (List)Nil$.MODULE$)))));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(396).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(317).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2 /*+ OPTIONS('format.field-delimiter' = '|') */\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1 /*+ OPTIONS('format.line-delimiter' = '#') */\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0|2019-12-12 00:00:04.004001|3|50.00\n2019-12-12 00:00:10.0|2019-12-12 00:00:06.006001|2|5.33\n";
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @TestTemplate
    public void testInsertSourceTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableExpressionFieldsBeforeReferences() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)101), BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)103), BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  c as a + 100,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  c int,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.c, t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableWithFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", DateTimeTestUtil$.MODULE$.localDateTime("1990-02-10 12:34:56")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:41")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:42")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:43")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:44")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as to_timestamp(b)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c timestamp(3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSourceTableWithUserDefinedFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42", BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43", BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        this.tableEnv().createTemporarySystemFunction("my_udf", (UserDefinedFunction)Func0$.MODULE$);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  `time` varchar,\n        |  c as my_udf(a),\n        |  d as `time`\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  `time` varchar,\n        |  c int not null,\n        |  d varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.`time`, t1.c, t1.d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSinkTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as c - 1,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertSinkTableWithUnmatchedFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as cast(a as varchar(20)) || cast(c as varchar(20)),\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql(query).await()).withMessageContaining("Incompatible types for sink column 'c' at position 1.");
    }

    @TestTemplate
    public void testInsertWithJoinedSource() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int,\n        |  c int,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select a.a, a.b, b.a, b.b\n        |  from t1 a\n        |  join t1 b\n        |  on a.a = b.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testInsertWithAggregateSource() {
        if (this.isStreamingMode) {
            return;
        }
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)2000)})), (List)Nil$.MODULE$)));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select sum(a), t1.b from t1 group by t1.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testTemporaryTableMaskPermanentTableWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String permanentTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String temporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d as c+1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        .colon.colon permanentData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon temporaryData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(permanentTable);
        this.tableEnv().executeSql(temporaryTable);
        this.tableEnv().executeSql(sinkTable);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT a, b, d FROM T1";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)temporaryData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY TABLE IF EXISTS T1\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryTable);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        org.junit.jupiter.api.Assertions.assertEquals((Object)permanentData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @TestTemplate
    public void testDropTableWithFullPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_catalog.default_database.t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testDropTableWithPartialPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        | 'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_database.t2");
        this.tableEnv().executeSql("DROP TABLE t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).isEmpty());
    }

    @TestTemplate
    public void testDropTableWithInvalidPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("DROP TABLE catalog1.database1.t1"));
    }

    @TestTemplate
    public void testDropTableWithInvalidPathIfExists() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        this.tableEnv().executeSql("DROP TABLE IF EXISTS catalog1.database1.t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testDropTableSameNameWithTemporaryTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String createTable2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql(createTable2);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("drop table t1")).withMessageContaining("Temporary table with identifier '`default_catalog`.`default_database`.`t1`' exists. Drop it first before removing the permanent table.");
    }

    @TestTemplate
    public void testDropViewSameNameWithTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("drop view t1")).withMessageContaining("View with identifier 'default_catalog.default_database.t1' does not exist.");
    }

    @TestTemplate
    public void testDropViewSameNameWithTableIfNotExists() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql("drop view if exists t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @TestTemplate
    public void testAlterTable() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint not null,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'k1' = 'v1'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql("alter table t1 rename to t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})));
        this.tableEnv().executeSql("alter table t2 set ('k1' = 'a', 'k2' = 'b')");
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("connector", "COLLECTION");
        expectedOptions.put("k1", "a");
        expectedOptions.put("k2", "b");
        org.junit.jupiter.api.Assertions.assertEquals(expectedOptions, this.getTableOptions("t2"));
        this.tableEnv().executeSql("alter table t2 reset ('k1')");
        expectedOptions.remove("k1");
        org.junit.jupiter.api.Assertions.assertEquals(expectedOptions, this.getTableOptions("t2"));
        String currentCatalog = this.tableEnv().getCurrentCatalog();
        String currentDB = this.tableEnv().getCurrentDatabase();
        this.tableEnv().executeSql("alter table t2 add constraint ct1 primary key(a) not enforced");
        TableSchema tableSchema1 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        Predef$.MODULE$.assert(tableSchema1.getPrimaryKey().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"CONSTRAINT ct1 PRIMARY KEY (a)", (Object)((UniqueConstraint)tableSchema1.getPrimaryKey().get()).asSummaryString());
        this.tableEnv().executeSql("alter table t2 drop constraint ct1");
        TableSchema tableSchema2 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        org.junit.jupiter.api.Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)tableSchema2.getPrimaryKey().isPresent()));
    }

    @TestTemplate
    public void testCreateTableAndShowCreateTable() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  a bigint not null,\n        |  h string,\n        |  g as 2*(a+1),\n        |  b string not null,\n        |  c bigint metadata virtual,\n        |  e row<name string, age int, flag boolean>,\n        |  f as myfunc(a),\n        |  ts1 timestamp(3),\n        |  ts2 timestamp_ltz(3) metadata from 'timestamp',\n        |  `__source__` varchar(255),\n        |  proc as proctime(),\n        |  watermark for ts1 as cast(timestampadd(hour, 8, ts1) as timestamp(3)),\n        |  constraint test_constraint primary key (a, b) not enforced\n        |) comment 'test show create table statement'\n        |distributed by (a)\n        |partitioned by (b,h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `a` BIGINT NOT NULL,\n        |  `h` VARCHAR(2147483647),\n        |  `g` AS 2 * (`a` + 1),\n        |  `b` VARCHAR(2147483647) NOT NULL,\n        |  `c` BIGINT METADATA VIRTUAL,\n        |  `e` ROW<`name` VARCHAR(2147483647), `age` INT, `flag` BOOLEAN>,\n        |  `f` AS `default_catalog`.`default_database`.`myfunc`(`a`),\n        |  `ts1` TIMESTAMP(3),\n        |  `ts2` TIMESTAMP(3) WITH LOCAL TIME ZONE METADATA FROM 'timestamp',\n        |  `__source__` VARCHAR(255),\n        |  `proc` AS PROCTIME(),\n        |  WATERMARK FOR `ts1` AS CAST(TIMESTAMPADD(HOUR, 8, `ts1`) AS TIMESTAMP(3)),\n        |  CONSTRAINT `test_constraint` PRIMARY KEY (`a`, `b`) NOT ENFORCED\n        |)\n        |COMMENT 'test show create table statement'\n        |DISTRIBUTED BY (`a`)\n        |PARTITIONED BY (`b`, `h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDDL, (Object)row.getField(0));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`")).withMessageContaining("Could not execute SHOW CREATE TABLE. Table with identifier `default_catalog`.`default_database`.`tmp` does not exist.");
    }

    @TestTemplate
    public void testCreateTableWithCommentAndShowCreateTable() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  pk1 bigint not null comment 'this is column pk1 which part of primary key',\n        |  h string,\n        |  a bigint,\n        |  g as 2*(a+1) comment 'notice: computed column, expression ''2*(`a`+1)''.',\n        |  pk2 string not null comment 'this is column pk2 which part of primary key',\n        |  c bigint metadata virtual comment 'notice: metadata column, named ''c''.',\n        |  e row<name string, age int, flag boolean>,\n        |  f as myfunc(a),\n        |  ts1 timestamp(3) comment 'notice: watermark, named ''ts1''.',\n        |  ts2 timestamp_ltz(3) metadata from 'timestamp' comment 'notice: metadata column, named ''ts2''.',\n        |  `__source__` varchar(255),\n        |  proc as proctime(),\n        |  watermark for ts1 as cast(timestampadd(hour, 8, ts1) as timestamp(3)),\n        |  constraint test_constraint primary key (pk1, pk2) not enforced\n        |) comment 'test show create table statement'\n        |distributed into 5 buckets\n        |partitioned by (h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `pk1` BIGINT NOT NULL COMMENT 'this is column pk1 which part of primary key',\n        |  `h` VARCHAR(2147483647),\n        |  `a` BIGINT,\n        |  `g` AS 2 * (`a` + 1) COMMENT 'notice: computed column, expression ''2*(`a`+1)''.',\n        |  `pk2` VARCHAR(2147483647) NOT NULL COMMENT 'this is column pk2 which part of primary key',\n        |  `c` BIGINT METADATA VIRTUAL COMMENT 'notice: metadata column, named ''c''.',\n        |  `e` ROW<`name` VARCHAR(2147483647), `age` INT, `flag` BOOLEAN>,\n        |  `f` AS `default_catalog`.`default_database`.`myfunc`(`a`),\n        |  `ts1` TIMESTAMP(3) COMMENT 'notice: watermark, named ''ts1''.',\n        |  `ts2` TIMESTAMP(3) WITH LOCAL TIME ZONE METADATA FROM 'timestamp' COMMENT 'notice: metadata column, named ''ts2''.',\n        |  `__source__` VARCHAR(255),\n        |  `proc` AS PROCTIME(),\n        |  WATERMARK FOR `ts1` AS CAST(TIMESTAMPADD(HOUR, 8, `ts1`) AS TIMESTAMP(3)),\n        |  CONSTRAINT `test_constraint` PRIMARY KEY (`pk1`, `pk2`) NOT ENFORCED\n        |)\n        |COMMENT 'test show create table statement'\n        |DISTRIBUTED INTO 5 BUCKETS\n        |PARTITIONED BY (`h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDDL, (Object)row.getField(0).toString());
    }

    @TestTemplate
    public void testCreateTableAndShowCreateTableWithDistributionAlgorithm() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  a bigint not null,\n        |  h string,\n        |  b string not null\n        |) comment 'test show create table statement'\n        |distributed by range(a) into 7 buckets\n        |partitioned by (b,h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `a` BIGINT NOT NULL,\n        |  `h` VARCHAR(2147483647),\n        |  `b` VARCHAR(2147483647) NOT NULL\n        |)\n        |COMMENT 'test show create table statement'\n        |DISTRIBUTED BY RANGE(`a`) INTO 7 BUCKETS\n        |PARTITIONED BY (`b`, `h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDDL, (Object)row.getField(0));
    }

    @TestTemplate
    public void testCreateViewAndShowCreateTable() {
        String createTableDDL = new StringOps(Predef$.MODULE$.augmentString(" |create table `source` (\n        |  `id` bigint not null,\n        | `group` string not null,\n        | `score` double\n        |) with (\n        |  'connector' = 'source-only'\n        |)\n        |")).stripMargin();
        String createViewDDL = new StringOps(Predef$.MODULE$.augmentString(" |create view `tmp` as\n        |select `group`, avg(`score`) as avg_score\n        |from `source`\n        |group by `group`\n        |")).stripMargin();
        this.tableEnv().executeSql(createTableDDL);
        this.tableEnv().executeSql(createViewDDL);
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`")).withMessageContaining("SHOW CREATE TABLE is only supported for tables, but `default_catalog`.`default_database`.`tmp` is a view. Please use SHOW CREATE VIEW instead.");
    }

    @TestTemplate
    public void testAlterViewRename() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   id INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT * FROM T");
        this.tableEnv().executeSql("ALTER VIEW V RENAME TO V2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listViews())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V2"})));
    }

    @TestTemplate
    public void testAlterViewAs() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   a INT,\n                          |   b INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT a FROM T");
        this.tableEnv().executeSql("ALTER VIEW V AS SELECT b FROM T");
        ObjectPath objectPath = new ObjectPath(this.tableEnv().getCurrentDatabase(), "V");
        CatalogView view = (CatalogView)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(objectPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SELECT `b`\nFROM `T`", (Object)view.getOriginalQuery());
    }

    @TestTemplate
    public void testUseCatalogAndShowCurrentCatalog() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("cat1"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("cat2"));
        this.tableEnv().executeSql("use catalog cat1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"cat1", (Object)this.tableEnv().getCurrentCatalog());
        this.tableEnv().executeSql("use catalog cat2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"cat2", (Object)this.tableEnv().getCurrentCatalog());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[cat2]", (Object)((Row)this.tableEnv().executeSql("show current catalog").collect().next()).toString());
    }

    @TestTemplate
    public void testUseDatabaseAndShowCurrentDatabase() {
        GenericInMemoryCatalog catalog = new GenericInMemoryCatalog("cat1");
        this.tableEnv().registerCatalog("cat1", (Catalog)catalog);
        CatalogDatabaseImpl catalogDB1 = new CatalogDatabaseImpl(new HashMap(), "db1");
        CatalogDatabaseImpl catalogDB2 = new CatalogDatabaseImpl(new HashMap(), "db2");
        catalog.createDatabase("db1", (CatalogDatabase)catalogDB1, true);
        catalog.createDatabase("db2", (CatalogDatabase)catalogDB2, true);
        this.tableEnv().executeSql("use cat1.db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db1", (Object)this.tableEnv().getCurrentDatabase());
        String currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[db1]", (Object)currentDatabase);
        this.tableEnv().executeSql("use db2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db2", (Object)this.tableEnv().getCurrentDatabase());
        currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[db2]", (Object)currentDatabase);
    }

    @TestTemplate
    public void testCreateDatabase() {
        Object object;
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 ");
        this.tableEnv().executeSql("create database if not exists db1 ");
        try {
            this.tableEnv().executeSql("create database db1 ");
            object = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("create database cat2.db1 comment 'test_comment' with ('k1' = 'v1', 'k2' = 'v2')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat2").get()).getDatabase("db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_comment", (Object)database.getComment());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "v1");
        expectedProperty.put("k2", "v2");
        org.junit.jupiter.api.Assertions.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @TestTemplate
    public void testDropDatabase() {
        Object object;
        Object object2;
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("drop database db1");
        this.tableEnv().executeSql("drop database if exists db1");
        try {
            this.tableEnv().executeSql("drop database db1");
            object2 = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object2 = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("use db1");
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl2);
        Assertions.assertThatThrownBy(() -> this.tableEnv().executeSql("drop database db1")).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Cannot drop a database which is currently in use.")});
        this.tableEnv().executeSql("use `default`");
        try {
            this.tableEnv().executeSql("drop database db1");
            object = org.junit.jupiter.api.Assertions.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            object = BoxedUnit.UNIT;
        }
        this.tableEnv().executeSql("drop database db1 cascade");
    }

    @TestTemplate
    public void testAlterDatabase() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 comment 'db1_comment' with ('k1' = 'v1')");
        this.tableEnv().executeSql("alter database db1 set ('k1' = 'a', 'k2' = 'b')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat1").get()).getDatabase("db1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"db1_comment", (Object)database.getComment());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "a");
        expectedProperty.put("k2", "b");
        org.junit.jupiter.api.Assertions.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @TestTemplate
    public void testLoadFunction() {
        this.tableEnv().registerCatalog("cat2", (Catalog)new TestValuesCatalog("cat2", "default", true));
        this.tableEnv().executeSql("use catalog cat2");
        Random random = new Random();
        String udfClassName = new java.lang.StringBuilder(8).append("LowerUDF").append(random.nextInt(50)).toString();
        String jarPath = UserClassLoaderJarTestUtils.createJarFile((File)TempDirUtils.newFolder((Path)this.tmpDir, (String[])new String[]{String.format("test-jar-%s", UUID.randomUUID())}), (String)"test-classloader-udf.jar", (String)udfClassName, (String)String.format("public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n", udfClassName)).toURI().toString();
        this.tableEnv().executeSql(new java.lang.StringBuilder(43).append("create function lowerUdf as '").append(udfClassName).append("' using jar '").append(jarPath).append("'").toString());
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"BoB"}), (List)Nil$.MODULE$)));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"+I[bob]", (Object)((Row)this.tableEnv().executeSql("select lowerUdf(a) from t1").collect().next()).toString());
    }

    public CatalogTableITCase(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
    }
}

