/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FlinkCalciteSqlValidatorTest {
    private final PlannerMocks plannerMocks = PlannerMocks.create().registerTemporaryTable("t1", Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).build()).registerTemporaryTable("t2", Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.INT()).build()).registerTemporaryTable("t2_copy", Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.INT()).build()).registerTemporaryTable("t_nested", Schema.newBuilder().column("f", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT())})).build());

    FlinkCalciteSqlValidatorTest() {
    }

    @Test
    void testUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }

    @ParameterizedTest
    @ValueSource(strings={"INSERT INTO t2 (a, b) VALUES (1)", "INSERT INTO t2 (a, b) VALUES (1, 2), (3)", "INSERT INTO t2 (a, b) VALUES (1), (2, 3)", "INSERT INTO t2 (a, b) VALUES (1, 2), (3, 4, 5)", "INSERT INTO t2 (a, b) SELECT 1", "INSERT INTO t2 (a, b) SELECT COALESCE(123, 456), LEAST(1, 2), GREATEST(3, 4, 5)", "INSERT INTO t2 (a, b) SELECT * FROM t1", "INSERT INTO t2 (a, b) SELECT *, *, * FROM t1", "INSERT INTO t2 (a, b) SELECT *, 42 FROM t2_copy", "INSERT INTO t2 (a, b) SELECT 42, * FROM t2_copy", "INSERT INTO t2 (a, b) SELECT * FROM t_nested", "INSERT INTO t2 (a, b) TABLE t_nested", "INSERT INTO t2 (a, b) SELECT * FROM (TABLE t_nested)", "INSERT INTO t2 (a, b) WITH cte AS (SELECT 1, 2, 3) SELECT * FROM cte", "INSERT INTO t2 (a, b) WITH cte AS (SELECT * FROM t1, t2_copy) SELECT * FROM cte", "INSERT INTO t2 (a, b) WITH cte1 AS (SELECT 1, 2), cte2 AS (SELECT 2, 1) SELECT * FROM cte1, cte2"})
    void testInvalidNumberOfColumnsWhileInsertInto(String sql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining(" Number of columns must match number of query columns");
    }

    @ParameterizedTest
    @ValueSource(strings={"INSERT INTO t2 (a, b) VALUES (1, 2), (3, 4)", "INSERT INTO t2 (a) VALUES (1), (3)", "INSERT INTO t2 (a, b) SELECT 1, 2", "INSERT INTO t2 (a, b) SELECT LEAST(1, 2, 3), 2 * 2", "INSERT INTO t2 (a, b) SELECT * FROM t2_copy", "INSERT INTO t2 (a, b) SELECT *, * FROM t1", "INSERT INTO t2 (a, b) SELECT *, 42 FROM t1", "INSERT INTO t2 (a, b) SELECT 42, * FROM t1", "INSERT INTO t2 (a, b) SELECT f.* FROM t_nested", "INSERT INTO t2 (a, b) TABLE t2_copy", "INSERT INTO t2 (a, b) WITH cte AS (SELECT 1, 2) SELECT * FROM cte", "INSERT INTO t2 (a, b) WITH cte AS (SELECT * FROM t2_copy) SELECT * FROM cte", "INSERT INTO t2 (a, b) WITH cte AS (SELECT t1.a, t2_copy.b FROM t1, t2_copy) SELECT * FROM cte", "INSERT INTO t2 (a, b) WITH cte1 AS (SELECT 1), cte2 AS (SELECT 2) SELECT * FROM cte1, cte2", "INSERT INTO t2 (a, b) WITH cte1 AS (SELECT 1, 2), cte2 AS (SELECT 2, 3) SELECT * FROM cte1 UNION SELECT * FROM cte2", "INSERT INTO t2 (a, b) WITH cte1 AS (SELECT 1, 2), cte2 AS (SELECT 2, 3), cte3 AS (SELECT 3, 4), cte4 AS (SELECT 4, 5) SELECT * FROM cte1 UNION SELECT * FROM cte2 INTERSECT SELECT * FROM cte3 UNION ALL SELECT * FROM cte4"})
    void validInsertIntoTest(String sql) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.plannerMocks.getParser().parse(sql));
    }

    @Test
    void testExplainUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("EXPLAIN UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }
}

