/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.batch.ExplainTest$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\u000f\u001e\u0001)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019A\u0005\u0001)A\u0005\u0003\"9\u0011\n\u0001b\u0001\n\u0013Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I\u0011\u0001)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\u0002ACa!\u0017\u0001!\u0002\u0013\t\u0006b\u0002.\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00077\u0002\u0001\u000b\u0011B)\t\u000bq\u0003A\u0011A/\t\u000b-\u0004A\u0011A/\t\u000bA\u0004A\u0011A/\t\u000bI\u0004A\u0011A/\t\u000bQ\u0004A\u0011A/\t\u000bY\u0004A\u0011A/\t\u000ba\u0004A\u0011A/\t\u000bi\u0004A\u0011A/\t\u000bq\u0004A\u0011A/\t\u000by\u0004A\u0011A/\t\r\u0005\u0005\u0001\u0001\"\u0001^\u000f\u001d\ty#\bE\u0001\u0003c1a\u0001H\u000f\t\u0002\u0005M\u0002B\u0002\u001e\u001a\t\u0003\tY\u0004C\u0004\u0002>e!\t!a\u0010\u0003\u0017\u0015C\b\u000f\\1j]R+7\u000f\u001e\u0006\u0003=}\tQAY1uG\"T!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u0005)A/\u00192mK*\u0011A%J\u0001\u0006M2Lgn\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0015)H/\u001b7t\u0015\t\u0001\u0014%A\u0004qY\u0006tg.\u001a:\n\u0005Ij#!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0005fqR,g\u000eZ3e!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDC\u0001\u001f?!\ti\u0004!D\u0001\u001e\u0011\u0015\u0019$\u00011\u00015\u00031)\u0007\u0010\u001e:b\t\u0016$\u0018-\u001b7t+\u0005\t\u0005cA\u001bC\t&\u00111I\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000b\u001ak\u0011aH\u0005\u0003\u000f~\u0011Q\"\u0012=qY\u0006Lg\u000eR3uC&d\u0017!D3yiJ\fG)\u001a;bS2\u001c\b%\u0001\u0003vi&dW#A&\u0011\u00051b\u0015BA'.\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\rM#&+\u0013(H+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\"\u0003\u0015!\u0018\u0010]3t\u0013\t16K\u0001\u0005ECR\fG+\u001f9f\u0003\u001d\u0019FKU%O\u000f\u0002\nA\u0001T(O\u000f\u0006)Aj\u0014(HA\u0005\u0019\u0011J\u0014+\u0002\t%sE\u000bI\u0001\u0007E\u00164wN]3\u0015\u0003y\u0003\"!N0\n\u0005\u00014$\u0001B+oSRD#!\u00042\u0011\u0005\rLW\"\u00013\u000b\u0005\u0001*'B\u00014h\u0003\u001dQW\u000f]5uKJT!\u0001[\u0014\u0002\u000b),h.\u001b;\n\u0005)$'A\u0003\"fM>\u0014X-R1dQ\u0006qB/Z:u\u000bb\u0004H.Y5o/&$\b\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c\u0015\u0003\u001d5\u0004\"a\u00198\n\u0005=$'\u0001\u0004+fgR$V-\u001c9mCR,\u0017!\b;fgR,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5ECR\f7\u000b\u001e:fC6\u001c6-\u00198)\u0005=i\u0017!\u0006;fgR,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003!5\f!\u0003^3ti\u0016C\b\u000f\\1j]^KG\u000f[!hO\"\u0012\u0011#\\\u0001\u0014i\u0016\u001cH/\u0012=qY\u0006LgnV5uQ*{\u0017N\u001c\u0015\u0003%5\fA\u0003^3ti\u0016C\b\u000f\\1j]^KG\u000f[+oS>t\u0007FA\nn\u0003M!Xm\u001d;FqBd\u0017-\u001b8XSRD7k\u001c:uQ\t!R.A\ruKN$X\t\u001f9mC&tw+\u001b;i'&tw\r\\3TS:\\\u0007FA\u000bn\u0003e!Xm\u001d;FqBd\u0017-\u001b8XSRDW*\u001e7uSNKgn[:)\u0005Yi\u0017\u0001\u0007;fgR,\u0005\u0010\u001d7bS:lU\u000f\u001c;ja2,\u0017J\u001c9vi\"\u0012q#\u001c\u0015\b\u0001\u0005\u001d\u00111CA\u000b!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007I\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003#\tYA\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a\u0006$\u0005\u0005e\u0001\u0003BA\u000e\u0003Wi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\u0005\r\u0012QE\u0001\u000bKb$XM\\:j_:\u001c(b\u00015\u0002()\u0019\u0011\u0011F\u0012\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002BA\u0017\u0003;\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\f1\"\u0012=qY\u0006Lg\u000eV3tiB\u0011Q(G\n\u00043\u0005U\u0002cA\u001b\u00028%\u0019\u0011\u0011\b\u001c\u0003\r\u0005s\u0017PU3g)\t\t\t$\u0001\u0006qCJ\fW.\u001a;feN$\"!!\u0011\u0011\u000b\u0005\r\u00131\n\u001b\u000e\u0005\u0005\u0015#bA%\u0002H)\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0005\u0015#AC\"pY2,7\r^5p]\":1$!\u0015\u0002X\u0005e\u0003\u0003BA\u000e\u0003'JA!!\u0016\u0002\u001e\tQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u00037\nA\"\u001a=uK:$W\rZ\u001f|au\u0004")
public class ExplainTest
extends TableTestBase {
    private final ExplainDetail[] extraDetails;
    private final BatchTableTestUtil util;
    private final DataType STRING;
    private final DataType LONG;
    private final DataType INT;

    @Parameters(name="extended={0}")
    public static Collection<Object> parameters() {
        return ExplainTest$.MODULE$.parameters();
    }

    private ExplainDetail[] extraDetails() {
        return this.extraDetails;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    public DataType STRING() {
        return this.STRING;
    }

    public DataType LONG() {
        return this.LONG;
    }

    public DataType INT() {
        return this.INT;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)4));
    }

    @TestTemplate
    public void testExplainWithTableSourceScan() {
        this.util().verifyExplain("SELECT * FROM MyTable", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithDataStreamScan() {
        this.util().verifyExplain("SELECT * FROM MyTable1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithFilter() {
        this.util().verifyExplain("SELECT * FROM MyTable1 WHERE mod(a, 2) = 0", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithAgg() {
        this.util().verifyExplain("SELECT COUNT(*) FROM MyTable1 GROUP BY a", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, NestedLoopJoin");
        this.util().verifyExplain("SELECT a, b, c, e, f FROM MyTable1, MyTable2 WHERE a = d", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithUnion() {
        this.util().verifyExplain("SELECT * FROM MyTable1 UNION ALL SELECT * FROM MyTable2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSort() {
        this.util().verifyExplain("SELECT * FROM MyTable1 ORDER BY a LIMIT 5", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithSingleSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT * FROM MyTable1 WHERE a > 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "sink", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)new .colon.colon((Object)this.STRING(), (List)Nil$.MODULE$))), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        this.util().verifyExplainInsert(table, "sink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainWithMultiSinks() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable1 GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt > 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "sink1", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"cnt", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("sink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable WHERE cnt < 10");
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "sink2", (List<String>)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"cnt", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)this.INT(), (List)new .colon.colon((Object)this.LONG(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("sink2", table2);
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    @TestTemplate
    public void testExplainMultipleInput() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   (select a, sum(b) from MyTable1 group by a) v1,\n        |   (select d, sum(e) from MyTable2 group by d) v2\n        |   where a = d\n        |")).stripMargin();
        this.util().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.extraDetails()));
    }

    public ExplainTest(boolean extended) {
        this.extraDetails = extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE, ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.ExplainTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.ExplainTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.batch.ExplainTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.STRING = DataTypes.STRING();
        this.LONG = DataTypes.BIGINT();
        this.INT = DataTypes.INT();
    }
}

