/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Over;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.Slide;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;

@Internal
public class QueryOperationTestPrograms {
    static final TableTestProgram SOURCE_QUERY_OPERATION = TableTestProgram.of((String)"source-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"}), Row.of((Object[])new Object[]{2L, "cde"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"}), Row.of((Object[])new Object[]{2L, "cde"})}).build()).runTableApi(t -> t.from("s"), "sink").runSql("SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE").build();
    static final TableTestProgram VALUES_QUERY_OPERATION = TableTestProgram.of((String)"values-query-operation", (String)"verifies sql serialization").setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"}), Row.of((Object[])new Object[]{2L, "cde"})}).build()).runTableApi(t -> t.fromValues(new Object[]{Expressions.row((Object)1L, (Object[])new Object[]{"abc"}), Expressions.row((Object)2L, (Object[])new Object[]{"cde"})}), "sink").runSql("SELECT `$$T_VAL`.`f0`, `$$T_VAL`.`f1` FROM (VALUES \n    (CAST(1 AS BIGINT), 'abc'),\n    (CAST(2 AS BIGINT), 'cde')\n) $$T_VAL(`f0`, `f1`)").build();
    static final TableTestProgram FILTER_QUERY_OPERATION = TableTestProgram.of((String)"filter-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{10L, "abc"}), Row.of((Object[])new Object[]{20L, "cde"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{20L, "cde"})}).build()).runTableApi(t -> t.from("s").where((Expression)Expressions.$((String)"a").isGreaterOrEqual((Object)15)), "sink").runSql("SELECT `$$T_FILTER`.`a`, `$$T_FILTER`.`b` FROM (\n    SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n) $$T_FILTER WHERE `$$T_FILTER`.`a` >= 15").build();
    static final TableTestProgram DISTINCT_QUERY_OPERATION = TableTestProgram.of((String)"distinct-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{20L, "apple"}), Row.of((Object[])new Object[]{20L, "apple"}), Row.of((Object[])new Object[]{5L, "pear"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{20L, "apple"})}).build()).runTableApi(t -> t.from("s").where((Expression)Expressions.$((String)"a").isGreaterOrEqual((Object)15)).distinct(), "sink").runSql("SELECT DISTINCT `$$T_DISTINCT`.`a`, `$$T_DISTINCT`.`b` FROM (\n    SELECT `$$T_FILTER`.`a`, `$$T_FILTER`.`b` FROM (\n        SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n    ) $$T_FILTER WHERE `$$T_FILTER`.`a` >= 15\n) $$T_DISTINCT").build();
    static final TableTestProgram AGGREGATE_QUERY_OPERATION = TableTestProgram.of((String)"aggregate-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{10L, "apple"}), Row.of((Object[])new Object[]{20L, "apple"}), Row.of((Object[])new Object[]{5L, "pear"}), Row.of((Object[])new Object[]{15L, "pear"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a string", "b bigint"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{"apple", 30L}), Row.of((Object[])new Object[]{"pear", 20L})}).build()).runTableApi(t -> t.from("s").groupBy(new Expression[]{Expressions.$((String)"b")}).select(new Expression[]{Expressions.$((String)"b"), (Expression)Expressions.$((String)"a").sum()}), "sink").runSql("SELECT `$$T_PROJECT`.`b`, `$$T_PROJECT`.`EXPR$0` FROM (\n    SELECT `$$T_AGG`.`b`, (SUM(`$$T_AGG`.`a`)) AS `EXPR$0` FROM (\n        SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n    ) $$T_AGG\n    GROUP BY `$$T_AGG`.`b`\n) $$T_PROJECT").build();
    static final TableTestProgram AGGREGATE_NO_GROUP_BY_QUERY_OPERATION = TableTestProgram.of((String)"aggregate-query-no-group-by-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{10L, "apple"}), Row.of((Object[])new Object[]{20L, "apple"}), Row.of((Object[])new Object[]{5L, "pear"}), Row.of((Object[])new Object[]{15L, "pear"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"b bigint"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{50L})}).build()).runTableApi(t -> t.from("s").select(new Expression[]{(Expression)Expressions.$((String)"a").sum()}), "sink").runSql("SELECT `$$T_PROJECT`.`EXPR$0` FROM (\n    SELECT (SUM(`$$T_AGG`.`a`)) AS `EXPR$0` FROM (\n        SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n    ) $$T_AGG\n    GROUP BY 1\n) $$T_PROJECT").build();
    static final TableTestProgram WINDOW_AGGREGATE_QUERY_OPERATION = TableTestProgram.of((String)"window-aggregate-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string", "ts TIMESTAMP_LTZ(3)", "WATERMARK FOR ts AS ts - INTERVAL '1' SECOND"})).producedValues(new Row[]{Row.of((Object[])new Object[]{2L, "apple", QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{3L, "apple", QueryOperationTestPrograms.dayOfSeconds(4)}), Row.of((Object[])new Object[]{1L, "apple", QueryOperationTestPrograms.dayOfSeconds(7)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a string", "ts TIMESTAMP_LTZ(3)", "b bigint"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{"apple", QueryOperationTestPrograms.dayOfSeconds(0), 5L}), Row.of((Object[])new Object[]{"apple", QueryOperationTestPrograms.dayOfSeconds(5), 1L})}).build()).runTableApi(t -> t.from("s").window((GroupWindow)Tumble.over((Expression)((Expression)Expressions.lit((Object)5).seconds())).on((Expression)Expressions.$((String)"ts")).as("w")).groupBy(new Expression[]{Expressions.$((String)"w"), Expressions.$((String)"b")}).select(new Expression[]{Expressions.$((String)"b"), (Expression)Expressions.$((String)"w").start(), (Expression)Expressions.$((String)"a").sum()}), "sink").runSql("SELECT `$$T_PROJECT`.`b`, `$$T_PROJECT`.`EXPR$0`, `$$T_PROJECT`.`EXPR$1` FROM (\n    SELECT `$$T_WIN_AGG`.`b`, (SUM(`$$T_WIN_AGG`.`a`)) AS `EXPR$1`, (window_start) AS `EXPR$0` FROM TABLE(\n        TUMBLE((\n            SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b`, `$$T_SOURCE`.`ts` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n        ), DESCRIPTOR(`ts`), INTERVAL '0 00:00:05.0' DAY TO SECOND(3))\n    ) $$T_WIN_AGG GROUP BY window_start, window_end, `$$T_WIN_AGG`.`b`\n) $$T_PROJECT").build();
    static final TableTestProgram JOIN_QUERY_OPERATION = TableTestProgram.of((String)"join-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"d").addSchema(new String[]{"dept_id bigint", "d_name string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "Research"}), Row.of((Object[])new Object[]{2L, "Accounting"})}).build()).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"e").addSchema(new String[]{"emp_id bigint", "e_dept_id bigint", "name string", "age int"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, 2L, "Steve", 18}), Row.of((Object[])new Object[]{2L, 1L, "Helena", 22}), Row.of((Object[])new Object[]{3L, 2L, "Charlie", 25}), Row.of((Object[])new Object[]{4L, 1L, "Anna", 18})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"name string", "dept_name string", "age bigint"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{"Helena", "Research", 22L}), Row.of((Object[])new Object[]{"Charlie", "Accounting", 25L})}).build()).runTableApi(t -> t.from("e").join(t.from("d"), (Expression)((ApiExpression)Expressions.$((String)"e_dept_id").isEqual((Object)Expressions.$((String)"dept_id"))).and(Expressions.$((String)"age").isGreaterOrEqual((Object)21))).select(new Expression[]{Expressions.$((String)"name"), Expressions.$((String)"d_name"), Expressions.$((String)"age")}), "sink").runSql("SELECT `$$T_PROJECT`.`name`, `$$T_PROJECT`.`d_name`, `$$T_PROJECT`.`age` FROM (\n    SELECT `$$T1_JOIN`.`emp_id`, `$$T1_JOIN`.`e_dept_id`, `$$T1_JOIN`.`name`, `$$T1_JOIN`.`age`, `$$T2_JOIN`.`dept_id`, `$$T2_JOIN`.`d_name` FROM (\n        SELECT `$$T_SOURCE`.`emp_id`, `$$T_SOURCE`.`e_dept_id`, `$$T_SOURCE`.`name`, `$$T_SOURCE`.`age` FROM `default_catalog`.`default_database`.`e` $$T_SOURCE\n    ) $$T1_JOIN INNER JOIN (\n        SELECT `$$T_SOURCE`.`dept_id`, `$$T_SOURCE`.`d_name` FROM `default_catalog`.`default_database`.`d` $$T_SOURCE\n    ) $$T2_JOIN ON (`$$T1_JOIN`.`e_dept_id` = `$$T2_JOIN`.`dept_id`) AND (`$$T1_JOIN`.`age` >= 21)\n) $$T_PROJECT").build();
    static final TableTestProgram LATERAL_JOIN_QUERY_OPERATION = TableTestProgram.of((String)"lateral-join-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"e").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string", "f0 int"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc", 3})}).build()).setupCatalogFunction("udtf", JavaUserDefinedTableFunctions.JavaTableFunc1.class).runTableApi(t -> t.from("e").joinLateral((Expression)Expressions.call((String)"udtf", (Object[])new Object[]{Expressions.$((String)"b")}).as("f0", new String[0])), "sink").runSql("SELECT `$$T1_JOIN`.`a`, `$$T1_JOIN`.`b`, `$$T_LAT`.`f0` FROM (\n    SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`e` $$T_SOURCE\n) $$T1_JOIN INNER JOIN \n    LATERAL TABLE(`default_catalog`.`default_database`.`udtf`(`b`)) $$T_LAT(`f0`) ON TRUE").build();
    static final TableTestProgram UNION_ALL_QUERY_OPERATION = TableTestProgram.of((String)"union-all-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"})}).build()).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"t").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{2L, "cde"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"}), Row.of((Object[])new Object[]{2L, "cde"})}).build()).runTableApi(t -> t.from("s").unionAll(t.from("t")), "sink").runSql("SELECT `a`, `b` FROM (\n    SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n) UNION ALL (\n    SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`t` $$T_SOURCE\n)").build();
    static final TableTestProgram ORDER_BY_QUERY_OPERATION = TableTestProgram.of((String)"order-by-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "a"}), Row.of((Object[])new Object[]{2L, "b"}), Row.of((Object[])new Object[]{3L, "c"}), Row.of((Object[])new Object[]{4L, "d"}), Row.of((Object[])new Object[]{5L, "e"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{2L, "b"}), Row.of((Object[])new Object[]{3L, "c"})}).build()).runTableApi(t -> t.from("s").orderBy(new Expression[]{Expressions.$((String)"a"), (Expression)Expressions.$((String)"b").desc()}).offset(1).fetch(2), "sink").runSql("SELECT `$$T_SORT`.`a`, `$$T_SORT`.`b` FROM (\n    SELECT `$$T_SOURCE`.`a`, `$$T_SOURCE`.`b` FROM `default_catalog`.`default_database`.`s` $$T_SOURCE\n) $$T_SORT ORDER BY `$$T_SORT`.`a` ASC, `$$T_SORT`.`b` DESC OFFSET 1 ROWS FETCH NEXT 2 ROWS ONLY").build();
    static final TableTestProgram SQL_QUERY_OPERATION = TableTestProgram.of((String)"sql-query-operation", (String)"verifies sql serialization").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"s").addSchema(new String[]{"a bigint", "b string"})).producedValues(new Row[]{Row.of((Object[])new Object[]{1L, "abc"}), Row.of((Object[])new Object[]{2L, "cde"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"a bigint", "b string"})).consumedValues(new Row[]{Row.of((Object[])new Object[]{3L, "bc"}), Row.of((Object[])new Object[]{4L, "de"})}).build()).runTableApi(t -> t.sqlQuery("SELECT a, b FROM s").select(new Expression[]{(Expression)Expressions.$((String)"a").plus((Object)2), (Expression)Expressions.$((String)"b").substr((Object)2, (Object)3)}), "sink").runSql("SELECT (`$$T_PROJECT`.`a` + 2) AS `_c0`, (SUBSTR(`$$T_PROJECT`.`b`, 2, 3)) AS `_c1` FROM (\n    SELECT `s`.`a`, `s`.`b`\n    FROM `default_catalog`.`default_database`.`s` AS `s`\n) $$T_PROJECT").build();
    static final TableTestProgram GROUP_HOP_WINDOW_EVENT_TIME = TableTestProgram.of((String)"group-window-aggregate-hop-event-time", (String)"validates group by using hopping window with event time").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"ts STRING", "a_int INT", "b_double DOUBLE", "c_float FLOAT", "d_bigdec DECIMAL(10, 2)", "`comment` STRING", "name STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "`proctime` AS PROCTIME()", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:01", 1, 1.0, Float.valueOf(1.0f), new BigDecimal("1.11"), "Hi", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:02", 2, 2.0, Float.valueOf(2.0f), new BigDecimal("2.22"), "Comment#1", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:03", 2, 2.0, Float.valueOf(2.0f), new BigDecimal("2.22"), "Comment#1", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:04", 5, 5.0, Float.valueOf(5.0f), new BigDecimal("5.55"), null, "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:07", 3, 3.0, Float.valueOf(3.0f), null, "Hello", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:06", 6, 6.0, Float.valueOf(6.0f), new BigDecimal("6.66"), "Hi", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:08", 3, null, Float.valueOf(3.0f), new BigDecimal("3.33"), "Comment#2", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:04", 5, 5.0, null, new BigDecimal("5.55"), "Hi", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:16", 4, 4.0, Float.valueOf(4.0f), new BigDecimal("4.44"), "Hi", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:32", 7, 7.0, Float.valueOf(7.0f), new BigDecimal("7.77"), null, null}), Row.of((Object[])new Object[]{"2020-10-10 00:00:34", 1, 3.0, Float.valueOf(3.0f), new BigDecimal("3.33"), "Comment#3", "b"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:41", 10, 3.0, Float.valueOf(3.0f), new BigDecimal("4.44"), "Comment#4", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:42", 11, 4.0, Float.valueOf(4.0f), new BigDecimal("5.44"), "Comment#5", "d"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:43", 12, 5.0, Float.valueOf(5.0f), new BigDecimal("6.44"), "Comment#6", "c"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:44", 13, 6.0, Float.valueOf(6.0f), new BigDecimal("7.44"), "Comment#7", "d"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 4]", "+I[b, 2]", "+I[a, 6]", "+I[a, 1]", "+I[b, 2]", "+I[b, 1]", "+I[b, 1]"}).consumedAfterRestore(new String[]{"+I[b, 1]", "+I[null, 1]", "+I[b, 1]", "+I[null, 1]", "+I[a, 1]", "+I[d, 2]", "+I[c, 1]", "+I[a, 1]", "+I[c, 1]", "+I[d, 2]"}).build()).runTableApi(env -> env.from("source_t").window((GroupWindow)Slide.over((Expression)((Expression)Expressions.lit((Object)10).seconds())).every((Expression)Expressions.lit((Object)5).seconds()).on((Expression)Expressions.$((String)"rowtime")).as("w")).groupBy(new Expression[]{Expressions.$((String)"name"), Expressions.$((String)"w")}).select(new Expression[]{Expressions.$((String)"name"), (Expression)Expressions.lit((Object)1).count()}), "sink_t").build();
    static final TableTestProgram SORT_LIMIT_DESC = TableTestProgram.of((String)"sort-limit-desc", (String)"validates sort limit node by sorting integers in desc mode").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b VARCHAR", "c INT"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2, "a", 6}), Row.of((Object[])new Object[]{4, "b", 8}), Row.of((Object[])new Object[]{6, "c", 10}), Row.of((Object[])new Object[]{1, "a", 5}), Row.of((Object[])new Object[]{3, "b", 7}), Row.of((Object[])new Object[]{5, "c", 9})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, "a", 6}), Row.of((Object[])new Object[]{6, "c", 10}), Row.of((Object[])new Object[]{5, "c", 9})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b VARCHAR", "c BIGINT"})).consumedBeforeRestore(new String[]{"+I[2, a, 6]", "+I[4, b, 8]", "+I[6, c, 10]", "-D[2, a, 6]", "+I[3, b, 7]", "-D[3, b, 7]", "+I[5, c, 9]"}).consumedAfterRestore(new String[]{"-D[4, b, 8]", "+I[6, c, 10]"}).build()).runTableApi(env -> env.from("source_t").orderBy(new Expression[]{(Expression)Expressions.$((String)"a").desc()}).limit(3), "sink_t").build();
    static final TableTestProgram GROUP_BY_UDF_WITH_MERGE = TableTestProgram.of((String)"group-aggregate-udf-with-merge", (String)"validates udfs with merging using group by").setupCatalogFunction("my_avg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class).setupTemporarySystemFunction("my_concat", JavaUserDefinedAggFunctions.ConcatDistinctAggFunction.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c INT", "d VARCHAR", "e BIGINT"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2, 3L, 2, "Hello World Like", 1L}), Row.of((Object[])new Object[]{3, 4L, 3, "Hello World Its nice", 2L}), Row.of((Object[])new Object[]{2, 2L, 1, "Hello World", 2L}), Row.of((Object[])new Object[]{1, 1L, 0, "Hello", 1L}), Row.of((Object[])new Object[]{5, 11L, 10, "GHI", 1L}), Row.of((Object[])new Object[]{3, 5L, 4, "ABC", 2L}), Row.of((Object[])new Object[]{4, 10L, 9, "FGH", 2L}), Row.of((Object[])new Object[]{4, 7L, 6, "CDE", 2L}), Row.of((Object[])new Object[]{5, 14L, 13, "JKL", 2L}), Row.of((Object[])new Object[]{4, 9L, 8, "EFG", 1L}), Row.of((Object[])new Object[]{5, 15L, 14, "KLM", 2L}), Row.of((Object[])new Object[]{5, 12L, 11, "HIJ", 3L}), Row.of((Object[])new Object[]{4, 8L, 7, "DEF", 1L}), Row.of((Object[])new Object[]{5, 13L, 12, "IJK", 3L}), Row.of((Object[])new Object[]{3, 6L, 5, "BCD", 3L})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, 0, "Hello", 1L}), Row.of((Object[])new Object[]{3, 5L, 4, "ABC", 2L}), Row.of((Object[])new Object[]{4, 10L, 9, "FGH", 2L}), Row.of((Object[])new Object[]{4, 7L, 6, "CDE", 2L}), Row.of((Object[])new Object[]{7, 7L, 7, "MNO", 7L}), Row.of((Object[])new Object[]{3, 6L, 5, "BCD", 3L}), Row.of((Object[])new Object[]{7, 7L, 7, "XYZ", 7L})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"d BIGINT", "s1 BIGINT", "c1 VARCHAR", "PRIMARY KEY (d) NOT ENFORCED"})).consumedBeforeRestore(new String[]{"+I[1, 1, Hello World Like]", "+I[2, 2, Hello World Its nice]", "+U[2, 2, Hello World Its nice|Hello World]", "+U[1, 1, Hello World Like|Hello]", "+U[1, 1, Hello World Like|Hello|GHI]", "+U[2, 2, Hello World Its nice|Hello World|ABC]", "+U[2, 2, Hello World Its nice|Hello World|ABC|FGH]", "+U[2, 2, Hello World Its nice|Hello World|ABC|FGH|CDE]", "+U[2, 2, Hello World Its nice|Hello World|ABC|FGH|CDE|JKL]", "+U[1, 1, Hello World Like|Hello|GHI|EFG]", "+U[2, 2, Hello World Its nice|Hello World|ABC|FGH|CDE|JKL|KLM]", "+I[3, 3, HIJ]", "+U[1, 1, Hello World Like|Hello|GHI|EFG|DEF]", "+U[3, 3, HIJ|IJK]", "+U[3, 3, HIJ|IJK|BCD]"}).consumedAfterRestore(new String[]{"+I[7, 7, MNO]", "+U[7, 7, MNO|XYZ]"}).build()).runTableApi(env -> env.from("source_t").groupBy(new Expression[]{Expressions.$((String)"e")}).select(new Expression[]{Expressions.$((String)"e"), (Expression)Expressions.call((String)"my_avg", (Object[])new Object[]{Expressions.$((String)"e"), Expressions.$((String)"a")}).as("s1", new String[0]), (Expression)Expressions.call((String)"my_concat", (Object[])new Object[]{Expressions.$((String)"d")}).as("c1", new String[0])}), "sink_t").build();
    static final TableTestProgram NON_WINDOW_INNER_JOIN = TableTestProgram.of((String)"join-non-window-inner-join", (String)"test non-window inner join").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"T1").addSchema(new String[]{"a int", "b bigint", "c varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "Baker1"}), Row.of((Object[])new Object[]{1, 2L, "Baker2"}), Row.of((Object[])new Object[]{1, 2L, "Baker2"}), Row.of((Object[])new Object[]{1, 5L, "Baker3"}), Row.of((Object[])new Object[]{2, 7L, "Baker5"}), Row.of((Object[])new Object[]{1, 9L, "Baker6"}), Row.of((Object[])new Object[]{1, 8L, "Baker8"}), Row.of((Object[])new Object[]{3, 8L, "Baker9"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "PostRestore"})}).build()).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"T2").addSchema(new String[]{"a int", "b bigint", "c varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "BakerBaker"}), Row.of((Object[])new Object[]{2, 2L, "HeHe"}), Row.of((Object[])new Object[]{3, 2L, "HeHe"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, 1L, "PostRestoreRight"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"a int", "c1 varchar", "c2 varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker3"}), Row.of((Object[])new Object[]{2, "HeHe", "Baker5"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker6"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker8"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, "PostRestoreRight", "Baker5"})}).build()).runSql("insert into MySink SELECT t2.a, t2.c, t1.c\nFROM (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T1\n) as t1\nJOIN (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T2\n) as t2\nON t1.a = t2.a AND t1.b > t2.b").runTableApi(env -> {
        Table t1 = env.from("T1").select(new Expression[]{(Expression)Expressions.ifThenElse((Object)Expressions.$((String)"a").isEqual((Object)3), (Object)Expressions.nullOf((DataType)DataTypes.INT()), (Object)Expressions.$((String)"a")).as("a1", new String[0]), (Expression)Expressions.$((String)"b").as("b1", new String[0]), (Expression)Expressions.$((String)"c").as("c1", new String[0])});
        Table t2 = env.from("T2").select(new Expression[]{(Expression)Expressions.ifThenElse((Object)Expressions.$((String)"a").isEqual((Object)3), (Object)Expressions.nullOf((DataType)DataTypes.INT()), (Object)Expressions.$((String)"a")).as("a2", new String[0]), (Expression)Expressions.$((String)"b").as("b2", new String[0]), (Expression)Expressions.$((String)"c").as("c2", new String[0])});
        return t1.join(t2, (Expression)((ApiExpression)Expressions.$((String)"a1").isEqual((Object)Expressions.$((String)"a2"))).and(Expressions.$((String)"b1").isGreater((Object)Expressions.$((String)"b2")))).select(new Expression[]{Expressions.$((String)"a2"), Expressions.$((String)"c2"), Expressions.$((String)"c1")});
    }, "MySink").build();
    static final TableTestProgram OVER_WINDOW_RANGE = TableTestProgram.of((String)"over-window-range", (String)"test over window with time range").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"data").addSchema(new String[]{"k string", "v bigint", "ts TIMESTAMP_LTZ(3)", "WATERMARK for `ts` AS `ts`"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{"Apple", 4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"k string", "v bigint", "ts TIMESTAMP_LTZ(3)"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{"Apple", 4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).runSql("SELECT `$$T_PROJECT`.`k`, (LAST_VALUE(`$$T_PROJECT`.`v`) OVER(PARTITION BY `$$T_PROJECT`.`k` ORDER BY `$$T_PROJECT`.`ts` RANGE BETWEEN INTERVAL '0 00:00:02.0' DAY TO SECOND(3) PRECEDING AND CURRENT ROW)) AS `_c1`, `$$T_PROJECT`.`ts` FROM (\n    SELECT `$$T_SOURCE`.`k`, `$$T_SOURCE`.`v`, `$$T_SOURCE`.`ts` FROM `default_catalog`.`default_database`.`data` $$T_SOURCE\n) $$T_PROJECT").runTableApi(tableEnvAccessor -> tableEnvAccessor.from("data").window(new OverWindow[]{Over.partitionBy((Expression[])new Expression[]{Expressions.$((String)"k")}).orderBy((Expression)Expressions.$((String)"ts")).preceding((Expression)Expressions.lit((Object)2).second()).as("w")}).select(new Expression[]{Expressions.$((String)"k"), (Expression)((ApiExpression)Expressions.$((String)"v").lastValue()).over((Object)Expressions.$((String)"w")), Expressions.$((String)"ts")}), "sink").build();
    static final TableTestProgram OVER_WINDOW_ROWS = TableTestProgram.of((String)"over-window-rows", (String)"test over window with rows range").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"data").addSchema(new String[]{"k string", "v bigint", "ts TIMESTAMP_LTZ(3)", "WATERMARK for `ts` AS `ts`"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{"Apple", 4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"k string", "v bigint", "ts TIMESTAMP_LTZ(3)"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{"Apple", 4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).runSql("SELECT `$$T_PROJECT`.`k`, (LAST_VALUE(`$$T_PROJECT`.`v`) OVER(PARTITION BY `$$T_PROJECT`.`k` ORDER BY `$$T_PROJECT`.`ts` ROWS BETWEEN CAST(2 AS BIGINT) PRECEDING AND CURRENT ROW)) AS `_c1`, `$$T_PROJECT`.`ts` FROM (\n    SELECT `$$T_SOURCE`.`k`, `$$T_SOURCE`.`v`, `$$T_SOURCE`.`ts` FROM `default_catalog`.`default_database`.`data` $$T_SOURCE\n) $$T_PROJECT").runTableApi(tableEnvAccessor -> tableEnvAccessor.from("data").window(new OverWindow[]{Over.partitionBy((Expression[])new Expression[]{Expressions.$((String)"k")}).orderBy((Expression)Expressions.$((String)"ts")).preceding((Expression)Expressions.lit((Object)2L)).as("w")}).select(new Expression[]{Expressions.$((String)"k"), (Expression)((ApiExpression)Expressions.$((String)"v").lastValue()).over((Object)Expressions.$((String)"w")), Expressions.$((String)"ts")}), "sink").build();
    static final TableTestProgram OVER_WINDOW_ROWS_UNBOUNDED_NO_PARTITION = TableTestProgram.of((String)"over-window-rows-unbounded-no-partition", (String)"test over window with rows range").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"data").addSchema(new String[]{"k string", "v bigint", "ts TIMESTAMP_LTZ(3)", "WATERMARK for `ts` AS `ts`"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{"Apple", 4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Apple", 3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"v bigint", "ts TIMESTAMP_LTZ(3)"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{5L, QueryOperationTestPrograms.dayOfSeconds(0)}), Row.of((Object[])new Object[]{4L, QueryOperationTestPrograms.dayOfSeconds(1)})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{3L, QueryOperationTestPrograms.dayOfSeconds(2)})}).build()).runSql("SELECT (LAST_VALUE(`$$T_PROJECT`.`v`) OVER(ORDER BY `$$T_PROJECT`.`ts` ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)) AS `_c0`, `$$T_PROJECT`.`ts` FROM (\n    SELECT `$$T_SOURCE`.`k`, `$$T_SOURCE`.`v`, `$$T_SOURCE`.`ts` FROM `default_catalog`.`default_database`.`data` $$T_SOURCE\n) $$T_PROJECT").runTableApi(tableEnvAccessor -> tableEnvAccessor.from("data").window(new OverWindow[]{Over.orderBy((Expression)Expressions.$((String)"ts")).preceding((Expression)Expressions.UNBOUNDED_ROW).as("w")}).select(new Expression[]{(Expression)((ApiExpression)Expressions.$((String)"v").lastValue()).over((Object)Expressions.$((String)"w")), Expressions.$((String)"ts")}), "sink").build();
    static final TableTestProgram OVER_WINDOW_LAG = TableTestProgram.of((String)"over-window-lag", (String)"validates over window with lag function").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"t").addSchema(new String[]{"ts STRING", "b MAP<DOUBLE, DOUBLE>", "`r_time` AS TO_TIMESTAMP(`ts`)", "WATERMARK for `r_time` AS `r_time`"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:05", Collections.singletonMap(42.0, 42.0)})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:06", Collections.singletonMap(42.1, 42.1)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"ts STRING", "b MAP<DOUBLE, DOUBLE>"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:05", null})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:06", Collections.singletonMap(42.0, 42.0)})}).build()).runTableApi(env -> env.from("t").window(new OverWindow[]{Over.orderBy((Expression)Expressions.$((String)"r_time")).as("bLag")}).select(new Expression[]{Expressions.$((String)"ts"), (Expression)Expressions.lag((Object)Expressions.$((String)"b"), (Object)1).over((Object)Expressions.$((String)"bLag"))}), "sink_t").runSql("SELECT `$$T_PROJECT`.`ts`, (LAG(`$$T_PROJECT`.`b`, 1) OVER(ORDER BY `$$T_PROJECT`.`r_time`)) AS `_c1` FROM (\n    SELECT `$$T_SOURCE`.`ts`, `$$T_SOURCE`.`b`, `$$T_SOURCE`.`r_time` FROM `default_catalog`.`default_database`.`t` $$T_SOURCE\n) $$T_PROJECT").build();
    static final TableTestProgram ACCESSING_NESTED_COLUMN = TableTestProgram.of((String)"project-nested-columnd", (String)"test projection with nested columns of an inline type").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"data").addSchema(new String[]{"f0 bigint"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1L}), Row.of((Object[])new Object[]{2L})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{3L})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink").addSchema(new String[]{"v bigint"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1L}), Row.of((Object[])new Object[]{2L})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{3L})}).build()).runSql("SELECT (`$$T_PROJECT`.`composite_column`.`f0_nested`) AS `composite_column$f0_nested` FROM (\n    SELECT (CAST(ROW(`$$T_PROJECT`.`f0`, 'a') AS ROW<`f0_nested` BIGINT, `f1_nested` VARCHAR(2147483647)>)) AS `composite_column` FROM (\n        SELECT `$$T_SOURCE`.`f0` FROM `default_catalog`.`default_database`.`data` $$T_SOURCE\n    ) $$T_PROJECT\n) $$T_PROJECT").runTableApi(tableEnvAccessor -> tableEnvAccessor.from("data").select(new Expression[]{(Expression)((ApiExpression)Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.lit((Object)"a")}).cast(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_nested", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1_nested", (DataType)DataTypes.STRING())}))).as("composite_column", new String[0])}).select(new Expression[]{(Expression)Expressions.$((String)"composite_column").get("f0_nested")}), "sink").build();

    private static Instant dayOfSeconds(int second) {
        return LocalDateTime.of(2024, 1, 1, 0, 0, second).atZone(ZoneId.of("UTC")).toInstant();
    }
}

