/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.source;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.source.TerminatingLogic;
import org.apache.flink.connector.source.ValuesSourceReader;
import org.apache.flink.connector.source.enumerator.NoOpEnumState;
import org.apache.flink.connector.source.enumerator.NoOpEnumStateSerializer;
import org.apache.flink.connector.source.enumerator.ValuesSourceEnumerator;
import org.apache.flink.connector.source.split.ValuesSourceSplit;
import org.apache.flink.connector.source.split.ValuesSourceSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageDatasetFacet;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.LineageVertexProvider;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public class ValuesSource
implements Source<RowData, ValuesSourceSplit, NoOpEnumState>,
LineageVertexProvider {
    private static final String LINEAGE_NAMESPACE = "values://ValuesSource";
    private final TypeSerializer<RowData> serializer;
    private final List<byte[]> serializedElements;
    private final TerminatingLogic terminatingLogic;
    private final Boundedness boundedness;

    public ValuesSource(TerminatingLogic terminatingLogic, Boundedness boundedness, Collection<RowData> elements, TypeSerializer<RowData> serializer) {
        Preconditions.checkState((serializer != null ? 1 : 0) != 0, (Object)"serializer not set");
        this.serializedElements = this.serializeElements(elements, serializer);
        this.serializer = serializer;
        this.terminatingLogic = terminatingLogic;
        this.boundedness = boundedness;
    }

    private List<byte[]> serializeElements(Collection<RowData> elements, TypeSerializer<RowData> serializer) {
        ArrayList<byte[]> serializeElements = new ArrayList<byte[]>();
        for (RowData element : elements) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);){
                serializer.serialize((Object)element, (DataOutputView)wrapper);
                serializeElements.add(baos.toByteArray());
            }
            catch (Exception e) {
                throw new TableException("Serializing the source elements failed: " + e.getMessage(), (Throwable)e);
            }
        }
        return serializeElements;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SourceReader<RowData, ValuesSourceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return new ValuesSourceReader(this.serializedElements, this.serializer, readerContext);
    }

    public SplitEnumerator<ValuesSourceSplit, NoOpEnumState> createEnumerator(SplitEnumeratorContext<ValuesSourceSplit> enumContext) {
        List<ValuesSourceSplit> splits = IntStream.range(0, this.serializedElements.size()).mapToObj(ValuesSourceSplit::new).collect(Collectors.toList());
        return new ValuesSourceEnumerator(enumContext, splits, this.terminatingLogic);
    }

    public SplitEnumerator<ValuesSourceSplit, NoOpEnumState> restoreEnumerator(SplitEnumeratorContext<ValuesSourceSplit> enumContext, NoOpEnumState checkpoint) throws Exception {
        return this.createEnumerator(enumContext);
    }

    public SimpleVersionedSerializer<ValuesSourceSplit> getSplitSerializer() {
        return new ValuesSourceSplitSerializer();
    }

    public SimpleVersionedSerializer<NoOpEnumState> getEnumeratorCheckpointSerializer() {
        return new NoOpEnumStateSerializer();
    }

    public LineageVertex getLineageVertex() {
        return new SourceLineageVertex(){

            public Boundedness boundedness() {
                return ValuesSource.this.boundedness;
            }

            public List<LineageDataset> datasets() {
                LineageDataset dataset = new LineageDataset(){

                    public String name() {
                        return "";
                    }

                    public String namespace() {
                        return ValuesSource.LINEAGE_NAMESPACE;
                    }

                    public Map<String, LineageDatasetFacet> facets() {
                        return new HashMap<String, LineageDatasetFacet>();
                    }
                };
                return Arrays.asList(dataset);
            }
        };
    }
}

