/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.source;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.source.DynamicFilteringValuesSourceReader;
import org.apache.flink.connector.source.TerminatingLogic;
import org.apache.flink.connector.source.enumerator.DynamicFilteringValuesSourceEnumerator;
import org.apache.flink.connector.source.enumerator.NoOpEnumState;
import org.apache.flink.connector.source.enumerator.NoOpEnumStateSerializer;
import org.apache.flink.connector.source.split.ValuesSourcePartitionSplit;
import org.apache.flink.connector.source.split.ValuesSourcePartitionSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public class DynamicFilteringValuesSource
implements Source<RowData, ValuesSourcePartitionSplit, NoOpEnumState> {
    private final TypeSerializer<RowData> serializer;
    private final TerminatingLogic terminatingLogic;
    private final Boundedness boundedness;
    private Map<Map<String, String>, byte[]> serializedElements;
    private Map<Map<String, String>, Integer> counts;
    private final List<String> dynamicFilteringFields;

    public DynamicFilteringValuesSource(TerminatingLogic terminatingLogic, Boundedness boundedness, Map<Map<String, String>, Collection<RowData>> elements, TypeSerializer<RowData> serializer, List<String> dynamicFilteringFields) {
        this.serializer = serializer;
        this.dynamicFilteringFields = dynamicFilteringFields;
        this.terminatingLogic = terminatingLogic;
        this.boundedness = boundedness;
        this.serializeElements(serializer, elements);
    }

    private void serializeElements(TypeSerializer<RowData> serializer, Map<Map<String, String>, Collection<RowData>> elements) {
        Preconditions.checkState((serializer != null ? 1 : 0) != 0, (Object)"serializer not set");
        this.serializedElements = new HashMap<Map<String, String>, byte[]>();
        this.counts = new HashMap<Map<String, String>, Integer>();
        for (Map<String, String> partition : elements.keySet()) {
            Collection<RowData> collection = elements.get(partition);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);){
                for (RowData e : collection) {
                    serializer.serialize((Object)e, (DataOutputView)wrapper);
                }
                byte[] value = baos.toByteArray();
                this.serializedElements.put(partition, value);
            }
            catch (Exception e) {
                throw new TableException("Serializing the source elements failed: " + e.getMessage(), (Throwable)e);
            }
            this.counts.put(partition, collection.size());
        }
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SourceReader<RowData, ValuesSourcePartitionSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return new DynamicFilteringValuesSourceReader(this.serializedElements, this.counts, this.serializer, readerContext);
    }

    public SplitEnumerator<ValuesSourcePartitionSplit, NoOpEnumState> createEnumerator(SplitEnumeratorContext<ValuesSourcePartitionSplit> context) throws Exception {
        List<ValuesSourcePartitionSplit> splits = this.serializedElements.keySet().stream().map(ValuesSourcePartitionSplit::new).collect(Collectors.toList());
        return new DynamicFilteringValuesSourceEnumerator(context, this.terminatingLogic, splits, this.dynamicFilteringFields);
    }

    public SplitEnumerator<ValuesSourcePartitionSplit, NoOpEnumState> restoreEnumerator(SplitEnumeratorContext<ValuesSourcePartitionSplit> context, NoOpEnumState checkpoint) throws Exception {
        return this.createEnumerator(context);
    }

    public SimpleVersionedSerializer<ValuesSourcePartitionSplit> getSplitSerializer() {
        return new ValuesSourcePartitionSplitSerializer();
    }

    public SimpleVersionedSerializer<NoOpEnumState> getEnumeratorCheckpointSerializer() {
        return new NoOpEnumStateSerializer();
    }
}

