/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.loader.DelegateExecutorFactory;
import org.apache.flink.table.planner.loader.DelegatePlannerFactory;
import org.apache.flink.table.planner.loader.PlannerModule;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class LoaderITCase
extends TestLogger {
    @Test
    public void testExecutorFactory() {
        Assertions.assertThat((InputStream)DelegateExecutorFactory.class.getClassLoader().getResourceAsStream("flink-table-planner.jar")).isNotNull();
        ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)LoaderITCase.class.getClassLoader(), ExecutorFactory.class, (String)"default");
        ((ObjectAssert)Assertions.assertThat((Object)executorFactory).isNotNull()).isInstanceOf(DelegateExecutorFactory.class);
        Assertions.assertThat((String)executorFactory.factoryIdentifier()).isEqualTo("default");
    }

    @Test
    public void testPlannerFactory() {
        Assertions.assertThat((InputStream)DelegatePlannerFactory.class.getClassLoader().getResourceAsStream("flink-table-planner.jar")).isNotNull();
        PlannerFactory plannerFactory = (PlannerFactory)FactoryUtil.discoverFactory((ClassLoader)LoaderITCase.class.getClassLoader(), PlannerFactory.class, (String)"default");
        ((ObjectAssert)Assertions.assertThat((Object)plannerFactory).isNotNull()).isInstanceOf(DelegatePlannerFactory.class);
        Assertions.assertThat((String)plannerFactory.factoryIdentifier()).isEqualTo("default");
    }

    @Test
    public void testPlannerJarLeak() throws IOException {
        PlannerModule plannerModule = PlannerModule.getInstance();
        Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories((Configuration)new Configuration())[0], new String[0]);
        Files.createDirectories(FileUtils.getTargetPathIfContainsSymbolicPath((Path)tmpDirectory), new FileAttribute[0]);
        Assertions.assertThat((boolean)tmpDirectory.startsWith("flink-table-planner_")).isEqualTo(false);
    }
}

