/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.test.InternalDataUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

@Experimental
public class MapDataAssert
extends AbstractAssert<MapDataAssert, MapData> {
    public MapDataAssert(MapData mapData) {
        super((Object)mapData, MapDataAssert.class);
    }

    public MapDataAssert hasSize(int size) {
        this.isNotNull();
        Assertions.assertThat((int)((MapData)this.actual).size()).isEqualTo(size);
        return this;
    }

    public MapDataAssert asGeneric(DataType dataType) {
        return this.asGeneric(dataType.getLogicalType());
    }

    public MapDataAssert asGeneric(LogicalType logicalType) {
        GenericMapData actual = InternalDataUtils.toGenericMap((MapData)this.actual, logicalType);
        return (MapDataAssert)new MapDataAssert((MapData)actual).usingComparator((x, y) -> {
            x = x == actual ? x : InternalDataUtils.toGenericMap(x, logicalType);
            Object object = y = y == actual ? y : InternalDataUtils.toGenericMap(y, logicalType);
            if (Objects.equals(x, y)) {
                return 0;
            }
            return Objects.hashCode(x) < Objects.hashCode(y) ? -1 : 1;
        });
    }
}

