/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.test.DataTypeConditions;
import org.apache.flink.table.test.LogicalTypeAssert;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;

@Experimental
public class DataTypeAssert
extends AbstractAssert<DataTypeAssert, DataType> {
    public DataTypeAssert(DataType dataType) {
        super((Object)dataType, DataTypeAssert.class);
    }

    public LogicalTypeAssert asLogicalType() {
        this.isNotNull();
        return new LogicalTypeAssert(((DataType)this.actual).getLogicalType());
    }

    public ClassAssert getConversionClass() {
        this.isNotNull();
        return new ClassAssert(((DataType)this.actual).getConversionClass());
    }

    public ListAssert<DataType> getChildren() {
        this.isNotNull();
        return new ListAssert(((DataType)this.actual).getChildren());
    }

    public DataTypeAssert hasConversionClass(Class<?> clazz) {
        this.isNotNull();
        this.getConversionClass().isEqualTo(clazz);
        return this;
    }

    public DataTypeAssert hasLogicalType(LogicalType logicalType) {
        this.isNotNull();
        this.asLogicalType().isEqualTo(logicalType);
        return this;
    }

    public DataTypeAssert isNullable() {
        this.satisfies(DataTypeConditions.NULLABLE);
        return this;
    }

    public DataTypeAssert isNotNullable() {
        this.satisfies((Condition)Assertions.not(DataTypeConditions.NULLABLE));
        return this;
    }
}

