/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;

public class TestFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "test-format";
    public static final ConfigOption<String> DELIMITER = ConfigOptions.key((String)"delimiter").stringType().noDefaultValue().withDeprecatedKeys(new String[]{"deprecated-delimiter"});
    public static final ConfigOption<Boolean> FAIL_ON_MISSING = ConfigOptions.key((String)"fail-on-missing").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{"fallback-fail-on-missing"});
    public static final ConfigOption<List<String>> CHANGELOG_MODE = ConfigOptions.key((String)"changelog-mode").stringType().asList().noDefaultValue();
    private static final ConfigOption<Map<String, String>> READABLE_METADATA = ConfigOptions.key((String)"readable-metadata").mapType().defaultValue(Collections.emptyMap()).withDescription("Optional map of 'metadata_key:data_type,...'. The order will be alphabetically.");

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatConfig) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatConfig);
        Map<String, DataType> readableMetadata = TestFormatFactory.convertToMetadataMap((Map)formatConfig.get(READABLE_METADATA), context.getClassLoader());
        ChangelogMode changelogMode = TestFormatFactory.parseChangelogMode(formatConfig);
        return new DecodingFormatMock((String)formatConfig.get(DELIMITER), (Boolean)formatConfig.get(FAIL_ON_MISSING), changelogMode, readableMetadata);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatConfig) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatConfig);
        ChangelogMode changelogMode = TestFormatFactory.parseChangelogMode(formatConfig);
        return new EncodingFormatMock((String)formatConfig.get(DELIMITER), changelogMode);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(DELIMITER);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FAIL_ON_MISSING);
        options.add(CHANGELOG_MODE);
        options.add(READABLE_METADATA);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        HashSet options = new HashSet();
        options.add(DELIMITER);
        return options;
    }

    private static Map<String, DataType> convertToMetadataMap(Map<String, String> metadataOption, ClassLoader classLoader) {
        return metadataOption.keySet().stream().sorted().collect(Collectors.toMap(Function.identity(), key -> {
            String typeString = (String)metadataOption.get(key);
            LogicalType type = LogicalTypeParser.parse((String)typeString, (ClassLoader)classLoader);
            return TypeConversions.fromLogicalToDataType((LogicalType)type);
        }, (u, v) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    private static ChangelogMode parseChangelogMode(ReadableConfig config) {
        if (config.getOptional(CHANGELOG_MODE).isPresent()) {
            ChangelogMode.Builder builder = ChangelogMode.newBuilder();
            Iterator iterator = ((List)config.get(CHANGELOG_MODE)).iterator();
            block12: while (iterator.hasNext()) {
                String mode;
                switch (mode = (String)iterator.next()) {
                    case "I": {
                        builder.addContainedKind(RowKind.INSERT);
                        continue block12;
                    }
                    case "UA": {
                        builder.addContainedKind(RowKind.UPDATE_AFTER);
                        continue block12;
                    }
                    case "UB": {
                        builder.addContainedKind(RowKind.UPDATE_BEFORE);
                        continue block12;
                    }
                    case "D": {
                        builder.addContainedKind(RowKind.DELETE);
                        continue block12;
                    }
                }
                throw new IllegalArgumentException(String.format("Unrecognized type %s for config %s", mode, CHANGELOG_MODE.key()));
            }
            return builder.build();
        }
        return ChangelogMode.insertOnly();
    }

    public static class DecodingFormatMock
    implements DecodingFormat<DeserializationSchema<RowData>> {
        public final String delimiter;
        public final Boolean failOnMissing;
        private final ChangelogMode changelogMode;
        public final Map<String, DataType> readableMetadata;
        public DataType producedDataType;
        public List<String> metadataKeys;

        public DecodingFormatMock(String delimiter, Boolean failOnMissing, ChangelogMode changelogMode, Map<String, DataType> readableMetadata) {
            this.delimiter = delimiter;
            this.failOnMissing = failOnMissing;
            this.changelogMode = changelogMode;
            this.readableMetadata = readableMetadata;
            this.metadataKeys = Collections.emptyList();
        }

        public DecodingFormatMock(String delimiter, Boolean failOnMissing) {
            this(delimiter, failOnMissing, ChangelogMode.insertOnly(), Collections.emptyMap());
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
            List metadataFields = this.metadataKeys.stream().map(k -> DataTypes.FIELD((String)k, (DataType)this.readableMetadata.get(k))).collect(Collectors.toList());
            this.producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
            return new DeserializationSchemaMock((TypeInformation<RowData>)context.createTypeInformation(this.producedDataType));
        }

        public Map<String, DataType> listReadableMetadata() {
            return this.readableMetadata;
        }

        public void applyReadableMetadata(List<String> metadataKeys) {
            this.metadataKeys = metadataKeys;
        }

        public ChangelogMode getChangelogMode() {
            return this.changelogMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecodingFormatMock that = (DecodingFormatMock)o;
            return this.delimiter.equals(that.delimiter) && this.failOnMissing.equals(that.failOnMissing) && this.changelogMode.equals((Object)that.changelogMode) && this.readableMetadata.equals(that.readableMetadata) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
        }

        public int hashCode() {
            return Objects.hash(this.delimiter, this.failOnMissing, this.changelogMode, this.readableMetadata, this.producedDataType, this.metadataKeys);
        }
    }

    public static class EncodingFormatMock
    implements EncodingFormat<SerializationSchema<RowData>> {
        public final String delimiter;
        public DataType consumedDataType;
        private ChangelogMode changelogMode;

        public EncodingFormatMock(String delimiter, ChangelogMode changelogMode) {
            this.delimiter = delimiter;
            this.changelogMode = changelogMode;
        }

        public EncodingFormatMock(String delimiter) {
            this(delimiter, ChangelogMode.insertOnly());
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType physicalDataType) {
            this.consumedDataType = physicalDataType;
            return new SerializationSchemaMock();
        }

        public ChangelogMode getChangelogMode() {
            return this.changelogMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodingFormatMock that = (EncodingFormatMock)o;
            return this.delimiter.equals(that.delimiter) && this.changelogMode.equals((Object)that.changelogMode) && Objects.equals(this.consumedDataType, that.consumedDataType);
        }

        public int hashCode() {
            return Objects.hash(this.delimiter, this.changelogMode, this.consumedDataType);
        }
    }

    private static class SerializationSchemaMock
    implements SerializationSchema<RowData> {
        private SerializationSchemaMock() {
        }

        public byte[] serialize(RowData element) {
            String msg = "Test serialization schema doesn't support serialize.";
            throw new UnsupportedOperationException(msg);
        }
    }

    private static class DeserializationSchemaMock
    implements DeserializationSchema<RowData> {
        private final TypeInformation<RowData> producedTypeInfo;

        private DeserializationSchemaMock(TypeInformation<RowData> producedTypeInfo) {
            this.producedTypeInfo = producedTypeInfo;
        }

        public RowData deserialize(byte[] message) {
            String msg = "Test deserialization schema doesn't support deserialize.";
            throw new UnsupportedOperationException(msg);
        }

        public boolean isEndOfStream(RowData nextElement) {
            return false;
        }

        public TypeInformation<RowData> getProducedType() {
            return this.producedTypeInfo;
        }
    }
}

