/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.CodeRewriter;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStreams;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class ReturnValueRewriter
implements CodeRewriter {
    private final int maxMethodLength;
    private final CommonTokenStream tokenStream;
    private final TokenStreamRewriter rewriter;

    public ReturnValueRewriter(String code, int maxMethodLength) {
        this.maxMethodLength = maxMethodLength;
        this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
        this.rewriter = new TokenStreamRewriter(this.tokenStream);
    }

    @Override
    public String rewrite() {
        OuterVisitor visitor = new OuterVisitor();
        JavaParser javaParser = new JavaParser(this.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        visitor.visit(javaParser.compilationUnit());
        return this.rewriter.getText();
    }

    private class OuterVisitor
    extends JavaParserBaseVisitor<Void> {
        private final Stack<StringBuilder> newFields = new Stack();

        private OuterVisitor() {
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            this.newFields.push(new StringBuilder());
            Void ret = (Void)this.visitChildren(ctx);
            ReturnValueRewriter.this.rewriter.insertAfter(ctx.start, (Object)("\n" + this.newFields.pop().toString()));
            return ret;
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if ("void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            long methodBodyLength = CodeSplitUtil.getContextTextLength(ctx.methodBody().block());
            if (methodBodyLength < (long)ReturnValueRewriter.this.maxMethodLength) {
                return null;
            }
            if (ctx.methodBody().block().blockStatement() == null || ctx.methodBody().block().blockStatement().size() <= 1) {
                return null;
            }
            final LinkedHashSet declarations = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarations.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit(ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            Object methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            String returnVarName = CodeSplitUtil.newName(functionName + "ReturnValue");
            this.newFields.peek().append(String.format("%s %s;\n", type, returnVarName));
            InnerVisitor visitor = new InnerVisitor(returnVarName);
            visitor.visitMethodDeclaration(ctx);
            String newMethodBody = String.format("{ %sImpl(%s); return %s; }", functionName, String.join((CharSequence)", ", declarations), returnVarName);
            String implMethodDeclaration = String.format("void %sImpl%s%s ", functionName, parameters, methodQualifier);
            ReturnValueRewriter.this.rewriter.insertBefore(ctx.methodBody().start, (Object)(newMethodBody + "\n\n" + implMethodDeclaration));
            return null;
        }
    }

    private class InnerVisitor
    extends JavaParserBaseVisitor<Void> {
        private final String returnVarName;

        private InnerVisitor(String returnVarName) {
            this.returnVarName = returnVarName;
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            return null;
        }

        @Override
        public Void visitLambdaBody(JavaParser.LambdaBodyContext ctx) {
            return null;
        }

        @Override
        public Void visitStatement(JavaParser.StatementContext ctx) {
            if (ctx.RETURN() != null) {
                String newReturnStatement = String.format("{ %s = %s; return; }", this.returnVarName, CodeSplitUtil.getContextString(ctx.expression().get(0)));
                ReturnValueRewriter.this.rewriter.replace(ctx.start, ctx.stop, (Object)newReturnStatement);
            }
            return (Void)this.visitChildren(ctx);
        }
    }
}

