/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;

@Internal
final class StarReferenceFlatteningRule
implements ResolverRule {
    StarReferenceFlatteningRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        List strategies = (List)context.configuration().get(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY);
        return expression.stream().flatMap(e -> ((List)e.accept((ExpressionVisitor)new FieldFlatteningVisitor(context, strategies))).stream()).collect(Collectors.toList());
    }

    private static class FieldFlatteningVisitor
    extends RuleExpressionVisitor<List<Expression>> {
        private final List<TableConfigOptions.ColumnExpansionStrategy> strategies;

        FieldFlatteningVisitor(ResolverRule.ResolutionContext resolutionContext, List<TableConfigOptions.ColumnExpansionStrategy> strategies) {
            super(resolutionContext);
            this.strategies = strategies;
        }

        @Override
        public List<Expression> visit(UnresolvedReferenceExpression unresolvedReference) {
            if (unresolvedReference.getName().equals("*")) {
                return new ArrayList<FieldReferenceExpression>(this.resolutionContext.referenceLookup().getInputFields(this.strategies));
            }
            return Collections.singletonList(unresolvedReference);
        }

        @Override
        public List<Expression> visit(UnresolvedCallExpression unresolvedCall) {
            List<Expression> newArgs = unresolvedCall.getChildren().stream().flatMap(e -> ((List)e.accept((ExpressionVisitor)this)).stream()).collect(Collectors.toList());
            return Collections.singletonList(unresolvedCall.replaceArgs(newArgs));
        }

        @Override
        protected List<Expression> defaultMethod(Expression expression) {
            return Collections.singletonList(expression);
        }
    }
}

