/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneId;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TableConfigTest {
    private static final TableConfig CONFIG_BY_METHOD = TableConfig.getDefault();
    private static final TableConfig CONFIG_BY_CONFIGURATION = TableConfig.getDefault();

    @Test
    void testSetAndGetSqlDialect() {
        CONFIG_BY_CONFIGURATION.set("table.sql-dialect", "HIVE");
        CONFIG_BY_METHOD.setSqlDialect(SqlDialect.HIVE);
        Assertions.assertThat((Comparable)CONFIG_BY_METHOD.getSqlDialect()).isEqualTo((Object)SqlDialect.HIVE);
        Assertions.assertThat((Comparable)CONFIG_BY_CONFIGURATION.getSqlDialect()).isEqualTo((Object)SqlDialect.HIVE);
    }

    @Test
    void testSetAndGetMaxGeneratedCodeLength() {
        CONFIG_BY_CONFIGURATION.set("table.generated-code.max-length", "5000");
        CONFIG_BY_METHOD.setMaxGeneratedCodeLength(Integer.valueOf(5000));
        Assertions.assertThat((Integer)CONFIG_BY_METHOD.getMaxGeneratedCodeLength()).isEqualTo((Object)5000);
        Assertions.assertThat((Integer)CONFIG_BY_CONFIGURATION.getMaxGeneratedCodeLength()).isEqualTo((Object)5000);
    }

    @Test
    void testSetAndGetLocalTimeZone() {
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "Asia/Shanghai");
        CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        Assertions.assertThat((Object)CONFIG_BY_METHOD.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("Asia/Shanghai"));
        Assertions.assertThat((Object)CONFIG_BY_CONFIGURATION.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("Asia/Shanghai"));
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "GMT-08:00");
        CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("GMT-08:00"));
        Assertions.assertThat((Object)CONFIG_BY_METHOD.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("GMT-08:00"));
        Assertions.assertThat((Object)CONFIG_BY_CONFIGURATION.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("GMT-08:00"));
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "UTC");
        CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("UTC"));
        Assertions.assertThat((Object)CONFIG_BY_METHOD.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("UTC"));
        Assertions.assertThat((Object)CONFIG_BY_CONFIGURATION.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("UTC"));
    }

    @Test
    public void testSetInvalidLocalTimeZone() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("UTC-10:00"))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid time zone.");
    }

    @Test
    public void testInvalidGmtLocalTimeZone() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("GMT-8:00"))).isInstanceOf(DateTimeException.class)).hasMessage("Invalid ID for offset-based ZoneId: GMT-8:00");
    }

    @Test
    void testGetInvalidLocalTimeZoneUTC() {
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "UTC+8");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableConfig)CONFIG_BY_CONFIGURATION).getLocalTimeZone()).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid time zone.");
    }

    @Test
    void testGetInvalidLocalTimeZoneUT() {
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "UT+8");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableConfig)CONFIG_BY_CONFIGURATION).getLocalTimeZone()).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid time zone.");
    }

    @Test
    void testGetInvalidAbbreviationLocalTimeZone() {
        CONFIG_BY_CONFIGURATION.set("table.local-time-zone", "PST");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableConfig)CONFIG_BY_CONFIGURATION).getLocalTimeZone()).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid time zone.");
    }

    @Test
    void testSetAndGetIdleStateRetention() {
        CONFIG_BY_CONFIGURATION.set("table.exec.state.ttl", "1 h");
        CONFIG_BY_METHOD.setIdleStateRetention(Duration.ofHours(1L));
        Assertions.assertThat((Duration)CONFIG_BY_METHOD.getIdleStateRetention()).isEqualTo((Object)Duration.ofHours(1L));
        Assertions.assertThat((Duration)CONFIG_BY_CONFIGURATION.getIdleStateRetention()).isEqualTo((Object)Duration.ofHours(1L));
    }

    @Test
    void testDisplayMaxColumnLength() {
        CONFIG_BY_CONFIGURATION.set("table.display.max-column-width", "100");
        CONFIG_BY_METHOD.set(TableConfigOptions.DISPLAY_MAX_COLUMN_WIDTH, (Object)100);
        Assertions.assertThat((Integer)((Integer)CONFIG_BY_METHOD.get(TableConfigOptions.DISPLAY_MAX_COLUMN_WIDTH))).isEqualTo((Object)100);
        Assertions.assertThat((Integer)((Integer)CONFIG_BY_CONFIGURATION.get(TableConfigOptions.DISPLAY_MAX_COLUMN_WIDTH))).isEqualTo((Object)100);
    }
}

