/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.strategies.SequenceInputTypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class SubsequenceInputTypeStrategy
implements InputTypeStrategy {
    private final List<ArgumentsSplit> argumentsSplits;
    private final ConstantArgumentCount argumentCount;

    private SubsequenceInputTypeStrategy(List<ArgumentsSplit> argumentsSplits, ConstantArgumentCount argumentCount) {
        this.argumentsSplits = (List)Preconditions.checkNotNull(argumentsSplits);
        this.argumentCount = (ConstantArgumentCount)Preconditions.checkNotNull((Object)argumentCount);
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        ArrayList result = new ArrayList();
        for (ArgumentsSplit argumentsSplit : this.argumentsSplits) {
            Optional<List<DataType>> splitDataTypes = argumentsSplit.inputTypeStrategy.inferInputTypes(new SplitCallContext(argumentsSplit, callContext), throwOnFailure);
            if (splitDataTypes.isPresent()) {
                result.addAll(splitDataTypes.get());
                continue;
            }
            return callContext.fail(throwOnFailure, "Could not infer arguments in range: [%d, %d].", argumentsSplit.startIndex, argumentsSplit.endIndex);
        }
        return Optional.of(result);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return this.argumentsSplits.stream().map(this.computeSubSignatures(definition)).reduce(this::crossJoin).get().stream().map(Signature::of).collect(Collectors.toList());
    }

    private Function<ArgumentsSplit, List<List<Signature.Argument>>> computeSubSignatures(FunctionDefinition definition) {
        return argumentsSplit -> argumentsSplit.inputTypeStrategy.getExpectedSignatures(definition).stream().map(Signature::getArguments).collect(Collectors.toList());
    }

    private List<List<Signature.Argument>> crossJoin(List<List<Signature.Argument>> signatureStarts, List<List<Signature.Argument>> signatureEnds) {
        return signatureStarts.stream().flatMap(x -> signatureEnds.stream().map(y -> {
            ArrayList joined = new ArrayList(x);
            joined.addAll(y);
            return joined;
        })).collect(Collectors.toList());
    }

    private static final class ArgumentsSplit {
        private final int startIndex;
        @Nullable
        private final Integer endIndex;
        private final InputTypeStrategy inputTypeStrategy;

        public ArgumentsSplit(int startIndex, Integer endIndex, InputTypeStrategy inputTypeStrategy) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.inputTypeStrategy = inputTypeStrategy;
        }
    }

    private static final class SplitCallContext
    implements CallContext {
        private final ArgumentsSplit split;
        private final CallContext originalCallContext;

        private SplitCallContext(ArgumentsSplit split, CallContext originalCallContext) {
            this.split = split;
            this.originalCallContext = originalCallContext;
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.originalCallContext.getDataTypeFactory();
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return this.originalCallContext.getFunctionDefinition();
        }

        @Override
        public boolean isArgumentLiteral(int pos) {
            return this.originalCallContext.isArgumentLiteral(pos + this.split.startIndex);
        }

        @Override
        public boolean isArgumentNull(int pos) {
            return this.originalCallContext.isArgumentNull(pos + this.split.startIndex);
        }

        @Override
        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            return this.originalCallContext.getArgumentValue(pos + this.split.startIndex, clazz);
        }

        @Override
        public String getName() {
            return this.originalCallContext.getName();
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            List<DataType> originalArgumentDataTypes = this.originalCallContext.getArgumentDataTypes();
            return originalArgumentDataTypes.subList(this.split.startIndex, this.split.endIndex != null ? this.split.endIndex.intValue() : originalArgumentDataTypes.size());
        }

        @Override
        public Optional<DataType> getOutputDataType() {
            return this.originalCallContext.getOutputDataType();
        }

        @Override
        public boolean isGroupedAggregation() {
            return this.originalCallContext.isGroupedAggregation();
        }
    }

    @Internal
    public static final class SubsequenceStrategyBuilder {
        private final List<ArgumentsSplit> argumentsSplits = new ArrayList<ArgumentsSplit>();
        private int currentPos = 0;

        public SubsequenceStrategyBuilder argument(ArgumentTypeStrategy argumentTypeStrategy) {
            SequenceInputTypeStrategy singleArgumentStrategy = new SequenceInputTypeStrategy(Collections.singletonList(argumentTypeStrategy), null);
            this.argumentsSplits.add(new ArgumentsSplit(this.currentPos, this.currentPos + 1, singleArgumentStrategy));
            ++this.currentPos;
            return this;
        }

        public SubsequenceStrategyBuilder argument(String argumentName, ArgumentTypeStrategy argumentTypeStrategy) {
            SequenceInputTypeStrategy singleArgumentStrategy = new SequenceInputTypeStrategy(Collections.singletonList(argumentTypeStrategy), Collections.singletonList(argumentName));
            this.argumentsSplits.add(new ArgumentsSplit(this.currentPos, this.currentPos + 1, singleArgumentStrategy));
            ++this.currentPos;
            return this;
        }

        public SubsequenceStrategyBuilder subsequence(InputTypeStrategy inputTypeStrategy) {
            Preconditions.checkArgument((boolean)(inputTypeStrategy.getArgumentCount() instanceof ConstantArgumentCount));
            Optional<Integer> maxCount = inputTypeStrategy.getArgumentCount().getMaxCount();
            Optional<Integer> minCount = inputTypeStrategy.getArgumentCount().getMinCount();
            if (!(maxCount.isPresent() && minCount.isPresent() && maxCount.get().equals(minCount.get()))) {
                throw new IllegalArgumentException("Both the minimum and maximum number of expected arguments must be defined and equal to each other.");
            }
            this.argumentsSplits.add(new ArgumentsSplit(this.currentPos, this.currentPos + maxCount.get(), inputTypeStrategy));
            this.currentPos += maxCount.get().intValue();
            return this;
        }

        public InputTypeStrategy finishWithVarying(InputTypeStrategy inputTypeStrategy) {
            ArgumentCount strategyArgumentCount = inputTypeStrategy.getArgumentCount();
            strategyArgumentCount.getMaxCount().ifPresent(c -> {
                throw new IllegalArgumentException("The maximum number of arguments must not be defined.");
            });
            this.argumentsSplits.add(new ArgumentsSplit(this.currentPos, null, inputTypeStrategy));
            int minCount = this.currentPos + strategyArgumentCount.getMinCount().orElse(0);
            return new SubsequenceInputTypeStrategy(this.argumentsSplits, ConstantArgumentCount.from(minCount));
        }

        public InputTypeStrategy finish() {
            return new SubsequenceInputTypeStrategy(this.argumentsSplits, ConstantArgumentCount.of(this.currentPos));
        }
    }
}

