/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.java.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.internal.AbstractStreamTableEnvironmentImpl;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.java.internal.StreamStatementSetImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ExternalQueryOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;

@Internal
public final class StreamTableEnvironmentImpl
extends AbstractStreamTableEnvironmentImpl
implements StreamTableEnvironment {
    public StreamTableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, FunctionCatalog functionCatalog, TableConfig tableConfig, StreamExecutionEnvironment executionEnvironment, Planner planner, Executor executor, boolean isStreamingMode) {
        super(catalogManager, moduleManager, resourceManager, tableConfig, executor, functionCatalog, planner, isStreamingMode, executionEnvironment);
    }

    public static StreamTableEnvironment create(StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings) {
        MutableURLClassLoader userClassLoader = FlinkUserCodeClassLoaders.create((URL[])new URL[0], (ClassLoader)settings.getUserClassLoader(), (ReadableConfig)settings.getConfiguration());
        Executor executor = StreamTableEnvironmentImpl.lookupExecutor((ClassLoader)userClassLoader, (StreamExecutionEnvironment)executionEnvironment);
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        ResourceManager resourceManager = new ResourceManager((ReadableConfig)settings.getConfiguration(), userClassLoader);
        ModuleManager moduleManager = new ModuleManager();
        CatalogStoreFactory catalogStoreFactory = TableFactoryUtil.findAndCreateCatalogStoreFactory((Configuration)settings.getConfiguration(), (ClassLoader)userClassLoader);
        CatalogStoreFactory.Context catalogStoreFactoryContext = TableFactoryUtil.buildCatalogStoreFactoryContext((Configuration)settings.getConfiguration(), (ClassLoader)userClassLoader);
        catalogStoreFactory.open(catalogStoreFactoryContext);
        CatalogStore catalogStore = settings.getCatalogStore() != null ? settings.getCatalogStore() : catalogStoreFactory.createCatalogStore();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)userClassLoader).config((ReadableConfig)tableConfig).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).executionConfig(executionEnvironment.getConfig()).catalogModificationListeners(TableFactoryUtil.findCatalogModificationListenerList((ReadableConfig)settings.getConfiguration(), (ClassLoader)userClassLoader)).catalogStoreHolder(CatalogStoreHolder.newBuilder().classloader((ClassLoader)userClassLoader).config((ReadableConfig)tableConfig).catalogStore(catalogStore).factory(catalogStoreFactory).build()).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, resourceManager, catalogManager, moduleManager);
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)tableConfig, (ClassLoader)userClassLoader, (ModuleManager)moduleManager, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, resourceManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode());
    }

    @Override
    public <T> Table fromDataStream(DataStream<T> dataStream) {
        return this.fromStreamInternal(dataStream, null, null, ChangelogMode.insertOnly());
    }

    @Override
    public <T> Table fromDataStream(DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream, schema, null, ChangelogMode.insertOnly());
    }

    @Override
    public Table fromChangelogStream(DataStream<Row> dataStream) {
        return this.fromStreamInternal(dataStream, null, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(DataStream<Row> dataStream, Schema schema) {
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream, schema, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(DataStream<Row> dataStream, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream, schema, null, changelogMode);
    }

    @Override
    public <T> void createTemporaryView(String path, DataStream<T> dataStream) {
        this.createTemporaryView(path, this.fromStreamInternal(dataStream, null, path, ChangelogMode.insertOnly()));
    }

    @Override
    public <T> void createTemporaryView(String path, DataStream<T> dataStream, Schema schema) {
        this.createTemporaryView(path, this.fromStreamInternal(dataStream, schema, path, ChangelogMode.insertOnly()));
    }

    @Override
    public DataStream<Row> toDataStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        DataType sourceType = table.getResolvedSchema().toSourceRowDataType();
        if (!(table.getQueryOperation() instanceof ExternalQueryOperation)) {
            return this.toDataStream(table, (AbstractDataType<?>)sourceType);
        }
        DataTypeFactory dataTypeFactory = this.getCatalogManager().getDataTypeFactory();
        SchemaResolver schemaResolver = this.getCatalogManager().getSchemaResolver();
        ExternalQueryOperation queryOperation = (ExternalQueryOperation)table.getQueryOperation();
        DataStream dataStream = queryOperation.getDataStream();
        SchemaTranslator.ConsumingResult consumingResult = SchemaTranslator.createConsumingResult((DataTypeFactory)dataTypeFactory, (TypeInformation)dataStream.getType(), null);
        ResolvedSchema defaultSchema = consumingResult.getSchema().resolve(schemaResolver);
        if (queryOperation.getChangelogMode().equals((Object)ChangelogMode.insertOnly()) && table.getResolvedSchema().equals((Object)defaultSchema) && dataStream.getType() instanceof RowTypeInfo) {
            return dataStream;
        }
        return this.toDataStream(table, (AbstractDataType<?>)sourceType);
    }

    @Override
    public <T> DataStream<T> toDataStream(Table table, Class<T> targetClass) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetClass, (String)"Target class must not be null.");
        if (targetClass == Row.class) {
            return this.toDataStream(table);
        }
        return this.toDataStream(table, (AbstractDataType<?>)DataTypes.of(targetClass));
    }

    @Override
    public <T> DataStream<T> toDataStream(Table table, AbstractDataType<?> targetDataType) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetDataType, (String)"Target data type must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult((DataTypeFactory)this.getCatalogManager().getDataTypeFactory(), (ResolvedSchema)table.getResolvedSchema(), targetDataType);
        return this.toStreamInternal(table, schemaTranslationResult, ChangelogMode.insertOnly());
    }

    @Override
    public DataStream<Row> toChangelogStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult((ResolvedSchema)table.getResolvedSchema(), null);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public DataStream<Row> toChangelogStream(Table table, Schema targetSchema) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult((ResolvedSchema)table.getResolvedSchema(), (Schema)targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public DataStream<Row> toChangelogStream(Table table, Schema targetSchema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult((ResolvedSchema)table.getResolvedSchema(), (Schema)targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, changelogMode);
    }

    @Override
    public StreamStatementSet createStatementSet() {
        return new StreamStatementSetImpl(this);
    }

    @Override
    public <T> Table fromDataStream(DataStream<T> dataStream, Expression ... fields) {
        return this.createTable((QueryOperation)this.asQueryOperation(dataStream, Optional.of(Arrays.asList(fields))));
    }

    @Override
    public <T> void createTemporaryView(String path, DataStream<T> dataStream, Expression ... fields) {
        this.createTemporaryView(path, this.fromDataStream(dataStream, fields));
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, Class<T> clazz) {
        TypeInformation typeInfo = this.extractTypeInformation(table, clazz);
        return this.toAppendStream(table, typeInfo);
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, TypeInformation<T> typeInfo) {
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(typeInfo), OutputConversionModifyOperation.UpdateMode.APPEND);
        return this.toStreamInternal(table, (ModifyOperation)modifyOperation);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, Class<T> clazz) {
        TypeInformation typeInfo = this.extractTypeInformation(table, clazz);
        return this.toRetractStream(table, typeInfo);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, TypeInformation<T> typeInfo) {
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), this.wrapWithChangeFlag(typeInfo), OutputConversionModifyOperation.UpdateMode.RETRACT);
        return this.toStreamInternal(table, (ModifyOperation)modifyOperation);
    }
}

