/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.graph;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.checkpoint.WithMasterCheckpointHook;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WithMasterCheckpointHookConfigTest {
    WithMasterCheckpointHookConfigTest() {
    }

    @Test
    void testHookConfiguration() throws Exception {
        TestSource source1 = new TestSource();
        TestSourceWithHook source2 = new TestSourceWithHook("foo");
        TestSource source3 = new TestSource();
        TestSourceWithHook source4 = new TestSourceWithHook("bar");
        Identity identity = new Identity();
        IdentityWithHook identityWithHook1 = new IdentityWithHook("apple");
        IdentityWithHook identityWithHook2 = new IdentityWithHook("orange");
        HashSet<TestHook> hooks = new HashSet<TestHook>(Arrays.asList(source2.createMasterTriggerRestoreHook(), source4.createMasterTriggerRestoreHook(), identityWithHook1.createMasterTriggerRestoreHook(), identityWithHook2.createMasterTriggerRestoreHook()));
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment();
        env.enableCheckpointing(500L);
        env.addSource((SourceFunction)source1).map(identity).union(new DataStream[]{env.addSource((SourceFunction)source2).map(identity)}).union(new DataStream[]{env.addSource((SourceFunction)source3).map(identityWithHook1)}).union(new DataStream[]{env.addSource((SourceFunction)source4).map(identityWithHook2)}).sinkTo((Sink)new DiscardingSink());
        JobGraph jg = env.getStreamGraph().getJobGraph();
        SerializedValue serializedConfiguredHooks = jg.getCheckpointingSettings().getMasterHooks();
        Assertions.assertThat((Object)serializedConfiguredHooks).isNotNull();
        Object[] configuredHooks = (MasterTriggerRestoreHook.Factory[])serializedConfiguredHooks.deserializeValue(this.getClass().getClassLoader());
        Assertions.assertThat((Object[])configuredHooks).hasSameSizeAs(hooks);
        for (Object f : configuredHooks) {
            MasterTriggerRestoreHook hook = f.create();
            Assertions.assertThat((boolean)hooks.remove(hook)).isTrue();
        }
        Assertions.assertThat(hooks).isEmpty();
    }

    private static class TestSource
    implements SourceFunction<String> {
        private TestSource() {
        }

        public void run(SourceFunction.SourceContext<String> ctx) {
            throw new UnsupportedOperationException();
        }

        public void cancel() {
        }
    }

    private static class TestSourceWithHook
    extends TestSource
    implements WithMasterCheckpointHook<String> {
        private final String id;

        TestSourceWithHook(String id) {
            this.id = id;
        }

        public TestHook createMasterTriggerRestoreHook() {
            return new TestHook(this.id);
        }
    }

    private static class Identity<T>
    implements MapFunction<T, T> {
        private Identity() {
        }

        public T map(T value) {
            return value;
        }
    }

    private static class IdentityWithHook<T>
    extends Identity<T>
    implements WithMasterCheckpointHook<String> {
        private final String id;

        IdentityWithHook(String id) {
            this.id = id;
        }

        public TestHook createMasterTriggerRestoreHook() {
            return new TestHook(this.id);
        }
    }

    private static class TestHook
    implements MasterTriggerRestoreHook<String> {
        private final String id;

        TestHook(String id) {
            this.id = id;
        }

        public String getIdentifier() {
            return this.id;
        }

        public void reset() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void close() throws Exception {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<String> triggerCheckpoint(long checkpointId, long timestamp, Executor executor) {
            throw new UnsupportedOperationException();
        }

        public void restoreCheckpoint(long checkpointId, @Nullable String checkpointData) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public SimpleVersionedSerializer<String> createCheckpointDataSerializer() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == this.getClass() && ((TestHook)obj).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

