/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing.delta.extractor;

import org.apache.flink.streaming.api.functions.windowing.delta.extractor.FieldsFromArray;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FieldsFromArrayTest {
    String[] testStringArray = new String[]{"0", "1", "2", "3", "4"};
    Integer[] testIntegerArray = new Integer[]{10, 11, 12, 13, 14};
    int[] testIntArray = new int[]{20, 21, 22, 23, 24};

    FieldsFromArrayTest() {
    }

    @Test
    void testStringArray() {
        int i = 0;
        while (i < this.testStringArray.length) {
            Object[] tmp = new String[]{this.testStringArray[i]};
            this.arrayEqualityCheck(tmp, new FieldsFromArray(String.class, new int[]{i++}).extract((Object)this.testStringArray));
        }
        Object[] reverseOrder = new String[this.testStringArray.length];
        for (int i2 = 0; i2 < this.testStringArray.length; ++i2) {
            reverseOrder[i2] = this.testStringArray[this.testStringArray.length - i2 - 1];
        }
        this.arrayEqualityCheck(reverseOrder, new FieldsFromArray(String.class, new int[]{4, 3, 2, 1, 0}).extract((Object)this.testStringArray));
        Object[] crazyOrder = new String[]{this.testStringArray[4], this.testStringArray[1], this.testStringArray[2]};
        this.arrayEqualityCheck(crazyOrder, new FieldsFromArray(String.class, new int[]{4, 1, 2}).extract((Object)this.testStringArray));
    }

    @Test
    void testIntegerArray() {
        int i = 0;
        while (i < this.testIntegerArray.length) {
            Object[] tmp = new Integer[]{this.testIntegerArray[i]};
            this.arrayEqualityCheck(tmp, new FieldsFromArray(Integer.class, new int[]{i++}).extract((Object)this.testIntegerArray));
        }
        Object[] reverseOrder = new Integer[this.testIntegerArray.length];
        for (int i2 = 0; i2 < this.testIntegerArray.length; ++i2) {
            reverseOrder[i2] = this.testIntegerArray[this.testIntegerArray.length - i2 - 1];
        }
        this.arrayEqualityCheck(reverseOrder, new FieldsFromArray(Integer.class, new int[]{4, 3, 2, 1, 0}).extract((Object)this.testIntegerArray));
        Object[] crazyOrder = new Integer[]{this.testIntegerArray[4], this.testIntegerArray[1], this.testIntegerArray[2]};
        this.arrayEqualityCheck(crazyOrder, new FieldsFromArray(Integer.class, new int[]{4, 1, 2}).extract((Object)this.testIntegerArray));
    }

    @Test
    void testIntArray() {
        int i = 0;
        while (i < this.testIntArray.length) {
            Object[] tmp = new Integer[]{this.testIntArray[i]};
            this.arrayEqualityCheck(tmp, new FieldsFromArray(Integer.class, new int[]{i++}).extract((Object)this.testIntArray));
        }
        Object[] reverseOrder = new Integer[this.testIntArray.length];
        for (int i2 = 0; i2 < this.testIntArray.length; ++i2) {
            reverseOrder[i2] = this.testIntArray[this.testIntArray.length - i2 - 1];
        }
        this.arrayEqualityCheck(reverseOrder, new FieldsFromArray(Integer.class, new int[]{4, 3, 2, 1, 0}).extract((Object)this.testIntArray));
        Object[] crazyOrder = new Integer[]{this.testIntArray[4], this.testIntArray[1], this.testIntArray[2]};
        this.arrayEqualityCheck(crazyOrder, new FieldsFromArray(Integer.class, new int[]{4, 1, 2}).extract((Object)this.testIntArray));
    }

    private void arrayEqualityCheck(Object[] array1, Object[] array2) {
        Assertions.assertThat((Object[])array1).isEqualTo((Object)array2);
    }
}

