/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketFactory;
import org.apache.flink.streaming.api.functions.sink.filesystem.DefaultBucketFactoryImpl;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.legacy.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.assertj.core.api.Assertions;

public class TestUtils {
    static final int MAX_PARALLELISM = 10;

    static OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createRescalingTestSink(File outDir, int totalParallelism, int taskIdx, long inactivityInterval, long partMaxSize) throws Exception {
        DefaultRollingPolicy rollingPolicy = DefaultRollingPolicy.builder().withMaxPartSize(new MemorySize(partMaxSize)).withRolloverInterval(Duration.ofMillis(inactivityInterval)).withInactivityInterval(Duration.ofMillis(inactivityInterval)).build();
        return TestUtils.createRescalingTestSink(outDir, totalParallelism, taskIdx, 10L, new TupleToStringBucketer(), new Tuple2Encoder(), (RollingPolicy<Tuple2<String, Integer>, String>)rollingPolicy, (BucketFactory<Tuple2<String, Integer>, String>)new DefaultBucketFactoryImpl());
    }

    static OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createRescalingTestSink(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, String> bucketer, Encoder<Tuple2<String, Integer>> writer, RollingPolicy<Tuple2<String, Integer>, String> rollingPolicy, BucketFactory<Tuple2<String, Integer>, String> bucketFactory) throws Exception {
        StreamingFileSink sink = ((StreamingFileSink.DefaultRowFormatBuilder)((StreamingFileSink.DefaultRowFormatBuilder)((StreamingFileSink.DefaultRowFormatBuilder)((StreamingFileSink.DefaultRowFormatBuilder)StreamingFileSink.forRowFormat((Path)new Path(outDir.toURI()), writer).withBucketAssigner(bucketer)).withRollingPolicy(rollingPolicy)).withBucketCheckInterval(bucketCheckInterval)).withBucketFactory(bucketFactory)).build();
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 10, totalParallelism, taskIdx);
    }

    static <ID> OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createCustomizedRescalingTestSink(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, ID> bucketer, Encoder<Tuple2<String, Integer>> writer, RollingPolicy<Tuple2<String, Integer>, ID> rollingPolicy, BucketFactory<Tuple2<String, Integer>, ID> bucketFactory) throws Exception {
        StreamingFileSink sink = StreamingFileSink.forRowFormat((Path)new Path(outDir.toURI()), writer).withNewBucketAssignerAndPolicy(bucketer, rollingPolicy).withBucketCheckInterval(bucketCheckInterval).withBucketFactory(bucketFactory).build();
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 10, totalParallelism, taskIdx);
    }

    static OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createTestSinkWithBulkEncoder(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, String> bucketer, BulkWriter.Factory<Tuple2<String, Integer>> writer, BucketFactory<Tuple2<String, Integer>, String> bucketFactory) throws Exception {
        return TestUtils.createTestSinkWithBulkEncoder(outDir, totalParallelism, taskIdx, bucketCheckInterval, bucketer, writer, bucketFactory, OutputFileConfig.builder().build());
    }

    static OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createTestSinkWithBulkEncoder(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, String> bucketer, BulkWriter.Factory<Tuple2<String, Integer>> writer, BucketFactory<Tuple2<String, Integer>, String> bucketFactory, OutputFileConfig outputFileConfig) throws Exception {
        StreamingFileSink sink = ((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)StreamingFileSink.forBulkFormat((Path)new Path(outDir.toURI()), writer).withBucketAssigner(bucketer)).withBucketCheckInterval(bucketCheckInterval)).withRollingPolicy((CheckpointRollingPolicy)OnCheckpointRollingPolicy.build())).withBucketFactory(bucketFactory)).withOutputFileConfig(outputFileConfig)).build();
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 10, totalParallelism, taskIdx);
    }

    static <ID> OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createTestSinkWithCustomizedBulkEncoder(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, ID> bucketer, BulkWriter.Factory<Tuple2<String, Integer>> writer, BucketFactory<Tuple2<String, Integer>, ID> bucketFactory) throws Exception {
        return TestUtils.createTestSinkWithCustomizedBulkEncoder(outDir, totalParallelism, taskIdx, bucketCheckInterval, bucketer, writer, bucketFactory, OutputFileConfig.builder().build());
    }

    static <ID> OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> createTestSinkWithCustomizedBulkEncoder(File outDir, int totalParallelism, int taskIdx, long bucketCheckInterval, BucketAssigner<Tuple2<String, Integer>, ID> bucketer, BulkWriter.Factory<Tuple2<String, Integer>> writer, BucketFactory<Tuple2<String, Integer>, ID> bucketFactory, OutputFileConfig outputFileConfig) throws Exception {
        StreamingFileSink sink = StreamingFileSink.forBulkFormat((Path)new Path(outDir.toURI()), writer).withNewBucketAssigner(bucketer).withRollingPolicy((CheckpointRollingPolicy)OnCheckpointRollingPolicy.build()).withBucketCheckInterval(bucketCheckInterval).withBucketFactory(bucketFactory).withOutputFileConfig(outputFileConfig).build();
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 10, totalParallelism, taskIdx);
    }

    static void checkLocalFs(File outDir, int expectedInProgress, int expectedCompleted) {
        int inProgress = 0;
        int finished = 0;
        for (File file : FileUtils.listFiles((File)outDir, null, (boolean)true)) {
            if (file.getAbsolutePath().endsWith("crc")) continue;
            if (file.toPath().getFileName().toString().startsWith(".")) {
                ++inProgress;
                continue;
            }
            ++finished;
        }
        Assertions.assertThat((int)inProgress).isEqualTo(expectedInProgress);
        Assertions.assertThat((int)finished).isEqualTo(expectedCompleted);
    }

    static Map<File, String> getFileContentByPath(File directory) throws IOException {
        HashMap<File, String> contents = new HashMap<File, String>(4);
        Collection filesInBucket = FileUtils.listFiles((File)directory, null, (boolean)true);
        for (File file : filesInBucket) {
            contents.put(file, FileUtils.readFileToString((File)file));
        }
        return contents;
    }

    static class TupleToStringBucketer
    implements BucketAssigner<Tuple2<String, Integer>, String> {
        private static final long serialVersionUID = 1L;

        TupleToStringBucketer() {
        }

        public String getBucketId(Tuple2<String, Integer> element, BucketAssigner.Context context) {
            return (String)element.f0;
        }

        public SimpleVersionedSerializer<String> getSerializer() {
            return SimpleVersionedStringSerializer.INSTANCE;
        }
    }

    static class Tuple2Encoder
    implements Encoder<Tuple2<String, Integer>> {
        Tuple2Encoder() {
        }

        public void encode(Tuple2<String, Integer> element, OutputStream stream) throws IOException {
            stream.write(((String)element.f0 + "@" + element.f1).getBytes(StandardCharsets.UTF_8));
            stream.write(10);
        }
    }

    public static class MockListState<T>
    implements ListState<T> {
        private final List<T> backingList = new ArrayList<T>();

        public List<T> getBackingList() {
            return this.backingList;
        }

        public void update(List<T> values) {
            this.backingList.clear();
            this.addAll(values);
        }

        public void addAll(List<T> values) {
            this.backingList.addAll(values);
        }

        public Iterable<T> get() {
            return new Iterable<T>(){

                @Override
                @Nonnull
                public Iterator<T> iterator() {
                    return backingList.iterator();
                }
            };
        }

        public void add(T value) {
            this.backingList.add(value);
        }

        public void clear() {
            this.backingList.clear();
        }
    }

    static class MockSinkContext
    implements SinkFunction.Context {
        @Nullable
        private Long elementTimestamp;
        private long watermark;
        private long processingTime;

        MockSinkContext(@Nullable Long elementTimestamp, long watermark, long processingTime) {
            this.elementTimestamp = elementTimestamp;
            this.watermark = watermark;
            this.processingTime = processingTime;
        }

        public long currentProcessingTime() {
            return this.processingTime;
        }

        public long currentWatermark() {
            return this.watermark;
        }

        @Nullable
        public Long timestamp() {
            return this.elementTimestamp;
        }
    }

    static class StringIdentityBucketAssigner
    implements BucketAssigner<String, String> {
        private static final long serialVersionUID = 1L;

        StringIdentityBucketAssigner() {
        }

        public String getBucketId(String element, BucketAssigner.Context context) {
            return element;
        }

        public SimpleVersionedSerializer<String> getSerializer() {
            return SimpleVersionedStringSerializer.INSTANCE;
        }
    }

    private static final class SimpleVersionedIntegerSerializer
    implements SimpleVersionedSerializer<Integer> {
        static final int VERSION = 1;

        private SimpleVersionedIntegerSerializer() {
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(Integer value) {
            byte[] bytes = new byte[4];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).putInt(value);
            return bytes;
        }

        public Integer deserialize(int version, byte[] serialized) {
            Assertions.assertThat((int)version).isOne();
            Assertions.assertThat((int)serialized.length).isEqualTo(4);
            return ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
    }

    static class TupleToIntegerBucketer
    implements BucketAssigner<Tuple2<String, Integer>, Integer> {
        private static final long serialVersionUID = 1L;

        TupleToIntegerBucketer() {
        }

        public Integer getBucketId(Tuple2<String, Integer> element, BucketAssigner.Context context) {
            return (Integer)element.f1;
        }

        public SimpleVersionedSerializer<Integer> getSerializer() {
            return new SimpleVersionedIntegerSerializer();
        }
    }
}

