/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

public class ByteBufferWritableFSDataOutputStream
extends FSDataOutputStream {
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int SEGMENT_BUFFER_SIZE = 16384;
    private final FSDataOutputStream originalOutputStream;

    public ByteBufferWritableFSDataOutputStream(FSDataOutputStream originalOutputStream) {
        this.originalOutputStream = originalOutputStream;
    }

    public void write(ByteBuffer bb) throws IOException {
        if (bb == null) {
            throw new NullPointerException();
        }
        if (bb.remaining() == 0) {
            return;
        }
        if (bb.hasArray()) {
            this.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else if (bb.isDirect()) {
            int copy;
            int len = bb.remaining();
            int segment = Math.min(len, 16384);
            byte[] bytes = new byte[segment];
            for (int i = 0; i < len; i += copy) {
                copy = Math.min(segment, bb.remaining());
                UNSAFE.copyMemory(null, MemoryUtils.getByteBufferAddress((ByteBuffer)bb) + (long)bb.position(), bytes, BYTE_ARRAY_BASE_OFFSET, copy);
                this.originalOutputStream.write(bytes, 0, copy);
                bb.position(bb.position() + copy);
            }
        } else {
            int len = bb.remaining();
            for (int i = 0; i < len; ++i) {
                this.originalOutputStream.write((int)bb.get());
            }
        }
    }

    public long getPos() throws IOException {
        return this.originalOutputStream.getPos();
    }

    public void write(int b) throws IOException {
        this.originalOutputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.originalOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.originalOutputStream.write(b, off, len);
    }

    public void flush() throws IOException {
        this.originalOutputStream.flush();
    }

    public void sync() throws IOException {
        this.originalOutputStream.sync();
    }

    public void close() throws IOException {
        this.originalOutputStream.close();
    }
}

