/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStMapIterator;
import org.apache.flink.state.forst.ForStMapState;
import org.forstdb.RocksIterator;

public class ForStDBMapEntryIterRequest<K, N, UK, UV>
extends ForStDBIterRequest<K, N, UK, UV, Map.Entry<UK, UV>> {
    private final InternalStateFuture<StateIterator<Map.Entry<UK, UV>>> future;

    public ForStDBMapEntryIterRequest(ContextKey<K, N> contextKey, ForStMapState<K, N, UK, UV> table, StateRequestHandler stateRequestHandler, @Nullable RocksIterator rocksIterator, InternalStateFuture<StateIterator<Map.Entry<UK, UV>>> future) {
        super(contextKey, table, stateRequestHandler, rocksIterator);
        this.future = future;
    }

    @Override
    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }

    @Override
    public Collection<Map.Entry<UK, UV>> deserializeElement(List<ForStDBIterRequest.RawEntry> entries, int userKeyOffset) throws IOException {
        ArrayList<Map.Entry<UK, UV>> deserializedEntries = new ArrayList<Map.Entry<UK, UV>>(entries.size());
        for (ForStDBIterRequest.RawEntry en : entries) {
            Object userValue = this.deserializeUserValue(en.rawValueBytes);
            if (userValue == null) continue;
            Object userKey = this.deserializeUserKey(en.rawKeyBytes, userKeyOffset);
            deserializedEntries.add(new MapEntry(userKey, userValue));
        }
        return deserializedEntries;
    }

    @Override
    public void buildIteratorAndCompleteFuture(Collection<Map.Entry<UK, UV>> partialResult, boolean encounterEnd) {
        ForStMapIterator<Map.Entry<UK, UV>> stateIterator = new ForStMapIterator<Map.Entry<UK, UV>>((State)this.table, StateRequestType.MAP_ITER, StateRequestType.ITERATOR_LOADING, this.stateRequestHandler, partialResult, encounterEnd, this.rocksIterator);
        this.future.complete(stateIterator);
    }

    static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }
    }
}

