/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.utils;

import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.streaming.api.functions.source.legacy.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;

public class WaitingSource<T>
extends RichSourceFunction<T>
implements ResultTypeQueryable<T> {
    private final SourceFunction<T> source;
    private final TypeInformation<T> returnType;
    private volatile boolean running;

    public WaitingSource(SourceFunction<T> source, TypeInformation<T> returnType) {
        this.source = source;
        this.returnType = returnType;
        this.running = true;
    }

    public void setRuntimeContext(RuntimeContext t) {
        if (this.source instanceof RichSourceFunction) {
            ((RichSourceFunction)this.source).setRuntimeContext(t);
        }
    }

    public void open(OpenContext openContext) throws Exception {
        if (this.source instanceof RichSourceFunction) {
            ((RichSourceFunction)this.source).open(DefaultOpenContext.INSTANCE);
        }
    }

    public void close() throws Exception {
        if (this.source instanceof RichSourceFunction) {
            ((RichSourceFunction)this.source).close();
        }
    }

    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        this.source.run(ctx);
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void cancel() {
        this.source.cancel();
        this.running = false;
    }

    public TypeInformation<T> getProducedType() {
        return this.returnType;
    }
}

