/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlPartitionUtils;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;

public abstract class SqlAlterTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER TABLE", SqlKind.ALTER_TABLE);
    protected final SqlIdentifier tableIdentifier;
    protected final SqlNodeList partitionSpec;
    protected final boolean ifTableExists;

    public SqlAlterTable(SqlParserPos pos, SqlIdentifier tableName, @Nullable SqlNodeList partitionSpec, boolean ifTableExists) {
        super(pos);
        this.tableIdentifier = Objects.requireNonNull(tableName, "tableName should not be null");
        this.partitionSpec = partitionSpec;
        this.ifTableExists = ifTableExists;
    }

    public SqlAlterTable(SqlParserPos pos, SqlIdentifier tableName, boolean ifTableExists) {
        this(pos, tableName, null, ifTableExists);
    }

    public SqlAlterTable(SqlParserPos pos, SqlIdentifier tableName, @Nullable SqlNodeList partitionSpec) {
        this(pos, tableName, partitionSpec, false);
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public SqlIdentifier getTableName() {
        return this.tableIdentifier;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER TABLE");
        if (this.ifTableExists) {
            writer.keyword("IF EXISTS");
        }
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
        SqlNodeList partitionSpec = this.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.size() > 0) {
            writer.keyword("PARTITION");
            partitionSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
        }
    }

    public String[] fullTableName() {
        return (String[])this.tableIdentifier.names.toArray((Object[])new String[0]);
    }

    public SqlNodeList getPartitionSpec() {
        return this.partitionSpec;
    }

    public LinkedHashMap<String, String> getPartitionKVs() {
        return SqlPartitionUtils.getPartitionKVs(this.getPartitionSpec());
    }

    public boolean ifTableExists() {
        return this.ifTableExists;
    }

    public static class AlterTableContext
    extends SqlCreateTable.TableCreationContext {
        public List<SqlNode> columnPositions = new ArrayList<SqlNode>();
    }
}

