/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.operation.OperationStatus;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.RestAPIITCaseBase;
import org.apache.flink.table.gateway.rest.header.operation.CancelOperationHeaders;
import org.apache.flink.table.gateway.rest.header.operation.CloseOperationHeaders;
import org.apache.flink.table.gateway.rest.header.operation.GetOperationStatusHeaders;
import org.apache.flink.table.gateway.rest.header.session.OpenSessionHeaders;
import org.apache.flink.table.gateway.rest.message.operation.OperationMessageParameters;
import org.apache.flink.table.gateway.rest.message.operation.OperationStatusResponseBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionResponseBody;
import org.apache.flink.table.gateway.service.result.NotReadyResult;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperationRelatedITCase
extends RestAPIITCaseBase {
    private static final String sessionName = "test";
    private static final Map<String, String> properties = new HashMap<String, String>();
    private static final OpenSessionHeaders openSessionHeaders;
    private static final OpenSessionRequestBody openSessionRequestBody;
    private static final EmptyMessageParameters emptyParameters;
    private static final EmptyRequestBody emptyRequestBody;
    private static final GetOperationStatusHeaders getOperationStatusHeaders;
    private static final CancelOperationHeaders cancelOperationHeaders;
    private static final CloseOperationHeaders closeOperationHeaders;

    OperationRelatedITCase() {
    }

    @Test
    void testWhenSubmitOperation() throws Exception {
        this.submitOperation();
    }

    @Test
    void testOperationRelatedApis() throws Exception {
        List<String> ids = this.submitOperation();
        String status = this.getOperationStatus(ids);
        Assertions.assertThat((Comparable)OperationStatus.RUNNING).hasToString(status);
        ids = this.submitOperation();
        status = this.cancelOperation(ids);
        Assertions.assertThat((Comparable)OperationStatus.CANCELED).hasToString(status);
        status = this.getOperationStatus(ids);
        Assertions.assertThat((Comparable)OperationStatus.CANCELED).hasToString(status);
        ids = this.submitOperation();
        status = this.closeOperation(ids);
        Assertions.assertThat((Comparable)OperationStatus.CLOSED).hasToString(status);
        SessionHandle sessionHandle = new SessionHandle(UUID.fromString(ids.get(0)));
        OperationHandle operationHandle = new OperationHandle(UUID.fromString(ids.get(1)));
        Assertions.assertThatThrownBy(() -> SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(sessionHandle).getOperationManager().getOperation(operationHandle)).isInstanceOf(SqlGatewayException.class);
    }

    List<String> submitOperation() throws Exception {
        CompletableFuture response = this.sendRequest(openSessionHeaders, emptyParameters, openSessionRequestBody);
        String sessionHandleId = ((OpenSessionResponseBody)response.get()).getSessionHandle();
        Assertions.assertThat((String)sessionHandleId).isNotNull();
        SessionHandle sessionHandle = new SessionHandle(UUID.fromString(sessionHandleId));
        Assertions.assertThat((Object)SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(sessionHandle)).isNotNull();
        OneShotLatch startLatch = new OneShotLatch();
        Thread main = Thread.currentThread();
        OperationHandle operationHandle = SQL_GATEWAY_SERVICE_EXTENSION.getService().submitOperation(sessionHandle, () -> {
            try {
                startLatch.trigger();
                main.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return NotReadyResult.INSTANCE;
        });
        startLatch.await();
        Assertions.assertThat((Object)operationHandle).isNotNull();
        return Arrays.asList(sessionHandleId, operationHandle.getIdentifier().toString());
    }

    String getOperationStatus(List<String> ids) throws Exception {
        String sessionId = ids.get(0);
        String operationId = ids.get(1);
        OperationMessageParameters operationMessageParameters = new OperationMessageParameters(new SessionHandle(UUID.fromString(sessionId)), new OperationHandle(UUID.fromString(operationId)));
        CompletableFuture future = this.sendRequest(getOperationStatusHeaders, operationMessageParameters, emptyRequestBody);
        return ((OperationStatusResponseBody)future.get()).getStatus();
    }

    String cancelOperation(List<String> ids) throws Exception {
        CompletableFuture future = this.sendRequest(cancelOperationHeaders, this.getMessageParameters(ids), emptyRequestBody);
        return ((OperationStatusResponseBody)future.get()).getStatus();
    }

    String closeOperation(List<String> ids) throws Exception {
        CompletableFuture future = this.sendRequest(closeOperationHeaders, this.getMessageParameters(ids), emptyRequestBody);
        return ((OperationStatusResponseBody)future.get()).getStatus();
    }

    OperationMessageParameters getMessageParameters(List<String> ids) {
        String sessionId = ids.get(0);
        String operationId = ids.get(1);
        return new OperationMessageParameters(new SessionHandle(UUID.fromString(sessionId)), new OperationHandle(UUID.fromString(operationId)));
    }

    static {
        properties.put("k1", "v1");
        properties.put("k2", "v2");
        openSessionHeaders = OpenSessionHeaders.getInstance();
        openSessionRequestBody = new OpenSessionRequestBody(sessionName, properties);
        emptyParameters = EmptyMessageParameters.getInstance();
        emptyRequestBody = EmptyRequestBody.getInstance();
        getOperationStatusHeaders = GetOperationStatusHeaders.getInstance();
        cancelOperationHeaders = CancelOperationHeaders.getInstance();
        closeOperationHeaders = CloseOperationHeaders.getInstance();
    }
}

