/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.endpoint;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactory;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.api.utils.FakeSqlGatewayEndpoint;
import org.apache.flink.table.gateway.api.utils.MockedSqlGatewayEndpoint;
import org.apache.flink.table.gateway.api.utils.MockedSqlGatewayService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class SqlGatewayEndpointFactoryUtilsTest {
    @Test
    public void testCreateEndpoints() {
        String id = UUID.randomUUID().toString();
        Map<String, String> config = this.getDefaultConfig(id);
        config.put("sql-gateway.endpoint.type", "mocked;fake");
        List actual = SqlGatewayEndpointFactoryUtils.createSqlGatewayEndpoint((SqlGatewayService)new MockedSqlGatewayService(), (Configuration)Configuration.fromMap(config));
        MockedSqlGatewayEndpoint expectedMocked = new MockedSqlGatewayEndpoint(id, "localhost", 9999, "Hello World.");
        AssertionsForClassTypes.assertThat((Object)actual).isEqualTo(Arrays.asList(expectedMocked, FakeSqlGatewayEndpoint.INSTANCE));
    }

    @Test
    public void testCreateEndpointWithDuplicateIdentifier() {
        Map<String, String> config = this.getDefaultConfig();
        config.put("sql-gateway.endpoint.type", "mocked;mocked");
        this.validateException(config, "Get the duplicate endpoint identifier 'mocked' for the option 'sql-gateway.endpoint.type'. Please keep the specified endpoint identifier unique.");
    }

    @Test
    public void testCreateEndpointWithoutType() {
        Map<String, String> config = this.getDefaultConfig();
        config.remove("sql-gateway.endpoint.type");
        this.validateException(config, "Could not find any factory for identifier 'rest' that implements 'org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactory' in the classpath.");
    }

    @Test
    public void testCreateUnknownEndpoint() {
        Map<String, String> config = this.getDefaultConfig();
        config.put("sql-gateway.endpoint.type", "mocked;unknown");
        this.validateException(config, String.format("Could not find any factory for identifier 'unknown' that implements '%s' in the classpath.", SqlGatewayEndpointFactory.class.getCanonicalName()));
    }

    @Test
    public void testCreateEndpointWithMissingOptions() {
        Map<String, String> config = this.getDefaultConfig();
        config.remove("sql-gateway.endpoint.mocked.host");
        this.validateException(config, "One or more required options are missing.\n\nMissing required options are:\n\nhost");
    }

    @Test
    public void testCreateEndpointWithUnconsumedOptions() {
        Map<String, String> config = this.getDefaultConfig();
        config.put("sql-gateway.endpoint.mocked.unconsumed-option", "error");
        this.validateException(config, "Unsupported options found for 'mocked'.\n\nUnsupported options:\n\nunconsumed-option\n\nSupported options:\n\ndescription\nhost\nid\nport");
    }

    private void validateException(Map<String, String> config, String errorMessage) {
        Assertions.assertThatThrownBy(() -> SqlGatewayEndpointFactoryUtils.createSqlGatewayEndpoint((SqlGatewayService)new MockedSqlGatewayService(), (Configuration)Configuration.fromMap((Map)config))).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)errorMessage)});
    }

    private Map<String, String> getDefaultConfig() {
        return this.getDefaultConfig(UUID.randomUUID().toString());
    }

    private Map<String, String> getDefaultConfig(String id) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("sql-gateway.endpoint.mocked.id", id);
        config.put("sql-gateway.endpoint.type", "mocked");
        config.put("sql-gateway.endpoint.mocked.host", "localhost");
        config.put("sql-gateway.endpoint.mocked.port", "9999");
        return config;
    }
}

