/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Headers;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;

public class ShortDeserializer
implements Deserializer<Short> {
    @Override
    public Short deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        short value = 0;
        for (byte b : data) {
            value = (short)(value << 8);
            value = (short)(value | (short)(b & 0xFF));
        }
        return value;
    }

    @Override
    public Short deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.remaining() != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        return data.getShort(data.position());
    }
}

