/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Headers;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;

public class BooleanDeserializer
implements Deserializer<Boolean> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    @Override
    public Boolean deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 1) {
            throw new SerializationException("Size of data received by BooleanDeserializer is not 1");
        }
        if (data[0] == 1) {
            return true;
        }
        if (data[0] == 0) {
            return false;
        }
        throw new SerializationException("Unexpected byte received by BooleanDeserializer: " + data[0]);
    }

    @Override
    public Boolean deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.remaining() != 1) {
            throw new SerializationException("Size of data received by BooleanDeserializer is not 1");
        }
        byte b = data.get(data.position());
        if (b == 1) {
            return true;
        }
        if (b == 0) {
            return false;
        }
        throw new SerializationException("Unexpected byte received by BooleanDeserializer: " + b);
    }
}

