/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.RequestUtils;

public class OffsetFetchResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    public static final PartitionData UNKNOWN_PARTITION = new PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION);
    public static final PartitionData UNAUTHORIZED_PARTITION = new PartitionData(-1L, Optional.empty(), "", Errors.TOPIC_AUTHORIZATION_FAILED);
    private static final List<Errors> PARTITION_ERRORS = Arrays.asList(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.TOPIC_AUTHORIZATION_FAILED);
    private final OffsetFetchResponseData data;
    private final Errors error;
    private final Map<String, Errors> groupLevelErrors = new HashMap<String, Errors>();

    public OffsetFetchResponse(Errors error, Map<TopicPartition, PartitionData> responseData) {
        this(0, error, responseData);
    }

    public OffsetFetchResponse(int throttleTimeMs, Errors error, Map<TopicPartition, PartitionData> responseData) {
        super(ApiKeys.OFFSET_FETCH);
        HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopic> offsetFetchResponseTopicMap = new HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopic>();
        for (Map.Entry<TopicPartition, PartitionData> entry : responseData.entrySet()) {
            String topicName = entry.getKey().topic();
            OffsetFetchResponseData.OffsetFetchResponseTopic topic = offsetFetchResponseTopicMap.getOrDefault(topicName, new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicName));
            PartitionData partitionData = entry.getValue();
            topic.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(entry.getKey().partition()).setErrorCode(partitionData.error.code()).setCommittedOffset(partitionData.offset).setCommittedLeaderEpoch(partitionData.leaderEpoch.orElse(-1)).setMetadata(partitionData.metadata));
            offsetFetchResponseTopicMap.put(topicName, topic);
        }
        this.data = new OffsetFetchResponseData().setTopics(new ArrayList<OffsetFetchResponseData.OffsetFetchResponseTopic>(offsetFetchResponseTopicMap.values())).setErrorCode(error.code()).setThrottleTimeMs(throttleTimeMs);
        this.error = error;
    }

    public OffsetFetchResponse(int throttleTimeMs, Map<String, Errors> errors, Map<String, Map<TopicPartition, PartitionData>> responseData) {
        super(ApiKeys.OFFSET_FETCH);
        ArrayList<OffsetFetchResponseData.OffsetFetchResponseGroup> groupList = new ArrayList<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        for (Map.Entry<String, Map<TopicPartition, PartitionData>> entry : responseData.entrySet()) {
            String groupName = entry.getKey();
            Map<TopicPartition, PartitionData> partitionDataMap = entry.getValue();
            HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopics> offsetFetchResponseTopicsMap = new HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopics>();
            for (Map.Entry<TopicPartition, PartitionData> partitionEntry : partitionDataMap.entrySet()) {
                String topicName = partitionEntry.getKey().topic();
                OffsetFetchResponseData.OffsetFetchResponseTopics topic = offsetFetchResponseTopicsMap.getOrDefault(topicName, new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topicName));
                PartitionData partitionData = partitionEntry.getValue();
                topic.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionEntry.getKey().partition()).setErrorCode(partitionData.error.code()).setCommittedOffset(partitionData.offset).setCommittedLeaderEpoch(partitionData.leaderEpoch.orElse(-1)).setMetadata(partitionData.metadata));
                offsetFetchResponseTopicsMap.put(topicName, topic);
            }
            groupList.add(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupName).setTopics(new ArrayList<OffsetFetchResponseData.OffsetFetchResponseTopics>(offsetFetchResponseTopicsMap.values())).setErrorCode(errors.get(groupName).code()));
            this.groupLevelErrors.put(groupName, errors.get(groupName));
        }
        this.data = new OffsetFetchResponseData().setGroups(groupList).setThrottleTimeMs(throttleTimeMs);
        this.error = null;
    }

    public OffsetFetchResponse(List<OffsetFetchResponseData.OffsetFetchResponseGroup> groups, short version) {
        super(ApiKeys.OFFSET_FETCH);
        this.data = new OffsetFetchResponseData();
        if (version >= 8) {
            this.data.setGroups(groups);
            this.error = null;
            for (OffsetFetchResponseData.OffsetFetchResponseGroup group : this.data.groups()) {
                this.groupLevelErrors.put(group.groupId(), Errors.forCode(group.errorCode()));
            }
        } else {
            if (groups.size() != 1) {
                throw new UnsupportedVersionException("Version " + version + " of OffsetFetchResponse only supports one group.");
            }
            OffsetFetchResponseData.OffsetFetchResponseGroup group = groups.get(0);
            this.data.setErrorCode(group.errorCode());
            this.error = Errors.forCode(group.errorCode());
            group.topics().forEach(topic -> {
                OffsetFetchResponseData.OffsetFetchResponseTopic newTopic = new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topic.name());
                this.data.topics().add(newTopic);
                topic.partitions().forEach(partition -> {
                    OffsetFetchResponseData.OffsetFetchResponsePartition newPartition = version < 2 && group.errorCode() != Errors.NONE.code() ? new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(group.errorCode()).setCommittedOffset(-1L).setMetadata(NO_METADATA).setCommittedLeaderEpoch(-1) : new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setCommittedOffset(partition.committedOffset()).setMetadata(partition.metadata()).setCommittedLeaderEpoch(partition.committedLeaderEpoch());
                    newTopic.partitions().add(newPartition);
                });
            });
        }
    }

    public OffsetFetchResponse(OffsetFetchResponseData data, short version) {
        super(ApiKeys.OFFSET_FETCH);
        this.data = data;
        if (version < 8) {
            this.error = version >= 2 ? Errors.forCode(data.errorCode()) : OffsetFetchResponse.topLevelError(data);
        } else {
            for (OffsetFetchResponseData.OffsetFetchResponseGroup group : data.groups()) {
                this.groupLevelErrors.put(group.groupId(), Errors.forCode(group.errorCode()));
            }
            this.error = null;
        }
    }

    private static Errors topLevelError(OffsetFetchResponseData data) {
        for (OffsetFetchResponseData.OffsetFetchResponseTopic topic : data.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartition partition : topic.partitions()) {
                Errors partitionError = Errors.forCode(partition.errorCode());
                if (partitionError == Errors.NONE || PARTITION_ERRORS.contains((Object)partitionError)) continue;
                return partitionError;
            }
        }
        return Errors.NONE;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public boolean groupHasError(String groupId) {
        Errors error = this.groupLevelErrors.get(groupId);
        if (error == null) {
            return this.error != null && this.error != Errors.NONE;
        }
        return error != Errors.NONE;
    }

    public Errors error() {
        return this.error;
    }

    public Errors groupLevelError(String groupId) {
        if (this.error != null) {
            return this.error;
        }
        return this.groupLevelErrors.get(groupId);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        if (!this.groupLevelErrors.isEmpty()) {
            for (Map.Entry<String, Errors> entry : this.groupLevelErrors.entrySet()) {
                this.updateErrorCounts(counts, entry.getValue());
            }
            for (OffsetFetchResponseData.OffsetFetchResponseGroup group : this.data.groups()) {
                group.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
            }
        } else {
            this.updateErrorCounts(counts, this.error);
            this.data.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        }
        return counts;
    }

    Map<TopicPartition, PartitionData> responseDataV0ToV7() {
        HashMap<TopicPartition, PartitionData> responseData = new HashMap<TopicPartition, PartitionData>();
        for (OffsetFetchResponseData.OffsetFetchResponseTopic topic : this.data.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartition partition : topic.partitions()) {
                responseData.put(new TopicPartition(topic.name(), partition.partitionIndex()), new PartitionData(partition.committedOffset(), RequestUtils.getLeaderEpoch(partition.committedLeaderEpoch()), partition.metadata(), Errors.forCode(partition.errorCode())));
            }
        }
        return responseData;
    }

    private Map<TopicPartition, PartitionData> buildResponseData(String groupId) {
        HashMap<TopicPartition, PartitionData> responseData = new HashMap<TopicPartition, PartitionData>();
        OffsetFetchResponseData.OffsetFetchResponseGroup group = (OffsetFetchResponseData.OffsetFetchResponseGroup)this.data.groups().stream().filter(g -> g.groupId().equals(groupId)).collect(Collectors.toList()).get(0);
        for (OffsetFetchResponseData.OffsetFetchResponseTopics topic : group.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartitions partition : topic.partitions()) {
                responseData.put(new TopicPartition(topic.name(), partition.partitionIndex()), new PartitionData(partition.committedOffset(), RequestUtils.getLeaderEpoch(partition.committedLeaderEpoch()), partition.metadata(), Errors.forCode(partition.errorCode())));
            }
        }
        return responseData;
    }

    public Map<TopicPartition, PartitionData> partitionDataMap(String groupId) {
        if (this.groupLevelErrors.isEmpty()) {
            return this.responseDataV0ToV7();
        }
        return this.buildResponseData(groupId);
    }

    public static OffsetFetchResponse parse(ByteBuffer buffer, short version) {
        return new OffsetFetchResponse(new OffsetFetchResponseData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public OffsetFetchResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final Errors error;
        public final Optional<Integer> leaderEpoch;

        public PartitionData(long offset, Optional<Integer> leaderEpoch, String metadata, Errors error) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.metadata = metadata;
            this.error = error;
        }

        public boolean hasError() {
            return this.error != Errors.NONE;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PartitionData)) {
                return false;
            }
            PartitionData otherPartition = (PartitionData)other;
            return Objects.equals(this.offset, otherPartition.offset) && Objects.equals(this.leaderEpoch, otherPartition.leaderEpoch) && Objects.equals(this.metadata, otherPartition.metadata) && Objects.equals((Object)this.error, (Object)otherPartition.error);
        }

        public String toString() {
            return "PartitionData(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch.orElse(-1) + ", metadata=" + this.metadata + ", error='" + this.error.toString() + ")";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.offset, this.leaderEpoch, this.metadata, this.error});
        }
    }
}

