/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class OffsetDeleteResponse
extends AbstractResponse {
    private final OffsetDeleteResponseData data;

    public OffsetDeleteResponse(OffsetDeleteResponseData data) {
        super(ApiKeys.OFFSET_DELETE);
        this.data = data;
    }

    @Override
    public OffsetDeleteResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        return counts;
    }

    public static OffsetDeleteResponse parse(ByteBuffer buffer, short version) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 0;
    }

    public static class Builder {
        OffsetDeleteResponseData data = new OffsetDeleteResponseData();

        private OffsetDeleteResponseData.OffsetDeleteResponseTopic getOrCreateTopic(String topicName) {
            OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = this.data.topics().find(topicName);
            if (topic == null) {
                topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicName);
                this.data.topics().add(topic);
            }
            return topic;
        }

        public Builder addPartition(String topicName, int partitionIndex, Errors error) {
            OffsetDeleteResponseData.OffsetDeleteResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            topicResponse.partitions().add(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partitionIndex).setErrorCode(error.code()));
            return this;
        }

        public <P> Builder addPartitions(String topicName, List<P> partitions, Function<P, Integer> partitionIndex, Errors error) {
            OffsetDeleteResponseData.OffsetDeleteResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            partitions.forEach(partition -> topicResponse.partitions().add(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex((Integer)partitionIndex.apply(partition)).setErrorCode(error.code())));
            return this;
        }

        public Builder merge(OffsetDeleteResponseData newData) {
            if (this.data.topics().isEmpty()) {
                this.data = newData;
            } else {
                newData.topics().forEach(newTopic -> {
                    OffsetDeleteResponseData.OffsetDeleteResponseTopic existingTopic = this.data.topics().find(newTopic.name());
                    if (existingTopic == null) {
                        this.data.topics().add(newTopic.duplicate());
                    } else {
                        newTopic.partitions().forEach(partition -> existingTopic.partitions().add(partition.duplicate()));
                    }
                });
            }
            return this;
        }

        public OffsetDeleteResponse build() {
            return new OffsetDeleteResponse(this.data);
        }
    }
}

