/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.TransferableChannel;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.UnalignedRecords;

public class UnalignedFileRecords
implements UnalignedRecords {
    private final FileChannel channel;
    private final long position;
    private final int size;

    public UnalignedFileRecords(FileChannel channel, long position, int size) {
        this.channel = channel;
        this.position = position;
        this.size = size;
    }

    @Override
    public int sizeInBytes() {
        return this.size;
    }

    @Override
    public int writeTo(TransferableChannel destChannel, int previouslyWritten, int remaining) throws IOException {
        long position = this.position + (long)previouslyWritten;
        int count = Math.min(remaining, this.sizeInBytes() - previouslyWritten);
        return (int)destChannel.transferFrom(this.channel, position, count);
    }
}

