/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Bytes;

public class DescribeDelegationTokenResponseData
implements ApiMessage {
    short errorCode;
    List<DescribedDelegationToken> tokens;
    int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DescribeDelegationTokenResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeDelegationTokenResponseData() {
        this.errorCode = 0;
        this.tokens = new ArrayList<DescribedDelegationToken>(0);
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 41;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribedDelegationToken> newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field tokens was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedDelegationToken(_readable, _version));
            }
            this.tokens = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field tokens was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DescribedDelegationToken>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedDelegationToken(_readable, _version));
            }
            this.tokens = newCollection;
        }
        this.throttleTimeMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.tokens.size() + 1);
            for (DescribedDelegationToken tokensElement : this.tokens) {
                tokensElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.tokens.size());
            for (DescribedDelegationToken tokensElement : this.tokens) {
                tokensElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.throttleTimeMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tokens.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DescribedDelegationToken tokensElement : this.tokens) {
            tokensElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeDelegationTokenResponseData)) {
            return false;
        }
        DescribeDelegationTokenResponseData other = (DescribeDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.tokens == null ? 0 : this.tokens.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    @Override
    public DescribeDelegationTokenResponseData duplicate() {
        DescribeDelegationTokenResponseData _duplicate = new DescribeDelegationTokenResponseData();
        _duplicate.errorCode = this.errorCode;
        ArrayList<DescribedDelegationToken> newTokens = new ArrayList<DescribedDelegationToken>(this.tokens.size());
        for (DescribedDelegationToken _element : this.tokens) {
            newTokens.add(_element.duplicate());
        }
        _duplicate.tokens = newTokens;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "DescribeDelegationTokenResponseData(errorCode=" + this.errorCode + ", tokens=" + MessageUtil.deepToString(this.tokens.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<DescribedDelegationToken> tokens() {
        return this.tokens;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setTokens(List<DescribedDelegationToken> v) {
        this.tokens = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new ArrayOf(DescribedDelegationToken.SCHEMA_0), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new CompactArrayOf(DescribedDelegationToken.SCHEMA_2), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_3 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new CompactArrayOf(DescribedDelegationToken.SCHEMA_3), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DescribedDelegationTokenRenewer
    implements Message {
        String principalType;
        String principalName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribedDelegationTokenRenewer(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedDelegationTokenRenewer() {
            this.principalType = "";
            this.principalName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationTokenRenewer");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalType had invalid length " + length);
            }
            this.principalType = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalName had invalid length " + length);
            }
            this.principalName = _readable.readString(length);
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.principalType);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.principalName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedDelegationTokenRenewer");
            }
            byte[] _stringBytes = this.principalType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalType, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.principalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalName, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationTokenRenewer)) {
                return false;
            }
            DescribedDelegationTokenRenewer other = (DescribedDelegationTokenRenewer)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            return hashCode;
        }

        @Override
        public DescribedDelegationTokenRenewer duplicate() {
            DescribedDelegationTokenRenewer _duplicate = new DescribedDelegationTokenRenewer();
            _duplicate.principalType = this.principalType;
            _duplicate.principalName = this.principalName;
            return _duplicate;
        }

        public String toString() {
            return "DescribedDelegationTokenRenewer(principalType=" + (this.principalType == null ? "null" : "'" + this.principalType.toString() + "'") + ", principalName=" + (this.principalName == null ? "null" : "'" + this.principalName.toString() + "'") + ")";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedDelegationTokenRenewer setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationTokenRenewer setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The renewer principal type"), new Field("principal_name", Type.STRING, "The renewer principal name"));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("principal_type", Type.COMPACT_STRING, "The renewer principal type"), new Field("principal_name", Type.COMPACT_STRING, "The renewer principal name"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class DescribedDelegationToken
    implements Message {
        String principalType;
        String principalName;
        String tokenRequesterPrincipalType;
        String tokenRequesterPrincipalName;
        long issueTimestamp;
        long expiryTimestamp;
        long maxTimestamp;
        String tokenId;
        byte[] hmac;
        List<DescribedDelegationTokenRenewer> renewers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DescribedDelegationToken(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedDelegationToken() {
            this.principalType = "";
            this.principalName = "";
            this.tokenRequesterPrincipalType = "";
            this.tokenRequesterPrincipalName = "";
            this.issueTimestamp = 0L;
            this.expiryTimestamp = 0L;
            this.maxTimestamp = 0L;
            this.tokenId = "";
            this.hmac = Bytes.EMPTY;
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribedDelegationTokenRenewer> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationToken");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalType had invalid length " + length);
            }
            this.principalType = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalName had invalid length " + length);
            }
            this.principalName = _readable.readString(length);
            if (_version >= 3) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field tokenRequesterPrincipalType was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field tokenRequesterPrincipalType had invalid length " + length);
                }
                this.tokenRequesterPrincipalType = _readable.readString(length);
            } else {
                this.tokenRequesterPrincipalType = "";
            }
            if (_version >= 3) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field tokenRequesterPrincipalName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field tokenRequesterPrincipalName had invalid length " + length);
                }
                this.tokenRequesterPrincipalName = _readable.readString(length);
            } else {
                this.tokenRequesterPrincipalName = "";
            }
            this.issueTimestamp = _readable.readLong();
            this.expiryTimestamp = _readable.readLong();
            this.maxTimestamp = _readable.readLong();
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field tokenId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tokenId had invalid length " + length);
            }
            this.tokenId = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field hmac was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.hmac = newBytes;
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field renewers was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedDelegationTokenRenewer(_readable, _version));
                }
                this.renewers = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field renewers was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<DescribedDelegationTokenRenewer>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedDelegationTokenRenewer(_readable, _version));
                }
                this.renewers = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.principalType);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.principalName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _stringBytes = _cache.getSerializedValue(this.tokenRequesterPrincipalType);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            } else if (!this.tokenRequesterPrincipalType.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default tokenRequesterPrincipalType at version " + _version);
            }
            if (_version >= 3) {
                _stringBytes = _cache.getSerializedValue(this.tokenRequesterPrincipalName);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            } else if (!this.tokenRequesterPrincipalName.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default tokenRequesterPrincipalName at version " + _version);
            }
            _writable.writeLong(this.issueTimestamp);
            _writable.writeLong(this.expiryTimestamp);
            _writable.writeLong(this.maxTimestamp);
            _stringBytes = _cache.getSerializedValue(this.tokenId);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.hmac.length + 1);
            } else {
                _writable.writeInt(this.hmac.length);
            }
            _writable.writeByteArray(this.hmac);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.renewers.size() + 1);
                _stringBytes = this.renewers.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedDelegationTokenRenewer renewersElement = (DescribedDelegationTokenRenewer)_stringBytes.next();
                    renewersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.renewers.size());
                _stringBytes = this.renewers.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedDelegationTokenRenewer renewersElement = (DescribedDelegationTokenRenewer)_stringBytes.next();
                    renewersElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedDelegationToken");
            }
            byte[] _stringBytes = this.principalType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalType, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.principalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalName, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _stringBytes = this.tokenRequesterPrincipalType.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'tokenRequesterPrincipalType' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.tokenRequesterPrincipalType, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_version >= 3) {
                _stringBytes = this.tokenRequesterPrincipalName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'tokenRequesterPrincipalName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.tokenRequesterPrincipalName, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _stringBytes = this.tokenId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tokenId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tokenId, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(this.hmac.length);
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.hmac.length + 1));
            } else {
                _size.addBytes(4);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.renewers.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (DescribedDelegationTokenRenewer renewersElement : this.renewers) {
                renewersElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationToken)) {
                return false;
            }
            DescribedDelegationToken other = (DescribedDelegationToken)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
                return false;
            }
            if (this.tokenRequesterPrincipalType == null ? other.tokenRequesterPrincipalType != null : !this.tokenRequesterPrincipalType.equals(other.tokenRequesterPrincipalType)) {
                return false;
            }
            if (this.tokenRequesterPrincipalName == null ? other.tokenRequesterPrincipalName != null : !this.tokenRequesterPrincipalName.equals(other.tokenRequesterPrincipalName)) {
                return false;
            }
            if (this.issueTimestamp != other.issueTimestamp) {
                return false;
            }
            if (this.expiryTimestamp != other.expiryTimestamp) {
                return false;
            }
            if (this.maxTimestamp != other.maxTimestamp) {
                return false;
            }
            if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
                return false;
            }
            if (!Arrays.equals(this.hmac, other.hmac)) {
                return false;
            }
            if (this.renewers == null ? other.renewers != null : !this.renewers.equals(other.renewers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            hashCode = 31 * hashCode + (this.tokenRequesterPrincipalType == null ? 0 : this.tokenRequesterPrincipalType.hashCode());
            hashCode = 31 * hashCode + (this.tokenRequesterPrincipalName == null ? 0 : this.tokenRequesterPrincipalName.hashCode());
            hashCode = 31 * hashCode + ((int)(this.issueTimestamp >> 32) ^ (int)this.issueTimestamp);
            hashCode = 31 * hashCode + ((int)(this.expiryTimestamp >> 32) ^ (int)this.expiryTimestamp);
            hashCode = 31 * hashCode + ((int)(this.maxTimestamp >> 32) ^ (int)this.maxTimestamp);
            hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
            hashCode = 31 * hashCode + (this.renewers == null ? 0 : this.renewers.hashCode());
            return hashCode;
        }

        @Override
        public DescribedDelegationToken duplicate() {
            DescribedDelegationToken _duplicate = new DescribedDelegationToken();
            _duplicate.principalType = this.principalType;
            _duplicate.principalName = this.principalName;
            _duplicate.tokenRequesterPrincipalType = this.tokenRequesterPrincipalType;
            _duplicate.tokenRequesterPrincipalName = this.tokenRequesterPrincipalName;
            _duplicate.issueTimestamp = this.issueTimestamp;
            _duplicate.expiryTimestamp = this.expiryTimestamp;
            _duplicate.maxTimestamp = this.maxTimestamp;
            _duplicate.tokenId = this.tokenId;
            _duplicate.hmac = MessageUtil.duplicate(this.hmac);
            ArrayList<DescribedDelegationTokenRenewer> newRenewers = new ArrayList<DescribedDelegationTokenRenewer>(this.renewers.size());
            for (DescribedDelegationTokenRenewer _element : this.renewers) {
                newRenewers.add(_element.duplicate());
            }
            _duplicate.renewers = newRenewers;
            return _duplicate;
        }

        public String toString() {
            return "DescribedDelegationToken(principalType=" + (this.principalType == null ? "null" : "'" + this.principalType.toString() + "'") + ", principalName=" + (this.principalName == null ? "null" : "'" + this.principalName.toString() + "'") + ", tokenRequesterPrincipalType=" + (this.tokenRequesterPrincipalType == null ? "null" : "'" + this.tokenRequesterPrincipalType.toString() + "'") + ", tokenRequesterPrincipalName=" + (this.tokenRequesterPrincipalName == null ? "null" : "'" + this.tokenRequesterPrincipalName.toString() + "'") + ", issueTimestamp=" + this.issueTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", tokenId=" + (this.tokenId == null ? "null" : "'" + this.tokenId.toString() + "'") + ", hmac=" + Arrays.toString(this.hmac) + ", renewers=" + MessageUtil.deepToString(this.renewers.iterator()) + ")";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public String tokenRequesterPrincipalType() {
            return this.tokenRequesterPrincipalType;
        }

        public String tokenRequesterPrincipalName() {
            return this.tokenRequesterPrincipalName;
        }

        public long issueTimestamp() {
            return this.issueTimestamp;
        }

        public long expiryTimestamp() {
            return this.expiryTimestamp;
        }

        public long maxTimestamp() {
            return this.maxTimestamp;
        }

        public String tokenId() {
            return this.tokenId;
        }

        public byte[] hmac() {
            return this.hmac;
        }

        public List<DescribedDelegationTokenRenewer> renewers() {
            return this.renewers;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedDelegationToken setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationToken setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        public DescribedDelegationToken setTokenRequesterPrincipalType(String v) {
            this.tokenRequesterPrincipalType = v;
            return this;
        }

        public DescribedDelegationToken setTokenRequesterPrincipalName(String v) {
            this.tokenRequesterPrincipalName = v;
            return this;
        }

        public DescribedDelegationToken setIssueTimestamp(long v) {
            this.issueTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setExpiryTimestamp(long v) {
            this.expiryTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setMaxTimestamp(long v) {
            this.maxTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setTokenId(String v) {
            this.tokenId = v;
            return this;
        }

        public DescribedDelegationToken setHmac(byte[] v) {
            this.hmac = v;
            return this;
        }

        public DescribedDelegationToken setRenewers(List<DescribedDelegationTokenRenewer> v) {
            this.renewers = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The token principal type."), new Field("principal_name", Type.STRING, "The token principal name."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.STRING, "The token ID."), new Field("hmac", Type.BYTES, "The token HMAC."), new Field("renewers", new ArrayOf(DescribedDelegationTokenRenewer.SCHEMA_0), "Those who are able to renew this token before it expires."));
            SCHEMA_2 = new Schema(new Field("principal_type", Type.COMPACT_STRING, "The token principal type."), new Field("principal_name", Type.COMPACT_STRING, "The token principal name."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.COMPACT_STRING, "The token ID."), new Field("hmac", Type.COMPACT_BYTES, "The token HMAC."), new Field("renewers", new CompactArrayOf(DescribedDelegationTokenRenewer.SCHEMA_2), "Those who are able to renew this token before it expires."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_3 = new Schema(new Field("principal_type", Type.COMPACT_STRING, "The token principal type."), new Field("principal_name", Type.COMPACT_STRING, "The token principal name."), new Field("token_requester_principal_type", Type.COMPACT_STRING, "The principal type of the requester of the token."), new Field("token_requester_principal_name", Type.COMPACT_STRING, "The principal type of the requester of the token."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.COMPACT_STRING, "The token ID."), new Field("hmac", Type.COMPACT_BYTES, "The token HMAC."), new Field("renewers", new CompactArrayOf(DescribedDelegationTokenRenewer.SCHEMA_2), "Those who are able to renew this token before it expires."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

