/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps;

import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.proto.Security;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps.KTopicDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps.KWPSCommon;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps.KafkaTopicsAdmin;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.NewTopic;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KafkaTopicsAdminEx
extends KafkaTopicsAdmin {
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicsAdminEx.class);

    public KafkaTopicsAdminEx() throws IOException {
    }

    public KafkaTopicsAdminEx(@NonNull String maprUser) throws IOException {
        this(maprUser, null);
        if (maprUser == null) {
            throw new NullPointerException("maprUser is marked non-null but is null");
        }
    }

    public KafkaTopicsAdminEx(@NonNull String maprUser, Security.CredentialsMsg userCredentials) throws IOException {
        super(maprUser, userCredentials);
        if (maprUser == null) {
            throw new NullPointerException("maprUser is marked non-null but is null");
        }
    }

    public List<String> getAllTopics() {
        LinkedList<String> topicList = new LinkedList<String>();
        try {
            MapRFileStatus[] all = null;
            try {
                all = this.mfs.listStatus(KWPSCommon.KWPS_TOPICS_FOLDER_PATH);
            }
            catch (FileNotFoundException e) {
                new KafkaException("Kafka topics folder '/var/mapr/mapr.kwps.root/topics/' doesn't exist on the cluster.", e);
            }
            for (MapRFileStatus fStatus : all) {
                Path fPath = fStatus.getPath();
                if (fStatus.isDirectory()) {
                    String topicName = fPath.getName();
                    topicList.add(topicName);
                    continue;
                }
                log.warn("Unknown file '{}' in Kafka topics folder!", (Object)fPath);
            }
            return topicList;
        }
        catch (IOException e) {
            throw new KafkaException(e);
        }
    }

    public List<String> getAllStreams() {
        LinkedList<String> streamList = new LinkedList<String>();
        try {
            MapRFileStatus[] all = null;
            try {
                all = this.mfs.listStatus(KWPSCommon.KWPS_TOPICS_FOLDER_PATH);
            }
            catch (FileNotFoundException e) {
                new KafkaException("Kafka topics folder '/var/mapr/mapr.kwps.root/topics/' doesn't exist on the cluster.", e);
            }
            for (MapRFileStatus fStatus : all) {
                Path fPath = fStatus.getPath();
                if (fStatus.isDirectory()) {
                    String topicName = fPath.getName();
                    streamList.add(KWPSCommon.getStreamPath(topicName));
                    continue;
                }
                log.warn("Unknown file '{}' in Kafka topics folder!", (Object)fPath);
            }
            return streamList;
        }
        catch (IOException e) {
            throw new KafkaException(e);
        }
    }

    public CreateTopicsResult createTopics(@NonNull List<NewTopic> fullTopicPaths) {
        if (fullTopicPaths == null) {
            throw new NullPointerException("fullTopicPaths is marked non-null but is null");
        }
        HashMap<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>> createTopicResult = new HashMap<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>>();
        for (NewTopic nt : fullTopicPaths) {
            String fullTopicPath = nt.name();
            KafkaFutureImpl future = new KafkaFutureImpl();
            try {
                boolean ownVolume = false;
                Map<String, String> configs = nt.configs();
                if (configs != null) {
                    String createVolumeProp = configs.get("own.volume");
                    if (createVolumeProp != null) {
                        ownVolume = Boolean.valueOf(createVolumeProp);
                    } else {
                        String preallocate = configs.get("preallocate");
                        ownVolume = Boolean.valueOf(preallocate);
                    }
                }
                String topicName = this.getTopicName(fullTopicPath);
                KTopicDescriptor ktopicDesc = new KTopicDescriptor(topicName).setPartitions(nt.numPartitions()).setOwnVolume(ownVolume);
                this.createTopic(ktopicDesc);
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
            createTopicResult.put(fullTopicPath, future);
        }
        return new CreateTopicsResult(createTopicResult);
    }

    public DescribeTopicsResult describeTopics(@NonNull List<String> fullTopicPaths) {
        if (fullTopicPaths == null) {
            throw new NullPointerException("fullTopicPaths is marked non-null but is null");
        }
        return this.adminClient.describeTopics(fullTopicPaths);
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(@NonNull String streamPath, @NonNull String groupId) {
        if (streamPath == null) {
            throw new NullPointerException("streamPath is marked non-null but is null");
        }
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        return this.adminClient.listConsumerGroupOffsets(streamPath, groupId);
    }

    public DeleteTopicsResult deleteTopics(@NonNull List<String> fullTopicPaths) {
        if (fullTopicPaths == null) {
            throw new NullPointerException("fullTopicPaths is marked non-null but is null");
        }
        HashMap<String, KafkaFuture<Void>> deleteTopicsResult = new HashMap<String, KafkaFuture<Void>>();
        for (String fullTopicPath : fullTopicPaths) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            try {
                String topicName = this.getTopicName(fullTopicPath);
                this.deleteTopic(topicName);
                future.complete(null);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
            deleteTopicsResult.put(fullTopicPath, future);
        }
        return DeleteTopicsResult.ofTopicNames(deleteTopicsResult);
    }

    private String getTopicName(String fullTopicPath) {
        String[] tokens = fullTopicPath.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(fullTopicPath + " is not a valid Data Fabric topic path");
        }
        return tokens[1];
    }
}

