/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

@Internal
public class KafkaPartitionSplitSerializer
implements SimpleVersionedSerializer<KafkaPartitionSplit> {
    private static final int CURRENT_VERSION = 0;

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(KafkaPartitionSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeUTF(split.getTopic());
                out.writeInt(split.getPartition());
                out.writeLong(split.getStartingOffset());
                out.writeLong(split.getStoppingOffset().orElse(Long.MIN_VALUE));
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public KafkaPartitionSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            KafkaPartitionSplit kafkaPartitionSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                String topic = in.readUTF();
                int partition = in.readInt();
                long offset = in.readLong();
                long stoppingOffset = in.readLong();
                kafkaPartitionSplit = new KafkaPartitionSplit(new TopicPartition(topic, partition), offset, stoppingOffset);
            }
            return kafkaPartitionSplit;
        }
    }
}

