/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.enumerator.subscriber;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaMetadataService;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.subscriber.KafkaStreamSubscriber;

@Internal
public class StreamPatternSubscriber
implements KafkaStreamSubscriber {
    private final Pattern streamPattern;

    public StreamPatternSubscriber(Pattern streamPattern) {
        this.streamPattern = streamPattern;
    }

    @Override
    public Set<KafkaStream> getSubscribedStreams(KafkaMetadataService kafkaMetadataService) {
        Set<KafkaStream> allStreams = kafkaMetadataService.getAllStreams();
        ArrayList<KafkaStream> matches = new ArrayList<KafkaStream>();
        for (KafkaStream kafkaStream : allStreams) {
            String streamId = kafkaStream.getStreamId();
            if (!this.streamPattern.matcher(streamId).find()) continue;
            matches.add(kafkaStream);
        }
        return Set.copyOf(matches);
    }
}

