/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class AvroFormatOptions {
    public static final ConfigOption<String> AVRO_OUTPUT_CODEC = ConfigOptions.key((String)"codec").stringType().defaultValue((Object)"snappy").withDescription("The compression codec for avro");
    public static final ConfigOption<AvroEncoding> AVRO_ENCODING = ConfigOptions.key((String)"encoding").enumType(AvroEncoding.class).defaultValue((Object)AvroEncoding.BINARY).withDescription("The encoding to use for serialization. Binary offers a more compact, space-efficient way to represent objects, while JSON offers a more human-readable option.");
    public static final ConfigOption<Boolean> AVRO_TIMESTAMP_LEGACY_MAPPING = ConfigOptions.key((String)"timestamp_mapping.legacy").booleanType().defaultValue((Object)true).withDescription("Use the legacy mapping of timestamp in avro. Before 1.19, The default behavior of Flink wrongly mapped both SQL TIMESTAMP and TIMESTAMP_LTZ type to AVRO TIMESTAMP. The correct behavior is Flink SQL TIMESTAMP maps Avro LOCAL TIMESTAMP and Flink SQL TIMESTAMP_LTZ maps Avro TIMESTAMP, you can obtain the correct mapping by disable using this legacy mapping. Use legacy behavior by default for compatibility consideration.");

    private AvroFormatOptions() {
    }

    public static enum AvroEncoding implements DescribedEnum
    {
        BINARY("binary", (InlineElement)TextElement.text((String)"Use binary encoding for serialization and deserialization.")),
        JSON("json", (InlineElement)TextElement.text((String)"Use JSON encoding for serialization and deserialization."));

        private final String value;
        private final InlineElement description;

        private AvroEncoding(String value, InlineElement description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return this.description;
        }
    }
}

