/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;

class Hex {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];
    private static final Hex encoder = new Hex();

    protected Hex() {
        int i;
        for (i = 0; i < this.decodingTable.length; ++i) {
            this.decodingTable[i] = -1;
        }
        for (i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public static byte[] decodeStrict(String data) {
        try {
            return encoder.decodeStrict(data, 0, data.length());
        }
        catch (Exception e) {
            throw new IllegalStateException("exception decoding Hex string: " + e.getMessage(), e);
        }
    }

    byte[] decodeStrict(String str, int off, int len) throws IOException {
        if (null == str) {
            throw new NullPointerException("'str' cannot be null");
        }
        if (off < 0 || len < 0 || off > str.length() - len) {
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        if (0 != (len & 1)) {
            throw new IOException("a hexadecimal encoding must have an even number of characters");
        }
        int resultLen = len >>> 1;
        byte[] result = new byte[resultLen];
        int strPos = off;
        for (int i = 0; i < resultLen; ++i) {
            byte b2;
            byte b1;
            int n;
            if ((n = (b1 = this.decodingTable[str.charAt(strPos++)]) << 4 | (b2 = this.decodingTable[str.charAt(strPos++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            result[i] = (byte)n;
        }
        return result;
    }
}

