/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.DummyX509TrustManager;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.X509KeyManagerUtil;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(ProvSSLContextSpi.class.getName());
    private static final String PROPERTY_CLIENT_CIPHERSUITES = "jdk.tls.client.cipherSuites";
    private static final String PROPERTY_SERVER_CIPHERSUITES = "jdk.tls.server.cipherSuites";
    private static final String PROPERTY_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String PROPERTY_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    private static final Set<BCCryptoPrimitive> TLS_CRYPTO_PRIMITIVES_BC = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP_FIPS = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP);
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP = ProvSSLContextSpi.createSupportedProtocolMap();
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP_FIPS = ProvSSLContextSpi.createSupportedProtocolMapFips(SUPPORTED_PROTOCOL_MAP);
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST);
    private static final List<String> DEFAULT_PROTOCOL_LIST = ProvSSLContextSpi.createDefaultProtocolList(SUPPORTED_PROTOCOL_MAP.keySet());
    private static final List<String> DEFAULT_PROTOCOL_LIST_FIPS = ProvSSLContextSpi.createDefaultProtocolListFips(DEFAULT_PROTOCOL_LIST);
    protected final boolean isInFipsMode;
    protected final JcaTlsCryptoProvider cryptoProvider;
    protected final Map<String, CipherSuiteInfo> supportedCipherSuites;
    protected final Map<String, ProtocolVersion> supportedProtocols;
    protected final String[] defaultCipherSuitesClient;
    protected final String[] defaultCipherSuitesServer;
    protected final String[] defaultProtocolsClient;
    protected final String[] defaultProtocolsServer;
    private ContextData contextData = null;

    private static void addCipherSuite(Map<String, CipherSuiteInfo> cs, String name, int cipherSuite) {
        CipherSuiteInfo cipherSuiteInfo = CipherSuiteInfo.forCipherSuite(cipherSuite, name);
        if (null != cs.put(name, cipherSuiteInfo)) {
            throw new IllegalStateException("Duplicate names in supported-cipher-suites");
        }
    }

    private static List<String> createDefaultCipherSuiteList(Set<String> supportedCipherSuiteSet) {
        ArrayList<String> cs = new ArrayList<String>();
        cs.add("TLS_CHACHA20_POLY1305_SHA256");
        cs.add("TLS_AES_256_GCM_SHA384");
        cs.add("TLS_AES_128_GCM_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        cs.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        cs.retainAll(supportedCipherSuiteSet);
        cs.trimToSize();
        return Collections.unmodifiableList(cs);
    }

    private static List<String> createDefaultCipherSuiteListFips(List<String> defaultCipherSuiteList) {
        ArrayList<String> cs = new ArrayList<String>(defaultCipherSuiteList);
        FipsUtils.removeNonFipsCipherSuites(cs);
        cs.trimToSize();
        return Collections.unmodifiableList(cs);
    }

    private static List<String> createDefaultProtocolList(Set<String> supportedProtocolSet) {
        ArrayList<String> ps = new ArrayList<String>();
        ps.add("TLSv1.2");
        ps.add("TLSv1.1");
        ps.add("TLSv1");
        ps.retainAll(supportedProtocolSet);
        ps.trimToSize();
        return Collections.unmodifiableList(ps);
    }

    private static List<String> createDefaultProtocolListFips(List<String> defaultProtocolList) {
        ArrayList<String> ps = new ArrayList<String>(defaultProtocolList);
        FipsUtils.removeNonFipsProtocols(ps);
        ps.trimToSize();
        return Collections.unmodifiableList(ps);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMap() {
        TreeMap<String, CipherSuiteInfo> cs = new TreeMap<String, CipherSuiteInfo>();
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_AES_128_CCM_8_SHA256", 4869);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_AES_128_CCM_SHA256", 4868);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_AES_128_GCM_SHA256", 4865);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_AES_256_GCM_SHA384", 4866);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_CHACHA20_POLY1305_SHA256", 4867);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", 49218);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256", 49238);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", 49219);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384", 49239);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", 189);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256", 49280);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", 195);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384", 49281);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", 49220);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256", 49234);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", 49221);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384", 49235);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 190);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49276);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", 196);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49277);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52394);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", 49224);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256", 49244);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", 49225);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384", 49245);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", 49266);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", 49286);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", 49267);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", 49287);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", 49228);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256", 49248);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", 49229);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384", 49249);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 49270);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49290);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", 49271);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49291);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_128_CCM", 49308);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_128_CCM_8", 49312);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_256_CCM", 49309);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_256_CCM_8", 49313);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_ARIA_128_CBC_SHA256", 49212);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_ARIA_128_GCM_SHA256", 49232);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_ARIA_256_CBC_SHA384", 49213);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_ARIA_256_GCM_SHA384", 49233);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", 186);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49274);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", 192);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49275);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_NULL_SHA", 2);
        ProvSSLContextSpi.addCipherSuite(cs, "TLS_RSA_WITH_NULL_SHA256", 59);
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMapFips(Map<String, CipherSuiteInfo> supportedCipherSuiteMap) {
        LinkedHashMap<String, CipherSuiteInfo> cs = new LinkedHashMap<String, CipherSuiteInfo>(supportedCipherSuiteMap);
        FipsUtils.removeNonFipsCipherSuites(cs.keySet());
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMap() {
        LinkedHashMap<String, ProtocolVersion> ps = new LinkedHashMap<String, ProtocolVersion>();
        ps.put("TLSv1.3", ProtocolVersion.TLSv13);
        ps.put("TLSv1.2", ProtocolVersion.TLSv12);
        ps.put("TLSv1.1", ProtocolVersion.TLSv11);
        ps.put("TLSv1", ProtocolVersion.TLSv10);
        ps.put("SSLv3", ProtocolVersion.SSLv3);
        return Collections.unmodifiableMap(ps);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMapFips(Map<String, ProtocolVersion> supportedProtocolMap) {
        LinkedHashMap<String, ProtocolVersion> ps = new LinkedHashMap<String, ProtocolVersion>(supportedProtocolMap);
        FipsUtils.removeNonFipsProtocols(ps.keySet());
        return Collections.unmodifiableMap(ps);
    }

    private static String[] getDefaultEnabledCipherSuites(Map<String, CipherSuiteInfo> supportedCipherSuiteMap, String cipherSuitesPropertyName, List<String> defaultCipherSuiteList) {
        List<String> candidates = ProvSSLContextSpi.getJdkTlsCipherSuites(cipherSuitesPropertyName, defaultCipherSuiteList);
        String[] result = new String[candidates.size()];
        int count = 0;
        for (String candidate : candidates) {
            if (!supportedCipherSuiteMap.containsKey(candidate) || !ProvAlgorithmConstraints.DEFAULT.permits(TLS_CRYPTO_PRIMITIVES_BC, candidate, null)) continue;
            result[count++] = candidate;
        }
        return JsseUtils.resize(result, count);
    }

    private static String[] getDefaultEnabledCipherSuitesClient(Map<String, CipherSuiteInfo> supportedCipherSuiteMap, List<String> defaultCipherSuiteList) {
        return ProvSSLContextSpi.getDefaultEnabledCipherSuites(supportedCipherSuiteMap, PROPERTY_CLIENT_CIPHERSUITES, defaultCipherSuiteList);
    }

    private static String[] getDefaultEnabledCipherSuitesServer(Map<String, CipherSuiteInfo> supportedCipherSuiteMap, List<String> defaultCipherSuiteList) {
        return ProvSSLContextSpi.getDefaultEnabledCipherSuites(supportedCipherSuiteMap, PROPERTY_SERVER_CIPHERSUITES, defaultCipherSuiteList);
    }

    private static String[] getDefaultEnabledProtocols(Map<String, ProtocolVersion> supportedProtocolMap, String protocolsPropertyName, List<String> defaultProtocolList, List<String> specifiedProtocols) {
        List<String> candidates = specifiedProtocols;
        if (null == candidates) {
            candidates = ProvSSLContextSpi.getJdkTlsProtocols(protocolsPropertyName, defaultProtocolList);
        }
        String[] result = new String[candidates.size()];
        int count = 0;
        for (String candidate : candidates) {
            if (!supportedProtocolMap.containsKey(candidate) || !ProvAlgorithmConstraints.DEFAULT_TLS_ONLY.permits(TLS_CRYPTO_PRIMITIVES_BC, candidate, null)) continue;
            result[count++] = candidate;
        }
        return JsseUtils.resize(result, count);
    }

    private static String[] getDefaultEnabledProtocolsClient(Map<String, ProtocolVersion> supportedProtocolMap, List<String> defaultProtocolList, List<String> specifiedProtocols) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(supportedProtocolMap, PROPERTY_CLIENT_PROTOCOLS, defaultProtocolList, specifiedProtocols);
    }

    private static String[] getDefaultEnabledProtocolsServer(Map<String, ProtocolVersion> supportedProtocolMap, List<String> defaultProtocolList) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(supportedProtocolMap, PROPERTY_SERVER_PROTOCOLS, defaultProtocolList, null);
    }

    private static List<String> getJdkTlsCipherSuites(String cipherSuitesPropertyName, List<String> defaultCipherSuiteList) {
        String[] cipherSuites = PropertyUtils.getStringArraySystemProperty(cipherSuitesPropertyName);
        if (null == cipherSuites) {
            return defaultCipherSuiteList;
        }
        ArrayList<String> result = new ArrayList<String>(cipherSuites.length);
        for (String cipherSuite : cipherSuites) {
            if (result.contains(cipherSuite)) continue;
            if (!SUPPORTED_CIPHERSUITE_MAP.containsKey(cipherSuite)) {
                LOG.warning("'" + cipherSuitesPropertyName + "' contains unsupported cipher suite: " + cipherSuite);
                continue;
            }
            result.add(cipherSuite);
        }
        if (result.isEmpty()) {
            LOG.severe("'" + cipherSuitesPropertyName + "' contained no supported cipher suites (ignoring)");
            return defaultCipherSuiteList;
        }
        return result;
    }

    private static List<String> getJdkTlsProtocols(String protocolsPropertyName, List<String> defaultProtocolList) {
        String[] protocols = PropertyUtils.getStringArraySystemProperty(protocolsPropertyName);
        if (null == protocols) {
            return defaultProtocolList;
        }
        ArrayList<String> result = new ArrayList<String>(protocols.length);
        for (String protocol : protocols) {
            if (result.contains(protocol)) continue;
            if (!SUPPORTED_PROTOCOL_MAP.containsKey(protocol)) {
                LOG.warning("'" + protocolsPropertyName + "' contains unsupported protocol: " + protocol);
                continue;
            }
            result.add(protocol);
        }
        if (result.isEmpty()) {
            LOG.severe("'" + protocolsPropertyName + "' contained no supported protocols (ignoring)");
            return defaultProtocolList;
        }
        return result;
    }

    private static String[] getArray(Collection<String> c) {
        return c.toArray(new String[c.size()]);
    }

    private static String[] getKeysArray(Map<String, ?> m) {
        return ProvSSLContextSpi.getArray(m.keySet());
    }

    static CipherSuiteInfo getCipherSuiteInfo(String cipherSuiteName) {
        return SUPPORTED_CIPHERSUITE_MAP.get(cipherSuiteName);
    }

    static String getCipherSuiteName(int cipherSuite) {
        if (0 == cipherSuite) {
            return "SSL_NULL_WITH_NULL_NULL";
        }
        if (TlsUtils.isValidUint16(cipherSuite)) {
            for (CipherSuiteInfo cipherSuiteInfo : SUPPORTED_CIPHERSUITE_MAP.values()) {
                if (cipherSuiteInfo.getCipherSuite() != cipherSuite) continue;
                return cipherSuiteInfo.getName();
            }
        }
        return null;
    }

    static KeyManager[] getDefaultKeyManagers() throws Exception {
        KeyStoreConfig keyStoreConfig = ProvKeyManagerFactorySpi.getDefaultKeyStore();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStoreConfig.keyStore, keyStoreConfig.password);
        return kmf.getKeyManagers();
    }

    static TrustManager[] getDefaultTrustManagers() throws Exception {
        KeyStore trustStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    static ProtocolVersion getProtocolVersion(String protocolVersionName) {
        return SUPPORTED_PROTOCOL_MAP.get(protocolVersionName);
    }

    static String getProtocolVersionName(ProtocolVersion protocolVersion) {
        if (null != protocolVersion) {
            for (Map.Entry<String, ProtocolVersion> entry : SUPPORTED_PROTOCOL_MAP.entrySet()) {
                if (!entry.getValue().equals(protocolVersion)) continue;
                return entry.getKey();
            }
        }
        return "NONE";
    }

    ProvSSLContextSpi(boolean isInFipsMode, JcaTlsCryptoProvider cryptoProvider, List<String> specifiedProtocolsClient) {
        this.isInFipsMode = isInFipsMode;
        this.cryptoProvider = cryptoProvider;
        this.supportedCipherSuites = isInFipsMode ? SUPPORTED_CIPHERSUITE_MAP_FIPS : SUPPORTED_CIPHERSUITE_MAP;
        this.supportedProtocols = isInFipsMode ? SUPPORTED_PROTOCOL_MAP_FIPS : SUPPORTED_PROTOCOL_MAP;
        List<String> defaultCipherSuiteList = isInFipsMode ? DEFAULT_CIPHERSUITE_LIST_FIPS : DEFAULT_CIPHERSUITE_LIST;
        List<String> defaultProtocolList = isInFipsMode ? DEFAULT_PROTOCOL_LIST_FIPS : DEFAULT_PROTOCOL_LIST;
        this.defaultCipherSuitesClient = ProvSSLContextSpi.getDefaultEnabledCipherSuitesClient(this.supportedCipherSuites, defaultCipherSuiteList);
        this.defaultCipherSuitesServer = ProvSSLContextSpi.getDefaultEnabledCipherSuitesServer(this.supportedCipherSuites, defaultCipherSuiteList);
        this.defaultProtocolsClient = ProvSSLContextSpi.getDefaultEnabledProtocolsClient(this.supportedProtocols, defaultProtocolList, specifiedProtocolsClient);
        this.defaultProtocolsServer = ProvSSLContextSpi.getDefaultEnabledProtocolsServer(this.supportedProtocols, defaultProtocolList);
    }

    int[] getActiveCipherSuites(JcaTlsCrypto crypto, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        String[] enabledCipherSuites = sslParameters.getCipherSuitesArray();
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        ProtocolVersion latest = ProtocolVersion.getLatestTLS(activeProtocolVersions);
        ProtocolVersion earliest = ProtocolVersion.getEarliestTLS(activeProtocolVersions);
        boolean post13Active = TlsUtils.isTLSv13(latest);
        boolean pre13Active = !TlsUtils.isTLSv13(earliest);
        int[] candidates = new int[enabledCipherSuites.length];
        int count = 0;
        for (String enabledCipherSuite : enabledCipherSuites) {
            CipherSuiteInfo candidate = this.supportedCipherSuites.get(enabledCipherSuite);
            if (null == candidate || (!candidate.isTLSv13() ? !pre13Active : !post13Active) || !algorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, enabledCipherSuite, null)) continue;
            candidates[count++] = candidate.getCipherSuite();
        }
        int[] result = TlsUtils.getSupportedCipherSuites(crypto, candidates, count);
        if (result.length < 1) {
            throw new IllegalStateException("No usable cipher suites enabled");
        }
        return result;
    }

    ProtocolVersion[] getActiveProtocolVersions(ProvSSLParameters sslParameters) {
        String[] enabledProtocols = sslParameters.getProtocolsArray();
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        TreeSet<ProtocolVersion> result = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion o1, ProtocolVersion o2) {
                return o1.isLaterVersionOf(o2) ? -1 : (o2.isLaterVersionOf(o1) ? 1 : 0);
            }
        });
        for (String enabledProtocol : enabledProtocols) {
            ProtocolVersion candidate = this.supportedProtocols.get(enabledProtocol);
            if (null == candidate || !algorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, enabledProtocol, null)) continue;
            result.add(candidate);
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("No usable protocols enabled");
        }
        return result.toArray(new ProtocolVersion[result.size()]);
    }

    String[] getDefaultCipherSuites(boolean isClient) {
        return (String[])this.implGetDefaultCipherSuites(isClient).clone();
    }

    String[] getDefaultProtocols(boolean isClient) {
        return (String[])this.implGetDefaultProtocols(isClient).clone();
    }

    ProvSSLParameters getDefaultSSLParameters(boolean isClient) {
        return new ProvSSLParameters(this, this.implGetDefaultCipherSuites(isClient), this.implGetDefaultProtocols(isClient));
    }

    String[] getSupportedCipherSuites() {
        return ProvSSLContextSpi.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedCipherSuites(String[] cipherSuites) {
        if (null == cipherSuites) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>(cipherSuites.length);
        for (String cipherSuite : cipherSuites) {
            if (TlsUtils.isNullOrEmpty(cipherSuite)) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(cipherSuite)) continue;
            result.add(cipherSuite);
        }
        return ProvSSLContextSpi.getArray(result);
    }

    String[] getSupportedProtocols() {
        return ProvSSLContextSpi.getKeysArray(this.supportedProtocols);
    }

    ProvSSLParameters getSupportedSSLParameters(boolean isClient) {
        return new ProvSSLParameters(this, this.getSupportedCipherSuites(), this.getSupportedProtocols());
    }

    boolean isFips() {
        return this.isInFipsMode;
    }

    boolean isSupportedProtocols(String[] protocols) {
        if (protocols == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (protocol != null && this.supportedProtocols.containsKey(protocol)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultSSLParameters(ProvSSLParameters sslParameters, boolean isClient) {
        if (sslParameters.getCipherSuitesArray() == this.implGetDefaultCipherSuites(!isClient)) {
            sslParameters.setCipherSuitesArray(this.implGetDefaultCipherSuites(isClient));
        }
        if (sslParameters.getProtocolsArray() == this.implGetDefaultProtocols(!isClient)) {
            sslParameters.setProtocolsArray(this.implGetDefaultProtocols(isClient));
        }
    }

    String validateNegotiatedCipherSuite(ProvSSLParameters sslParameters, int cipherSuite) {
        String name = ProvSSLContextSpi.getCipherSuiteName(cipherSuite);
        if (null == name || !JsseUtils.contains(sslParameters.getCipherSuitesArray(), name) || !sslParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, name, null) || !this.supportedCipherSuites.containsKey(name) || this.isInFipsMode && !FipsUtils.isFipsCipherSuite(name)) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + cipherSuite);
        }
        return name;
    }

    String validateNegotiatedProtocol(ProvSSLParameters sslParameters, ProtocolVersion protocol) {
        String name = ProvSSLContextSpi.getProtocolVersionName(protocol);
        if (null == name || !JsseUtils.contains(sslParameters.getProtocolsArray(), name) || !sslParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, name, null) || !this.supportedProtocols.containsKey(name) || this.isInFipsMode && !FipsUtils.isFipsProtocol(name)) {
            throw new IllegalStateException("SSL connection negotiated unsupported protocol: " + protocol);
        }
        return name;
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        return SSLEngineUtil.create(this.getContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String host, int port) {
        return SSLEngineUtil.create(this.getContextData(), host, port);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.getContextData().getClientSessionContext();
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.getContextData().getServerSessionContext();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new ProvSSLServerSocketFactory(this.getContextData());
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new ProvSSLSocketFactory(this.getContextData());
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        this.getContextData();
        return SSLParametersUtil.getSSLParameters(this.getDefaultSSLParameters(true));
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        this.getContextData();
        return SSLParametersUtil.getSSLParameters(this.getSupportedSSLParameters(true));
    }

    @Override
    protected synchronized void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.contextData = null;
        JcaTlsCrypto crypto = this.cryptoProvider.create(sr);
        JcaJceHelper helper = crypto.getHelper();
        BCX509ExtendedKeyManager x509KeyManager = this.selectX509KeyManager(helper, kms);
        BCX509ExtendedTrustManager x509TrustManager = this.selectX509TrustManager(helper, tms);
        crypto.getSecureRandom().nextInt();
        this.contextData = new ContextData(this, crypto, x509KeyManager, x509TrustManager);
    }

    protected synchronized ContextData getContextData() {
        if (null == this.contextData) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
        return this.contextData;
    }

    protected BCX509ExtendedKeyManager selectX509KeyManager(JcaJceHelper helper, KeyManager[] kms) throws KeyManagementException {
        if (kms != null) {
            for (KeyManager km : kms) {
                if (!(km instanceof X509KeyManager)) continue;
                return X509KeyManagerUtil.importX509KeyManager(helper, (X509KeyManager)km);
            }
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected BCX509ExtendedTrustManager selectX509TrustManager(JcaJceHelper helper, TrustManager[] tms) throws KeyManagementException {
        if (tms == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tms = tmf.getTrustManagers();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", e);
            }
        }
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                return X509TrustManagerUtil.importX509TrustManager(this.isInFipsMode, helper, (X509TrustManager)tm);
            }
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private String[] implGetDefaultCipherSuites(boolean isClient) {
        return isClient ? this.defaultCipherSuitesClient : this.defaultCipherSuitesServer;
    }

    private String[] implGetDefaultProtocols(boolean isClient) {
        return isClient ? this.defaultProtocolsClient : this.defaultProtocolsServer;
    }
}

