/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HistoryServerUtils
extends Enum<HistoryServerUtils> {
    private static final Logger LOG;
    private static final /* synthetic */ HistoryServerUtils[] $VALUES;

    public static HistoryServerUtils[] values() {
        return (HistoryServerUtils[])$VALUES.clone();
    }

    public static HistoryServerUtils valueOf(String name) {
        return Enum.valueOf(HistoryServerUtils.class, name);
    }

    public static boolean isSSLEnabled(Configuration config) {
        return (Boolean)config.get(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED) != false && SecurityOptions.isRestSSLEnabled((Configuration)config);
    }

    public static Optional<URL> getHistoryServerURL(Configuration configuration) {
        String hostname = HistoryServerUtils.getHostname(configuration);
        if (hostname != null) {
            String protocol = HistoryServerUtils.getProtocol(configuration);
            int port = HistoryServerUtils.getPort(configuration);
            try {
                return Optional.of(new URL(protocol, hostname, port, ""));
            }
            catch (MalformedURLException e) {
                LOG.debug("Could not create the HistoryServer's URL from protocol: {}, hostname: {} and port: {}.", new Object[]{protocol, hostname, port, e});
                return Optional.empty();
            }
        }
        LOG.debug("Not hostname has been specified for the HistoryServer. This indicates that it has not been started.");
        return Optional.empty();
    }

    private static int getPort(Configuration configuration) {
        return (Integer)configuration.get(HistoryServerOptions.HISTORY_SERVER_WEB_PORT);
    }

    @Nullable
    private static String getHostname(Configuration configuration) {
        return (String)configuration.get(HistoryServerOptions.HISTORY_SERVER_WEB_ADDRESS);
    }

    private static String getProtocol(Configuration configuration) {
        if (HistoryServerUtils.isSSLEnabled(configuration)) {
            return "https";
        }
        return "http";
    }

    private static /* synthetic */ HistoryServerUtils[] $values() {
        return new HistoryServerUtils[0];
    }

    static {
        $VALUES = HistoryServerUtils.$values();
        LOG = LoggerFactory.getLogger(HistoryServerUtils.class);
    }
}

