/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.InternalStateIterator;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class CompleteStateIterator<T>
implements InternalStateIterator<T> {
    final Iterable<T> iterable;
    final boolean empty;

    public CompleteStateIterator(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            this.iterable = Collections.emptyList();
            this.empty = true;
        } else {
            this.iterable = iterable;
            this.empty = !iterable.iterator().hasNext();
        }
    }

    public <U> StateFuture<Collection<U>> onNext(FunctionWithException<T, StateFuture<? extends U>, Exception> iterating) {
        if (this.isEmpty()) {
            return StateFutureUtils.completedFuture(Collections.emptyList());
        }
        ArrayList<StateFuture> resultFutures = new ArrayList<StateFuture>();
        try {
            for (T item : this.iterable) {
                resultFutures.add((StateFuture)iterating.apply(item));
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to iterate over state.", (Throwable)e);
        }
        return StateFutureUtils.combineAll(resultFutures);
    }

    public StateFuture<Void> onNext(ThrowingConsumer<T, Exception> iterating) {
        try {
            for (T item : this.iterable) {
                iterating.accept(item);
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to iterate over state.", (Throwable)e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean hasNextLoading() {
        return false;
    }

    public Iterable<T> getCurrentCache() {
        return this.iterable;
    }
}

