/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.WindowedValue;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class StreamRecordMatchers {
    public static <T> Matcher<StreamRecord<? extends T>> streamRecord(T value) {
        return StreamRecordMatchers.streamRecord(Matchers.equalTo(value));
    }

    public static <T> Matcher<StreamRecord<? extends T>> streamRecord(T value, long timestamp) {
        return StreamRecordMatchers.streamRecord(Matchers.equalTo(value), (Matcher<? super Long>)Matchers.equalTo((Object)timestamp));
    }

    public static <T> Matcher<StreamRecord<? extends T>> streamRecord(Matcher<? super T> valueMatcher) {
        return new StreamRecordMatcher<T>(valueMatcher, (Matcher<? super Long>)Matchers.anything());
    }

    public static <T> Matcher<StreamRecord<? extends T>> streamRecord(Matcher<? super T> valueMatcher, Matcher<? super Long> timestampMatcher) {
        return new StreamRecordMatcher<T>(valueMatcher, timestampMatcher);
    }

    public static Matcher<TimeWindow> timeWindow(long start, long end) {
        return Matchers.equalTo((Object)new TimeWindow(start, end));
    }

    @SafeVarargs
    public static <W extends Window> Matcher<Iterable<W>> ofWindows(Matcher<W> ... windows) {
        return Matchers.containsInAnyOrder(windows);
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(T value) {
        return StreamRecordMatchers.isWindowedValue(Matchers.equalTo(value));
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(T value, long timestamp) {
        return StreamRecordMatchers.isWindowedValue(Matchers.equalTo(value), (Matcher<? super Long>)Matchers.equalTo((Object)timestamp));
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(T value, long timestamp, W window) {
        return StreamRecordMatchers.isWindowedValue(Matchers.equalTo(value), (Matcher<? super Long>)Matchers.equalTo((Object)timestamp), Matchers.equalTo(window));
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher, long timestamp) {
        return new WindowedValueMatcher(valueMatcher, (Matcher<? super Long>)Matchers.equalTo((Object)timestamp), Matchers.anything());
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher, long timestamp, W window) {
        return new WindowedValueMatcher(valueMatcher, (Matcher<? super Long>)Matchers.equalTo((Object)timestamp), Matchers.equalTo(window));
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher) {
        return new WindowedValueMatcher(valueMatcher, (Matcher<? super Long>)Matchers.anything(), Matchers.anything());
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher, Matcher<? super Long> timestampMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, Matchers.anything());
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher, long timestamp, Matcher<? super W> windowMatcher) {
        return new WindowedValueMatcher<T, W>(valueMatcher, (Matcher<? super Long>)Matchers.equalTo((Object)timestamp), windowMatcher);
    }

    public static <T, W extends Window> Matcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> isWindowedValue(Matcher<? super T> valueMatcher, Matcher<? super Long> timestampMatcher, Matcher<? super W> windowMatcher) {
        return new WindowedValueMatcher<T, W>(valueMatcher, timestampMatcher, windowMatcher);
    }

    private StreamRecordMatchers() {
    }

    private static class StreamRecordMatcher<T>
    extends TypeSafeMatcher<StreamRecord<? extends T>> {
        private Matcher<? super T> valueMatcher;
        private Matcher<? super Long> timestampMatcher;

        private StreamRecordMatcher(Matcher<? super T> valueMatcher, Matcher<? super Long> timestampMatcher) {
            this.valueMatcher = valueMatcher;
            this.timestampMatcher = timestampMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("a StreamRecordValue(").appendValue(this.valueMatcher).appendText(", ").appendValue(this.timestampMatcher).appendText(")");
        }

        protected boolean matchesSafely(StreamRecord<? extends T> streamRecord) {
            return this.valueMatcher.matches(streamRecord.getValue()) && this.timestampMatcher.matches((Object)streamRecord.getTimestamp());
        }
    }

    private static class WindowedValueMatcher<T, W extends Window>
    extends TypeSafeMatcher<StreamRecord<? extends WindowedValue<? extends T, ? extends W>>> {
        private Matcher<? super T> valueMatcher;
        private Matcher<? super Long> timestampMatcher;
        private Matcher<? super W> windowMatcher;

        private WindowedValueMatcher(Matcher<? super T> valueMatcher, Matcher<? super Long> timestampMatcher, Matcher<? super W> windowMatcher) {
            this.valueMatcher = valueMatcher;
            this.timestampMatcher = timestampMatcher;
            this.windowMatcher = windowMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("a WindowedValue(").appendValue(this.valueMatcher).appendText(", ").appendValue(this.timestampMatcher).appendText(", ").appendValue(this.timestampMatcher).appendText(")");
        }

        protected boolean matchesSafely(StreamRecord<? extends WindowedValue<? extends T, ? extends W>> streamRecord) {
            return this.valueMatcher.matches(((WindowedValue)streamRecord.getValue()).value()) && this.timestampMatcher.matches((Object)streamRecord.getTimestamp()) && this.windowMatcher.matches(((WindowedValue)streamRecord.getValue()).window());
        }
    }
}

