/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.graph;

import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TranslationTest {
    TranslationTest() {
    }

    @Test
    void testCheckpointModeTranslation() {
        StreamExecutionEnvironment deactivated = TranslationTest.getSimpleJob();
        for (Object vertex : deactivated.getStreamGraph().getJobGraph().getVertices()) {
            Assertions.assertThat((Comparable)new StreamConfig(vertex.getConfiguration()).getCheckpointMode()).isEqualTo((Object)CheckpointingMode.AT_LEAST_ONCE);
        }
        StreamExecutionEnvironment activated = TranslationTest.getSimpleJob();
        activated.enableCheckpointing(1000L);
        for (JobVertex vertex : activated.getStreamGraph().getJobGraph().getVertices()) {
            Assertions.assertThat((Comparable)new StreamConfig(vertex.getConfiguration()).getCheckpointMode()).isEqualTo((Object)CheckpointingMode.EXACTLY_ONCE);
        }
        StreamExecutionEnvironment explicit = TranslationTest.getSimpleJob();
        explicit.enableCheckpointing(1000L, CheckpointingMode.AT_LEAST_ONCE);
        for (JobVertex vertex : explicit.getStreamGraph().getJobGraph().getVertices()) {
            Assertions.assertThat((Comparable)new StreamConfig(vertex.getConfiguration()).getCheckpointMode()).isEqualTo((Object)CheckpointingMode.AT_LEAST_ONCE);
        }
    }

    private static StreamExecutionEnvironment getSimpleJob() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(1L, 10000000L).addSink((SinkFunction)new SinkFunction<Long>(){

            public void invoke(Long value) {
            }
        });
        return env;
    }
}

