/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.api.operators.co.IntervalJoinOperator;
import org.assertj.core.api.Condition;

class BufferEntrySerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<IntervalJoinOperator.BufferEntry<String>, IntervalJoinOperator.BufferEntry<String>> {
    BufferEntrySerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("buffer-entry-serializer", flinkVersion, BufferEntrySerializerSetup.class, BufferEntrySerializerVerifier.class));
        return testSpecifications;
    }

    public static final class BufferEntrySerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<IntervalJoinOperator.BufferEntry<String>> {
        public TypeSerializer<IntervalJoinOperator.BufferEntry<String>> createPriorSerializer() {
            return new IntervalJoinOperator.BufferEntrySerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public IntervalJoinOperator.BufferEntry<String> createTestData() {
            return new IntervalJoinOperator.BufferEntry((Object)"hello", false);
        }
    }

    public static final class BufferEntrySerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<IntervalJoinOperator.BufferEntry<String>> {
        public TypeSerializer<IntervalJoinOperator.BufferEntry<String>> createUpgradedSerializer() {
            return new IntervalJoinOperator.BufferEntrySerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<IntervalJoinOperator.BufferEntry<String>> testDataCondition() {
            return new Condition(stringBufferEntry -> Objects.equals(stringBufferEntry.getElement(), "hello") && !stringBufferEntry.hasBeenJoined(), "buffer entry with element 'hello' and left buffer flag", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<IntervalJoinOperator.BufferEntry<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }
}

