/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.NoOpTransientBlobService;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElection;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.VoidMetricFetcher;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.runtime.webmonitor.TestingExecutionGraphCache;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.util.ExecutorUtils;
import org.junit.jupiter.api.Test;

class WebMonitorEndpointTest {
    WebMonitorEndpointTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void cleansUpExpiredExecutionGraphs() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(RestOptions.ADDRESS, (Object)"localhost");
        configuration.set(WebOptions.REFRESH_INTERVAL, (Object)Duration.ofMillis(5L));
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        long timeout = 10000L;
        OneShotLatch cleanupLatch = new OneShotLatch();
        TestingExecutionGraphCache executionGraphCache = TestingExecutionGraphCache.newBuilder().setCleanupRunnable(() -> ((OneShotLatch)cleanupLatch).trigger()).build();
        try (WebMonitorEndpoint webMonitorEndpoint = new WebMonitorEndpoint(CompletableFuture::new, configuration, RestHandlerConfiguration.fromConfiguration((Configuration)configuration), CompletableFuture::new, (TransientBlobService)NoOpTransientBlobService.INSTANCE, executor, (MetricFetcher)VoidMetricFetcher.INSTANCE, (LeaderElection)new StandaloneLeaderElection(UUID.randomUUID()), (ExecutionGraphCache)executionGraphCache, (FatalErrorHandler)new TestingFatalErrorHandler());){
            webMonitorEndpoint.start();
            cleanupLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }
}

