/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.TestingPluginManager;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.RunnableWithException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class FileStateHandleTest {
    private static final String TEST_SCHEME = "test";

    FileStateHandleTest() {
    }

    private static Path resolve(String ... segments) {
        return new Path("test://" + String.join((CharSequence)"/", segments));
    }

    @Test
    void testDisposeDoesNotDeleteParentDirectory() throws Exception {
        Path p = FileStateHandleTest.resolve("path", "with", "parent");
        ArrayList pathsToDelete = new ArrayList();
        FileStateHandleTest.initializeFileSystem((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(path, ignoredRecursionMarker) -> {
            pathsToDelete.add(path);
            return true;
        })).build());
        FileStateHandle handle = new FileStateHandle(p, 42L);
        handle.discardState();
        ((ObjectAssert)((ListAssert)Assertions.assertThat(pathsToDelete).as("Only one delete call should have happened on the actual path but not the parent.", new Object[0])).singleElement()).isEqualTo((Object)p);
    }

    @Test
    void testDiscardStateForNonExistingFileWithoutAnErrorBeingExposedByTheFileSystem() throws Exception {
        this.testDiscardStateForNonExistingFile((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(ignoredPath, ignoredRecursionMarker) -> true)).setExistsFunction((FunctionWithException<Path, Boolean, IOException>)((FunctionWithException)path -> (Boolean)org.junit.jupiter.api.Assertions.fail((String)"The exists call should not have been triggered. This call should be avoided because it might be quite expensive in object stores."))).build());
    }

    @Test
    void testDiscardStateForNonExistingFileWithDeleteCallReturningFalse() throws Exception {
        this.testDiscardStateForNonExistingFile((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(ignoredPath, ignoredRecursionMarker) -> false)).setExistsFunction((FunctionWithException<Path, Boolean, IOException>)((FunctionWithException)path -> false)).build());
    }

    @Test
    void testDiscardStateForNonExistingFileWithEDeleteCallFailing() throws Exception {
        this.testDiscardStateForNonExistingFile((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(ignoredPath, ignoredRecursionMarker) -> {
            throw new IOException("Expected IOException caused by FileSystem.delete.");
        })).setExistsFunction((FunctionWithException<Path, Boolean, IOException>)((FunctionWithException)path -> false)).build());
    }

    private void testDiscardStateForNonExistingFile(FileSystem fileSystem) throws Exception {
        FileStateHandleTest.runInFileSystemContext(fileSystem, () -> {
            FileStateHandle handle = new FileStateHandle(FileStateHandleTest.resolve("path", "to", "state"), 0L);
            handle.discardState();
        });
    }

    @Test
    void testDiscardStateWithDeletionFailureThroughException() throws Exception {
        FileStateHandleTest.testDiscardStateFailed((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(ignoredPath, ignoredRecursionMarker) -> {
            throw new IOException("Expected IOException to simulate IO error.");
        })).setExistsFunction((FunctionWithException<Path, Boolean, IOException>)((FunctionWithException)path -> true)).build());
    }

    @Test
    void testDiscardStateWithDeletionFailureThroughReturnValue() throws Exception {
        FileStateHandleTest.testDiscardStateFailed((FileSystem)MockedLocalFileSystem.newBuilder().setDeleteFunction((BiFunctionWithException<Path, Boolean, Boolean, IOException>)((BiFunctionWithException)(ignoredPath, ignoredRecursionMarker) -> false)).setExistsFunction((FunctionWithException<Path, Boolean, IOException>)((FunctionWithException)path -> true)).build());
    }

    @Test
    void testCollectSizeStats() throws Exception {
        long stateSize = 123L;
        StateObject.StateObjectSizeStatsCollector statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        FileStateHandle handle = new FileStateHandle(new Path(new URI("file:///home/test.txt")), 123L);
        handle.collectSizeStats(statsCollector);
        this.checkStats(statsCollector, StateObject.StateObjectLocation.LOCAL_DISK, 123L);
        statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        handle = new FileStateHandle(new Path(new URI("/home/test.txt")), 123L);
        handle.collectSizeStats(statsCollector);
        this.checkStats(statsCollector, StateObject.StateObjectLocation.LOCAL_DISK, 123L);
        statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        handle = new FileStateHandle(new Path(new URI("s3:///folder/test.txt")), 123L);
        handle.collectSizeStats(statsCollector);
        this.checkStats(statsCollector, StateObject.StateObjectLocation.REMOTE, 123L);
    }

    private void checkStats(StateObject.StateObjectSizeStatsCollector statsCollector, final StateObject.StateObjectLocation expectedLocation, final long expectedSize) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HashMap<StateObject.StateObjectLocation, Long>(){
            {
                this.put(expectedLocation, expectedSize);
            }
        }, (Object)statsCollector.getStats());
    }

    private static void testDiscardStateFailed(FileSystem fileSystem) throws Exception {
        FileStateHandleTest.runInFileSystemContext(fileSystem, () -> {
            FileStateHandle handle = new FileStateHandle(FileStateHandleTest.resolve("path", "to", "state"), 0L);
            org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> ((FileStateHandle)handle).discardState());
        });
    }

    private static void runInFileSystemContext(FileSystem fileSystem, RunnableWithException testCallback) throws Exception {
        FileStateHandleTest.initializeFileSystem(fileSystem);
        try {
            testCallback.run();
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration(), null);
        }
    }

    private static void initializeFileSystem(FileSystem fileSystem) {
        HashMap<Class<FileSystemFactory>, Iterator<TestingFileSystemFactory>> fileSystemPlugins = new HashMap<Class<FileSystemFactory>, Iterator<TestingFileSystemFactory>>();
        fileSystemPlugins.put(FileSystemFactory.class, Collections.singletonList(new TestingFileSystemFactory(TEST_SCHEME, fileSystem)).iterator());
        FileSystem.initialize((Configuration)new Configuration(), (PluginManager)new TestingPluginManager(fileSystemPlugins));
    }

    private static class MockedLocalFileSystem
    extends LocalFileSystem {
        private final BiFunctionWithException<Path, Boolean, Boolean, IOException> deleteFunction;
        private final FunctionWithException<Path, Boolean, IOException> existsFunction;

        public MockedLocalFileSystem(BiFunctionWithException<Path, Boolean, Boolean, IOException> deleteFunction, FunctionWithException<Path, Boolean, IOException> existsFunction) {
            this.deleteFunction = deleteFunction;
            this.existsFunction = existsFunction;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return (Boolean)this.deleteFunction.apply((Object)f, (Object)recursive);
        }

        public boolean exists(Path f) throws IOException {
            return (Boolean)this.existsFunction.apply((Object)f);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        private static class Builder {
            private BiFunctionWithException<Path, Boolean, Boolean, IOException> deleteFunction = (ignoredPath, ignoredRecursionMarker) -> true;
            private FunctionWithException<Path, Boolean, IOException> existsFunction = ignoredPath -> true;

            private Builder() {
            }

            public Builder setDeleteFunction(BiFunctionWithException<Path, Boolean, Boolean, IOException> deleteFunction) {
                this.deleteFunction = deleteFunction;
                return this;
            }

            public Builder setExistsFunction(FunctionWithException<Path, Boolean, IOException> existsFunction) {
                this.existsFunction = existsFunction;
                return this;
            }

            public MockedLocalFileSystem build() {
                return new MockedLocalFileSystem(this.deleteFunction, this.existsFunction);
            }
        }
    }

    private static class TestingFileSystemFactory
    implements FileSystemFactory {
        private final String scheme;
        private final FileSystem fileSystem;

        public TestingFileSystemFactory(String scheme, FileSystem fileSystem) {
            this.scheme = scheme;
            this.fileSystem = fileSystem;
        }

        public String getScheme() {
            return this.scheme;
        }

        public FileSystem create(URI fsUri) throws IOException {
            return this.fileSystem;
        }
    }
}

