/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token.hadoop;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.runtime.security.token.hadoop.HadoopDelegationTokenConverter;
import org.apache.flink.runtime.security.token.hadoop.HadoopDelegationTokenReceiver;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HadoopDelegationTokenReceiverITCase {
    @Test
    public void onNewTokensObtainedShouldThrowExceptionWhenNullCredentials() {
        this.onNewTokensObtainedShouldThrowException(null);
    }

    @Test
    public void onNewTokensObtainedShouldThrowExceptionWhenEmptyCredentials() {
        this.onNewTokensObtainedShouldThrowException(new byte[0]);
    }

    private void onNewTokensObtainedShouldThrowException(byte[] credentialsBytes) {
        HadoopDelegationTokenReceiver receiver = new HadoopDelegationTokenReceiver(){

            public String serviceName() {
                return "test";
            }
        };
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> receiver.onNewTokensObtained(credentialsBytes));
        Assertions.assertTrue((boolean)e.getMessage().contains("Illegal tokens"));
    }

    @Test
    public void onNewTokensObtainedShouldOverwriteCredentials() throws Exception {
        Text tokenKind = new Text("TEST_TOKEN_KIND");
        Text tokenService = new Text("TEST_TOKEN_SERVICE");
        Credentials credentials = new Credentials();
        credentials.addToken(tokenService, new Token(new byte[4], new byte[4], tokenKind, tokenService));
        byte[] credentialsBytes = HadoopDelegationTokenConverter.serialize((Credentials)credentials);
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            HadoopDelegationTokenReceiver receiver = new HadoopDelegationTokenReceiver(){

                public String serviceName() {
                    return "test";
                }
            };
            receiver.onNewTokensObtained(credentialsBytes);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Credentials.class);
            ((UserGroupInformation)Mockito.verify((Object)userGroupInformation, (VerificationMode)Mockito.times((int)1))).addCredentials((Credentials)argumentCaptor.capture());
            Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)credentials.getAllTokens(), (Collection)((Credentials)argumentCaptor.getValue()).getAllTokens()));
        }
    }
}

