/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.failover.SchedulingPipelinedRegionComputeUtil;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.SchedulingTopologyListener;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingTopology
implements SchedulingTopology {
    private final Map<ExecutionVertexID, TestingSchedulingExecutionVertex> schedulingExecutionVertices = new LinkedHashMap<ExecutionVertexID, TestingSchedulingExecutionVertex>();
    private final Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> schedulingResultPartitions = new HashMap<IntermediateResultPartitionID, TestingSchedulingResultPartition>();
    private Map<ExecutionVertexID, TestingSchedulingPipelinedRegion> vertexRegions;

    public Iterable<TestingSchedulingExecutionVertex> getVertices() {
        return Collections.unmodifiableCollection(this.schedulingExecutionVertices.values());
    }

    public TestingSchedulingExecutionVertex getVertex(ExecutionVertexID executionVertexId) {
        TestingSchedulingExecutionVertex executionVertex = this.schedulingExecutionVertices.get(executionVertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException("can not find vertex: " + executionVertexId);
        }
        return executionVertex;
    }

    public TestingSchedulingResultPartition getResultPartition(IntermediateResultPartitionID intermediateResultPartitionId) {
        TestingSchedulingResultPartition resultPartition = this.schedulingResultPartitions.get(intermediateResultPartitionId);
        if (resultPartition == null) {
            throw new IllegalArgumentException("can not find partition: " + intermediateResultPartitionId);
        }
        return resultPartition;
    }

    public void registerSchedulingTopologyListener(SchedulingTopologyListener listener) {
    }

    public Iterable<SchedulingPipelinedRegion> getAllPipelinedRegions() {
        return new HashSet<SchedulingPipelinedRegion>(this.getVertexRegions().values());
    }

    public SchedulingPipelinedRegion getPipelinedRegionOfVertex(ExecutionVertexID vertexId) {
        return this.getVertexRegions().get(vertexId);
    }

    private Map<ExecutionVertexID, TestingSchedulingPipelinedRegion> getVertexRegions() {
        if (this.vertexRegions == null) {
            this.generatePipelinedRegions();
        }
        return this.vertexRegions;
    }

    private void generatePipelinedRegions() {
        this.vertexRegions = new HashMap<ExecutionVertexID, TestingSchedulingPipelinedRegion>();
        Set rawRegions = SchedulingPipelinedRegionComputeUtil.computePipelinedRegions(this.getVertices(), this::getVertex, this::getResultPartition);
        for (Set rawRegion : rawRegions) {
            Set<TestingSchedulingExecutionVertex> vertices = rawRegion.stream().map(vertex -> this.schedulingExecutionVertices.get(vertex.getId())).collect(Collectors.toSet());
            TestingSchedulingPipelinedRegion region = new TestingSchedulingPipelinedRegion(vertices);
            for (TestingSchedulingExecutionVertex vertex2 : vertices) {
                this.vertexRegions.put(vertex2.getId(), region);
            }
        }
    }

    private void resetPipelinedRegions() {
        this.vertexRegions = null;
    }

    void addSchedulingExecutionVertex(TestingSchedulingExecutionVertex schedulingExecutionVertex) {
        Preconditions.checkState((!this.schedulingExecutionVertices.containsKey(schedulingExecutionVertex.getId()) ? 1 : 0) != 0);
        this.schedulingExecutionVertices.put(schedulingExecutionVertex.getId(), schedulingExecutionVertex);
        this.updateVertexResultPartitions(schedulingExecutionVertex);
        this.resetPipelinedRegions();
    }

    private void updateVertexResultPartitions(TestingSchedulingExecutionVertex schedulingExecutionVertex) {
        this.addSchedulingResultPartitions(schedulingExecutionVertex.getConsumedResults());
        this.addSchedulingResultPartitions(schedulingExecutionVertex.getProducedResults());
    }

    private void addSchedulingResultPartitions(Iterable<TestingSchedulingResultPartition> resultPartitions) {
        for (TestingSchedulingResultPartition schedulingResultPartition : resultPartitions) {
            this.schedulingResultPartitions.put(schedulingResultPartition.getId(), schedulingResultPartition);
        }
    }

    void addSchedulingExecutionVertices(List<TestingSchedulingExecutionVertex> vertices) {
        for (TestingSchedulingExecutionVertex vertex : vertices) {
            this.addSchedulingExecutionVertex(vertex);
        }
    }

    public SchedulingExecutionVerticesBuilder addExecutionVertices() {
        return new SchedulingExecutionVerticesBuilder();
    }

    public TestingSchedulingExecutionVertex newExecutionVertex() {
        return this.newExecutionVertex(new JobVertexID(), 0);
    }

    public TestingSchedulingExecutionVertex newExecutionVertex(ExecutionState executionState) {
        TestingSchedulingExecutionVertex newVertex = TestingSchedulingExecutionVertex.newBuilder().withExecutionState(executionState).build();
        this.addSchedulingExecutionVertex(newVertex);
        return newVertex;
    }

    public TestingSchedulingExecutionVertex newExecutionVertex(JobVertexID jobVertexId, int subtaskIndex) {
        TestingSchedulingExecutionVertex newVertex = TestingSchedulingExecutionVertex.withExecutionVertexID(jobVertexId, subtaskIndex);
        this.addSchedulingExecutionVertex(newVertex);
        return newVertex;
    }

    public TestingSchedulingTopology connect(TestingSchedulingExecutionVertex producer, TestingSchedulingExecutionVertex consumer) {
        return this.connect(producer, consumer, ResultPartitionType.PIPELINED);
    }

    public TestingSchedulingTopology connect(TestingSchedulingExecutionVertex producer, TestingSchedulingExecutionVertex consumer, ResultPartitionType resultPartitionType) {
        TestingSchedulingTopology.connectConsumersToProducers(Collections.singletonList(consumer), Collections.singletonList(producer), new IntermediateDataSetID(), resultPartitionType, ResultPartitionState.ALL_DATA_PRODUCED);
        this.updateVertexResultPartitions(producer);
        this.updateVertexResultPartitions(consumer);
        this.resetPipelinedRegions();
        return this;
    }

    public ProducerConsumerConnectionBuilder connectPointwise(List<TestingSchedulingExecutionVertex> producers, List<TestingSchedulingExecutionVertex> consumers) {
        return new ProducerConsumerPointwiseConnectionBuilder(producers, consumers);
    }

    public ProducerConsumerConnectionBuilder connectAllToAll(List<TestingSchedulingExecutionVertex> producers, List<TestingSchedulingExecutionVertex> consumers) {
        return new ProducerConsumerAllToAllConnectionBuilder(producers, consumers);
    }

    private static List<TestingSchedulingResultPartition> connectConsumersToProducers(List<TestingSchedulingExecutionVertex> consumers, List<TestingSchedulingExecutionVertex> producers, IntermediateDataSetID intermediateDataSetId, ResultPartitionType resultPartitionType, ResultPartitionState resultPartitionState) {
        ArrayList<TestingSchedulingResultPartition> resultPartitions = new ArrayList<TestingSchedulingResultPartition>();
        ConnectionResult connectionResult = TestingSchedulingTopology.connectConsumersToProducersById(consumers.stream().map(Vertex::getId).collect(Collectors.toList()), producers.stream().map(Vertex::getId).collect(Collectors.toList()), intermediateDataSetId, resultPartitionType);
        ConsumedPartitionGroup consumedPartitionGroup = connectionResult.getConsumedPartitionGroup();
        ConsumerVertexGroup consumerVertexGroup = connectionResult.getConsumerVertexGroup();
        TestingSchedulingResultPartition.Builder resultPartitionBuilder = new TestingSchedulingResultPartition.Builder().withIntermediateDataSetID(intermediateDataSetId).withResultPartitionType(resultPartitionType).withResultPartitionState(resultPartitionState);
        for (int i = 0; i < producers.size(); ++i) {
            TestingSchedulingExecutionVertex producer = producers.get(i);
            IntermediateResultPartitionID partitionId = connectionResult.getResultPartitions().get(i);
            TestingSchedulingResultPartition resultPartition = resultPartitionBuilder.withPartitionNum(partitionId.getPartitionNumber()).build();
            producer.addProducedPartition(resultPartition);
            resultPartition.setProducer(producer);
            resultPartitions.add(resultPartition);
            resultPartition.registerConsumedPartitionGroup(consumedPartitionGroup);
            resultPartition.addConsumerGroup(consumerVertexGroup);
            if (resultPartition.getState() != ResultPartitionState.ALL_DATA_PRODUCED) continue;
            consumedPartitionGroup.partitionFinished();
        }
        Map<IntermediateResultPartitionID, TestingSchedulingResultPartition> consumedPartitionById = resultPartitions.stream().collect(Collectors.toMap(TestingSchedulingResultPartition::getId, Function.identity()));
        for (TestingSchedulingExecutionVertex consumer : consumers) {
            consumer.addConsumedPartitionGroup(consumedPartitionGroup, consumedPartitionById);
        }
        return resultPartitions;
    }

    public static ConnectionResult connectConsumersToProducersById(List<ExecutionVertexID> consumers, List<ExecutionVertexID> producers, IntermediateDataSetID intermediateDataSetId, ResultPartitionType resultPartitionType) {
        ArrayList<IntermediateResultPartitionID> resultPartitions = new ArrayList<IntermediateResultPartitionID>();
        for (ExecutionVertexID producer : producers) {
            IntermediateResultPartitionID resultPartition = new IntermediateResultPartitionID(intermediateDataSetId, producer.getSubtaskIndex());
            resultPartitions.add(resultPartition);
        }
        ConsumedPartitionGroup consumedPartitionGroup = TestingSchedulingTopology.createConsumedPartitionGroup(consumers.size(), resultPartitions, resultPartitionType);
        ConsumerVertexGroup consumerVertexGroup = TestingSchedulingTopology.createConsumerVertexGroup(consumers, resultPartitionType);
        consumedPartitionGroup.setConsumerVertexGroup(consumerVertexGroup);
        consumerVertexGroup.setConsumedPartitionGroup(consumedPartitionGroup);
        return new ConnectionResult(resultPartitions, consumedPartitionGroup, consumerVertexGroup);
    }

    private static ConsumedPartitionGroup createConsumedPartitionGroup(int numConsumers, List<IntermediateResultPartitionID> consumedPartitions, ResultPartitionType resultPartitionType) {
        return ConsumedPartitionGroup.fromMultiplePartitions((int)numConsumers, consumedPartitions, (ResultPartitionType)resultPartitionType);
    }

    private static ConsumerVertexGroup createConsumerVertexGroup(List<ExecutionVertexID> consumers, ResultPartitionType resultPartitionType) {
        return ConsumerVertexGroup.fromMultipleVertices(consumers, (ResultPartitionType)resultPartitionType);
    }

    public class SchedulingExecutionVerticesBuilder {
        private JobVertexID jobVertexId = new JobVertexID();
        private int parallelism = 1;

        public SchedulingExecutionVerticesBuilder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public SchedulingExecutionVerticesBuilder withJobVertexID(JobVertexID jobVertexId) {
            this.jobVertexId = jobVertexId;
            return this;
        }

        public List<TestingSchedulingExecutionVertex> finish() {
            ArrayList<TestingSchedulingExecutionVertex> vertices = new ArrayList<TestingSchedulingExecutionVertex>();
            for (int subtaskIndex = 0; subtaskIndex < this.parallelism; ++subtaskIndex) {
                vertices.add(this.createTestingSchedulingExecutionVertex(subtaskIndex));
            }
            TestingSchedulingTopology.this.addSchedulingExecutionVertices(vertices);
            return vertices;
        }

        private TestingSchedulingExecutionVertex createTestingSchedulingExecutionVertex(int subtaskIndex) {
            return TestingSchedulingExecutionVertex.newBuilder().withExecutionVertexID(this.jobVertexId, subtaskIndex).build();
        }
    }

    private class ProducerConsumerPointwiseConnectionBuilder
    extends ProducerConsumerConnectionBuilder {
        private ProducerConsumerPointwiseConnectionBuilder(List<TestingSchedulingExecutionVertex> producers, List<TestingSchedulingExecutionVertex> consumers) {
            super(producers, consumers);
            Preconditions.checkState((producers.size() == consumers.size() ? 1 : 0) != 0);
        }

        @Override
        protected List<TestingSchedulingResultPartition> connect() {
            ArrayList<TestingSchedulingResultPartition> resultPartitions = new ArrayList<TestingSchedulingResultPartition>();
            IntermediateDataSetID intermediateDataSetId = new IntermediateDataSetID();
            for (int idx = 0; idx < this.producers.size(); ++idx) {
                resultPartitions.addAll(TestingSchedulingTopology.connectConsumersToProducers(Collections.singletonList((TestingSchedulingExecutionVertex)this.consumers.get(idx)), Collections.singletonList((TestingSchedulingExecutionVertex)this.producers.get(idx)), intermediateDataSetId, this.resultPartitionType, this.resultPartitionState));
            }
            return resultPartitions;
        }
    }

    private class ProducerConsumerAllToAllConnectionBuilder
    extends ProducerConsumerConnectionBuilder {
        private ProducerConsumerAllToAllConnectionBuilder(List<TestingSchedulingExecutionVertex> producers, List<TestingSchedulingExecutionVertex> consumers) {
            super(producers, consumers);
        }

        @Override
        protected List<TestingSchedulingResultPartition> connect() {
            return TestingSchedulingTopology.connectConsumersToProducers(this.consumers, this.producers, new IntermediateDataSetID(), this.resultPartitionType, this.resultPartitionState);
        }
    }

    public static class ConnectionResult {
        private final List<IntermediateResultPartitionID> resultPartitions;
        private final ConsumedPartitionGroup consumedPartitionGroup;
        private final ConsumerVertexGroup consumerVertexGroup;

        public ConnectionResult(List<IntermediateResultPartitionID> resultPartitions, ConsumedPartitionGroup consumedPartitionGroup, ConsumerVertexGroup consumerVertexGroup) {
            this.resultPartitions = (List)Preconditions.checkNotNull(resultPartitions);
            this.consumedPartitionGroup = (ConsumedPartitionGroup)Preconditions.checkNotNull((Object)consumedPartitionGroup);
            this.consumerVertexGroup = (ConsumerVertexGroup)Preconditions.checkNotNull((Object)consumerVertexGroup);
        }

        public List<IntermediateResultPartitionID> getResultPartitions() {
            return this.resultPartitions;
        }

        public ConsumedPartitionGroup getConsumedPartitionGroup() {
            return this.consumedPartitionGroup;
        }

        public ConsumerVertexGroup getConsumerVertexGroup() {
            return this.consumerVertexGroup;
        }
    }

    public abstract class ProducerConsumerConnectionBuilder {
        protected final List<TestingSchedulingExecutionVertex> producers;
        protected final List<TestingSchedulingExecutionVertex> consumers;
        protected ResultPartitionType resultPartitionType = ResultPartitionType.BLOCKING;
        protected ResultPartitionState resultPartitionState = ResultPartitionState.ALL_DATA_PRODUCED;

        protected ProducerConsumerConnectionBuilder(List<TestingSchedulingExecutionVertex> producers, List<TestingSchedulingExecutionVertex> consumers) {
            this.producers = producers;
            this.consumers = consumers;
        }

        public ProducerConsumerConnectionBuilder withResultPartitionType(ResultPartitionType resultPartitionType) {
            this.resultPartitionType = resultPartitionType;
            return this;
        }

        public ProducerConsumerConnectionBuilder withResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
            return this;
        }

        public List<TestingSchedulingResultPartition> finish() {
            List<TestingSchedulingResultPartition> resultPartitions = this.connect();
            this.producers.stream().forEach(x$0 -> TestingSchedulingTopology.this.updateVertexResultPartitions((TestingSchedulingExecutionVertex)x$0));
            this.consumers.stream().forEach(x$0 -> TestingSchedulingTopology.this.updateVertexResultPartitions((TestingSchedulingExecutionVertex)x$0));
            return resultPartitions;
        }

        protected abstract List<TestingSchedulingResultPartition> connect();
    }
}

